/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ProxyProtocolCombinedEngine;
import org.apache.kafka.common.network.ProxyProtocolV1Engine;
import org.apache.kafka.common.network.ProxyProtocolV2Engine;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ProxyProtocolCombinedEngineTest {
    private ProxyProtocolCombinedEngine engine;

    @BeforeEach
    public void setUp() {
        this.engine = new ProxyProtocolCombinedEngine(ConnectionMode.SERVER, new LogContext());
    }

    @Test
    public void testActiveEngineAsV1Engine() throws IOException {
        ByteBuffer buf = ByteBuffer.wrap("PROXY TCP4 192.168.0.1 192.168.0.2 12345 80\r\n".getBytes(StandardCharsets.US_ASCII));
        this.engine.processHeaders(buf);
        Assertions.assertInstanceOf(ProxyProtocolV1Engine.class, (Object)this.engine.getActiveEngine());
        Assertions.assertTrue((boolean)this.engine.hasClientInformation());
        Assertions.assertTrue((boolean)this.engine.ready());
        Assertions.assertEquals((Object)InetAddress.getByName("192.168.0.1"), (Object)this.engine.clientAddress());
        Assertions.assertEquals((int)12345, (int)this.engine.clientPort());
    }

    @Test
    public void testActiveEngineAsV2Engine() throws IOException {
        String headerStr = "0D0A0D0A000D0A515549540A2111000CC0A80001C0A8000230390050";
        ByteBuffer buf = ByteBuffer.wrap(this.hexStrToBytes(headerStr));
        this.engine.processHeaders(buf);
        Assertions.assertInstanceOf(ProxyProtocolV2Engine.class, (Object)this.engine.getActiveEngine());
        Assertions.assertTrue((boolean)this.engine.hasClientInformation());
        Assertions.assertTrue((boolean)this.engine.ready());
        Assertions.assertEquals((Object)InetAddress.getByName("192.168.0.1"), (Object)this.engine.clientAddress());
        Assertions.assertEquals((int)12345, (int)this.engine.clientPort());
    }

    @Test
    public void testActiveEngineNotSet() throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(new byte[0]);
        this.engine.processHeaders(buf);
        Assertions.assertNull((Object)this.engine.getActiveEngine());
    }

    @Test
    public void testOnlyConnectionModeServerSupported() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ProxyProtocolCombinedEngine(ConnectionMode.CLIENT, new LogContext()));
    }

    @Test
    public void testInvalidProxyProtocolHeaderWithoutFallback() {
        ByteBuffer buf = ByteBuffer.wrap("NOT A PROXY HEADER".getBytes(StandardCharsets.US_ASCII));
        Assertions.assertThrows(IOException.class, () -> this.engine.processHeaders(buf));
    }

    @Test
    public void testInvalidProxyProtocolHeaderWithFallback() throws IOException {
        this.engine.configure(Collections.singletonMap("confluent.proxy.protocol.fallback.enabled", true));
        ByteBuffer buf = ByteBuffer.wrap("NOT A PROXY HEADER".getBytes(StandardCharsets.US_ASCII));
        this.engine.processHeaders(buf);
        Assertions.assertNotNull((Object)this.engine.getActiveEngine());
        Assertions.assertTrue((boolean)this.engine.ready());
    }

    private byte[] hexStrToBytes(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); i += 2) {
            bytes[i / 2] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
        }
        return bytes;
    }
}

