/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.AbstractProxyProtocolEngineTest;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolCombinedEngine;
import org.apache.kafka.common.network.ProxyProtocolCommand;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocolV2Engine;
import org.apache.kafka.common.network.ProxyTlv;
import org.apache.kafka.common.network.ProxyTlvParser;
import org.apache.kafka.common.network.ProxyTlvType;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;

public class ProxyProtocolV2EngineTest
extends AbstractProxyProtocolEngineTest {
    protected String bytesToHexStr(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            String s = Integer.toHexString(b & 0xFF);
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    protected byte[] hexStrToBytes(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); i += 2) {
            bytes[i / 2] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
        }
        return bytes;
    }

    @Test
    public void testLkcId() throws IOException {
        ProxyProtocolEngine engine = this.newClientPPE("127.0.0.1", 8888, DEFAULT_COMMAND, "lkc-4proxy");
        this.assertValidEngineState(engine, true, false, engine.clientAddress(), engine.clientPort(), engine.command(), Collections.singletonList(engine.tlv(ProxyTlvType.LKC_ID)));
        String destinationAddress = engine.clientAddress() instanceof Inet4Address ? "127.0.0.1" : "2001:db8:85a3:8d3:1319:8a2e:370:7349";
        byte[] header = engine.emitHeaders(InetAddress.getByName(destinationAddress), 9092);
        ByteBuffer buf = ByteBuffer.wrap(header);
        engine = this.newServerPPE();
        this.assertValidEngineState(engine, false, false, null, -1, null);
        engine.processHeaders(buf);
        this.assertValidEngineState(engine, true, true, InetAddress.getByName("127.0.0.1"), 8888, DEFAULT_COMMAND, Collections.singletonList(DEFAULT_TLV));
    }

    @Test
    public void testCCloudTrafficType() throws IOException {
        ProxyProtocolEngine engine = this.newClientPPE("127.0.0.1", 8888, DEFAULT_COMMAND, "lkc-4proxy", DEFAULT_CCLOUD_TRAFFIC_TYPE);
        this.assertValidEngineState(engine, true, false, engine.clientAddress(), engine.clientPort(), engine.command(), Arrays.asList(engine.tlv(ProxyTlvType.LKC_ID), engine.tlv(ProxyTlvType.CCLOUD_TRAFFIC_TYPE)));
        String destinationAddress = engine.clientAddress() instanceof Inet4Address ? "127.0.0.1" : "2001:db8:85a3:8d3:1319:8a2e:370:7349";
        byte[] header = engine.emitHeaders(InetAddress.getByName(destinationAddress), 9092);
        ByteBuffer buf = ByteBuffer.wrap(header);
        engine = this.newServerPPE();
        this.assertValidEngineState(engine, false, false, null, -1, null);
        engine.processHeaders(buf);
        this.assertValidEngineState(engine, true, true, InetAddress.getByName("127.0.0.1"), 8888, DEFAULT_COMMAND, Arrays.asList(DEFAULT_TLV, DEFAULT_CCLOUD_TRAFFIC_TYPE_TLV));
        Assertions.assertEquals((Object)ProxyProtocol.V2, (Object)this.metadataRegistry.proxyProtocol());
    }

    @Test
    public void testCustomClientTlvs() throws Exception {
        ProxyProtocolEngine engine = this.newClientPPE();
        ProxyTlv tlv1 = ProxyTlv.create((ProxyTlvType)new ProxyTlvType(1), (byte[])new byte[]{1, 2, 3});
        ProxyTlv tlv2 = ProxyTlv.create((ProxyTlvType)new ProxyTlvType(2), (byte[])new byte[]{17, 34, 51});
        engine.configure(Map.of("confluent.proxy.protocol.client.mode", DEFAULT_COMMAND.toString(), "confluent.proxy.protocol.client.address", "127.0.0.1", "confluent.proxy.protocol.client.port", 8888, "confluent.ccloud.ppv2.tlvs", List.of(tlv1, tlv2)));
        byte[] header = engine.emitHeaders(InetAddress.getByName("127.0.0.1"), 9092);
        ByteBuffer buf = ByteBuffer.wrap(header);
        engine = this.newServerPPE();
        engine.processHeaders(buf);
        Assertions.assertEquals((Object)engine.tlv(tlv1.type()), (Object)tlv1);
        Assertions.assertEquals((Object)engine.tlv(tlv2.type()), (Object)tlv2);
    }

    private void testProxyTlvSubType(ProxyTlvType type, ProxyTlv expectedTlvValue) throws IOException {
        ProxyProtocolEngine engine = this.newClientPPE("127.0.0.1", 8888, DEFAULT_COMMAND, "lkc-4proxy", null, "test_ingress_gateway_id", "test_access_point_id", "test_availability_zone_id", "test_fqdn_template", "test_ingress_type", "test_private_endpoint_id", "test_gateway_zone1,test_gateway_zone2");
        this.assertValidEngineState(engine, true, false, engine.clientAddress(), engine.clientPort(), engine.command(), Arrays.asList(engine.tlv(ProxyTlvType.LKC_ID), engine.tlv(type)));
        String destinationAddress = engine.clientAddress() instanceof Inet4Address ? "127.0.0.1" : "2001:db8:85a3:8d3:1319:8a2e:370:7349";
        byte[] header = engine.emitHeaders(InetAddress.getByName(destinationAddress), 9092);
        ByteBuffer buf = ByteBuffer.wrap(header);
        engine = this.newServerPPE();
        this.assertValidEngineState(engine, false, false, null, -1, null);
        engine.processHeaders(buf);
        this.assertValidEngineState(engine, true, true, InetAddress.getByName("127.0.0.1"), 8888, DEFAULT_COMMAND, Arrays.asList(DEFAULT_TLV, expectedTlvValue));
        Assertions.assertEquals((Object)ProxyProtocol.V2, (Object)this.metadataRegistry.proxyProtocol());
    }

    @Test
    public void testIngressGatewayId() throws IOException {
        this.testProxyTlvSubType(ProxyTlvType.INGRESS_GATEWAY_ID, DEFAULT_INGRESS_GATEWAY_ID_TLV);
    }

    @Test
    public void testAccessPointType() throws IOException {
        this.testProxyTlvSubType(ProxyTlvType.ACCESS_POINT_ID, DEFAULT_ACCESS_POINT_ID_TLV);
    }

    @Test
    public void testAvailabilityZoneId() throws IOException {
        this.testProxyTlvSubType(ProxyTlvType.AVAILABILITY_ZONE_ID, DEFAULT_AVAILABILITY_ZONE_ID_TLV);
    }

    @Test
    public void testFqdnTemplate() throws IOException {
        this.testProxyTlvSubType(ProxyTlvType.FQDN_TEMPLATE, DEFAULT_FQDN_TEMPLATE_TLV);
    }

    @Test
    public void testIngressType() throws IOException {
        this.testProxyTlvSubType(ProxyTlvType.INGRESS_TYPE, DEFAULT_INGRESS_TYPE_TLV);
    }

    @Test
    public void testPrivateEndpointId() throws IOException {
        this.testProxyTlvSubType(ProxyTlvType.PRIVATE_ENDPOINT_ID, DEFAULT_PRIVATE_ENDPOINT_ID_TLV);
    }

    @Test
    public void testGatewayZones() throws IOException {
        this.testProxyTlvSubType(ProxyTlvType.GATEWAY_ZONES, DEFAULT_GATEWAY_ZONES_TLV);
    }

    @Test
    public void testGatewayZonesTlv_computedValue() {
        ProxyTlv gatewayZones = ProxyTlv.createForSubtypeWithCharSet((ProxyTlvType)ProxyTlvType.GATEWAY_ZONES, (String)"zone1,zone2", (Charset)StandardCharsets.US_ASCII);
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("zone1", "zone2")), (Object)gatewayZones.computedValue());
        gatewayZones = ProxyTlv.createForSubtypeWithCharSet((ProxyTlvType)ProxyTlvType.GATEWAY_ZONES, (String)" zone1   ,    zone2   ", (Charset)StandardCharsets.US_ASCII);
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("zone1", "zone2")), (Object)gatewayZones.computedValue());
    }

    @Test
    public void testProxyProtocolV2EngineBasic() throws IOException {
        ProxyProtocolEngine engine = this.newServerPPE();
        this.assertValidEngineState(engine, false, false, null, -1, null);
        ByteBuffer buf = this.putStream("0D0A0D0A000D0A515549540A2111000CD83AD0EE0000000022B822B80D0A03");
        engine.processHeaders(buf);
        byte[] sourceAddress = this.hexStrToBytes("D83AD0EE");
        InetAddress address = InetAddress.getByAddress(sourceAddress);
        this.assertValidEngineState(engine, true, true, address, 8888, ProxyProtocolCommand.PROXY);
        Assertions.assertEquals((int)3, (int)buf.remaining());
        Assertions.assertEquals((Object)ProxyProtocol.V2, (Object)this.metadataRegistry.proxyProtocol());
    }

    @Test
    public void testProxyProtocolV2EngineIpv6() throws IOException {
        ProxyProtocolEngine engine = this.newServerPPE();
        this.assertValidEngineState(engine, false, false, null, -1, null);
        ByteBuffer buf = this.putStream("0D0A0D0A000D0A515549540A2121002420010DB8AC10FE0100000000000000000000000000000000000000000000000022B822B80D0A");
        engine.processHeaders(buf);
        byte[] sourceAddress = this.hexStrToBytes("20010DB8AC10FE010000000000000000");
        InetAddress address = InetAddress.getByAddress(sourceAddress);
        this.assertValidEngineState(engine, true, true, address, 8888, ProxyProtocolCommand.PROXY);
        Assertions.assertEquals((int)2, (int)buf.remaining());
        Assertions.assertEquals((Object)ProxyProtocol.V2, (Object)this.metadataRegistry.proxyProtocol());
    }

    @Test
    public void testProxyProtocolV2EngineWithMultipleSegments() throws IOException {
        ProxyProtocolEngine engine = this.newServerPPE();
        ByteBuffer buf = ByteBuffer.allocate(31);
        this.putStreamAndFlip(buf, "0D0A0D0A000D");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertFalse((boolean)engine.ready());
        this.putStreamAndFlip(buf, "0A515549540A21");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertFalse((boolean)engine.ready());
        this.putStreamAndFlip(buf, "11000CD83AD0EE0000000022B822B80D0A03");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertTrue((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        byte[] sourceAddress = this.hexStrToBytes("D83AD0EE");
        InetAddress address = InetAddress.getByAddress(sourceAddress);
        Assertions.assertEquals((Object)address, (Object)engine.clientAddress());
        Assertions.assertEquals((int)8888, (int)engine.clientPort());
        Assertions.assertEquals((Object)ProxyProtocol.V2, (Object)this.metadataRegistry.proxyProtocol());
    }

    @Test
    public void testNonProxyHeaderFallbackEnabled() throws IOException {
        ProxyProtocolEngine engine = this.newServerPPE();
        engine.configure(Collections.singletonMap("confluent.proxy.protocol.fallback.enabled", true));
        ByteBuffer buf = this.putStream("AD0EE0000000022B822B0A0D");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        buf.flip();
        Assertions.assertEquals((int)12, (int)buf.remaining());
        Assertions.assertEquals((Object)ProxyProtocol.NONE, (Object)this.metadataRegistry.proxyProtocol());
    }

    @Test
    public void testProxyProtocolV2LocalConnection() throws IOException {
        ProxyProtocolEngine engine = this.newServerPPE();
        this.assertValidEngineState(engine, false, false, null, -1, null);
        String payload = "CD83AD0EE0000000022B822B";
        ByteBuffer buf = this.putStream("0D0A0D0A000D0A515549540A20000000" + payload);
        engine.processHeaders(buf);
        this.assertValidEngineState(engine, false, true, null, -1, ProxyProtocolCommand.LOCAL);
        Assertions.assertEquals((int)this.hexStrToBytes(payload).length, (int)buf.remaining());
        Assertions.assertEquals((Object)ProxyProtocol.V2, (Object)this.metadataRegistry.proxyProtocol());
    }

    @Test
    public void testMalformedLkcIdForClient() {
        String invalidLkcId = "this-is-not-a-valid-lkc-id";
        Assertions.assertThrows(ConfigException.class, () -> this.newClientPPE("216.58.208.238", 8888, DEFAULT_COMMAND, invalidLkcId));
    }

    @Test
    public void testLkcIdForClientIsOptional() {
        Assertions.assertNotNull((Object)this.newClientPPE("216.58.208.238", 8888, DEFAULT_COMMAND, "lkc-4proxy").tlv(ProxyTlvType.LKC_ID));
        Assertions.assertNull((Object)this.newClientPPE("216.58.208.238", 8888, DEFAULT_COMMAND, null).tlv(ProxyTlvType.LKC_ID));
    }

    @Test
    public void testAddressAndPortOptionalInLocalMode() {
        Assertions.assertNotNull((Object)this.newClientPPE(null, null, ProxyProtocolCommand.LOCAL, "lkc-4proxy"));
        Assertions.assertThrows(ConfigException.class, () -> this.newClientPPE(null, null, ProxyProtocolCommand.PROXY, "lkc-4proxy"));
    }

    @Test
    public void testMalformedLkcIdForServer() throws IOException {
        String invalidLkcId = "this-is-not-a-valid-lkc-id";
        ProxyTlv tlv = ProxyTlv.createForSubtype((ProxyTlvType)ProxyTlvType.LKC_ID, (String)invalidLkcId);
        String tlvHexString = this.bytesToHexStr(ProxyProtocolV2Engine.tlvBytes((ProxyTlv)tlv));
        String addressLengthHexString = "00" + Integer.toHexString(12 + tlvHexString.length() / 2);
        ProxyProtocolEngine engine = this.newServerPPE();
        ByteBuffer buf = this.putStream("0D0A0D0A000D0A515549540A2111" + addressLengthHexString + "D83AD0EE7f00000122B82384" + tlvHexString);
        engine.processHeaders(buf);
        Assertions.assertEquals((Object)ProxyProtocol.V2, (Object)this.metadataRegistry.proxyProtocol());
    }

    @Test
    public void testMultipleTlvs() throws IOException {
        String hostName = "636C75737465722E636F6E666C75656E742E696F";
        ProxyTlvType authorityTlvType = new ProxyTlvType.Builder(2).build();
        ProxyTlv authorityTlv = new ProxyTlv(authorityTlvType, this.hexStrToBytes(hostName));
        ArrayList<ProxyTlv> tlvs = new ArrayList<ProxyTlv>();
        tlvs.add(DEFAULT_TLV);
        tlvs.add(DEFAULT_CCLOUD_TRAFFIC_TYPE_TLV);
        tlvs.add(authorityTlv);
        String tlvHexString = this.bytesToHexStr(ProxyProtocolV2Engine.tlvBytes(tlvs));
        String addressLengthHexString = "00" + Integer.toHexString(12 + tlvHexString.length() / 2);
        ProxyProtocolEngine engine = this.newServerPPE();
        ByteBuffer buf = ByteBuffer.wrap(this.generateHeader("0D0A0D0A000D0A515549540A2111" + addressLengthHexString + "D83AD0EE7f00000122B82384" + tlvHexString));
        this.assertValidEngineState(engine, false, false, null, -1, null);
        engine.processHeaders(buf);
        this.assertValidEngineState(engine, true, true, InetAddress.getByName("216.58.208.238"), 8888, DEFAULT_COMMAND, Arrays.asList(DEFAULT_TLV, DEFAULT_CCLOUD_TRAFFIC_TYPE_TLV));
        ProxyTlv actualTlv = engine.tlv(authorityTlvType);
        Assertions.assertNotNull((Object)actualTlv);
        Assertions.assertEquals((Object)authorityTlv, (Object)actualTlv);
        String actualSniValue = new String(actualTlv.rawValue(), StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"cluster.confluent.io", (Object)actualSniValue);
        Assertions.assertEquals((Object)ProxyProtocol.V2, (Object)this.metadataRegistry.proxyProtocol());
    }

    @Test
    public void testCustomParser() throws IOException {
        String hostName = "636C75737465722E636F6E666C75656E742E696F";
        ProxyTlvType authorityTlvType = new ProxyTlvType.Builder(2).build();
        ProxyTlv authorityTlv = new ProxyTlv(authorityTlvType, this.hexStrToBytes(hostName));
        ArrayList<ProxyTlv> tlvs = new ArrayList<ProxyTlv>();
        tlvs.add(DEFAULT_TLV);
        tlvs.add(DEFAULT_CCLOUD_TRAFFIC_TYPE_TLV);
        tlvs.add(authorityTlv);
        String tlvHexString = this.bytesToHexStr(ProxyProtocolV2Engine.tlvBytes(tlvs));
        String addressLengthHexString = "00" + Integer.toHexString(12 + tlvHexString.length() / 2);
        ProxyProtocolEngine engine = this.newServerPPE(Map.of("confluent.proxy.protocol.parser", TestCustomParser.class));
        ByteBuffer buf = ByteBuffer.wrap(this.generateHeader("0D0A0D0A000D0A515549540A2111" + addressLengthHexString + "D83AD0EE7f00000122B82384" + tlvHexString));
        this.assertValidEngineState(engine, false, false, null, -1, null);
        engine.processHeaders(buf);
        ProxyTlv actualTlv = engine.tlv(authorityTlvType);
        Assertions.assertNotNull((Object)actualTlv);
        Assertions.assertEquals((int)(authorityTlv.value.length + 1), (int)actualTlv.value.length);
        Assertions.assertArrayEquals((byte[])authorityTlv.value, (byte[])Arrays.copyOf(actualTlv.value, authorityTlv.value.length));
    }

    @Test
    public void testUnknownConfluentTypeTlv() throws IOException {
        ProxyProtocolV2Engine v2Engine;
        String value = "74657374";
        int unknownSubtypeValue = 255;
        ProxyTlvType unknownTlvType = new ProxyTlvType(239, Optional.of(unknownSubtypeValue), Optional.empty(), Optional.empty());
        byte[] hexStringValueBytes = this.hexStrToBytes(Integer.toHexString(unknownSubtypeValue) + value);
        ProxyTlv unknownTlv = new ProxyTlv(unknownTlvType, hexStringValueBytes);
        String tlvHexString = this.bytesToHexStr(ProxyProtocolV2Engine.tlvBytes(Collections.singletonList(unknownTlv)));
        String addressLengthHexString = "00" + Integer.toHexString(12 + tlvHexString.length() / 2);
        ProxyProtocolEngine engine = this.newServerPPE();
        ByteBuffer buf = ByteBuffer.wrap(this.generateHeader("0D0A0D0A000D0A515549540A2111" + addressLengthHexString + "D83AD0EE7f00000122B82384" + tlvHexString));
        this.assertValidEngineState(engine, false, false, null, -1, null);
        engine.processHeaders(buf);
        this.assertValidEngineState(engine, true, true, InetAddress.getByName("216.58.208.238"), 8888, DEFAULT_COMMAND, Collections.emptyList());
        if (engine instanceof ProxyProtocolV2Engine) {
            v2Engine = (ProxyProtocolV2Engine)engine;
        } else if (engine instanceof ProxyProtocolCombinedEngine) {
            v2Engine = (ProxyProtocolV2Engine)((ProxyProtocolCombinedEngine)engine).getActiveEngine();
        } else {
            throw new IllegalStateException("Unexpected engine type: " + engine.getClass().getName());
        }
        Map tlvs = v2Engine.getTlvs();
        Assertions.assertEquals((int)1, (int)tlvs.size());
        Map.Entry actualEntry = tlvs.entrySet().iterator().next();
        ProxyTlvType actualTlvType = (ProxyTlvType)actualEntry.getKey();
        Assertions.assertEquals((Object)unknownTlvType, (Object)actualTlvType);
        ProxyTlv actualTlv = (ProxyTlv)actualEntry.getValue();
        Assertions.assertEquals((Object)unknownTlv, (Object)actualTlv);
        Assertions.assertEquals((Object)ProxyProtocol.V2, (Object)this.metadataRegistry.proxyProtocol());
    }

    @Override
    protected ProxyProtocolEngine newServerPPE() {
        return this.newServerPPE(Map.of());
    }

    protected ProxyProtocolEngine newServerPPE(Map<String, Object> configs) {
        ProxyProtocolV2Engine engine = new ProxyProtocolV2Engine(ConnectionMode.SERVER, new LogContext(), this.metadataRegistry);
        engine.configure(configs);
        return engine;
    }

    @Override
    protected ProxyProtocolEngine newClientPPE() {
        return new ProxyProtocolV2Engine(ConnectionMode.CLIENT, new LogContext());
    }

    @Override
    protected byte[] generateHeader(String header) {
        return this.hexStrToBytes(header);
    }

    @Override
    protected List<String> getInvalidProxyHeaders() {
        return Arrays.asList("0D0A0D0A000D0A515549540A2112000CD83AD0EE0000000022B822B8", "0D0A0D0A000D0A515549540A2122002420010DB8AC10FE0100000000000000000000000000000000000000000000000022B822B80D0A", "0D0D0D0A000D0A515549540A2111000CD83AD0EE0000000022B822B80D0A03", "0D0A0D0A000D0A515549540A1111000CD83AD0EE0000000022B822B80D0A03", "0D0A0D0A000D0A515549540A2211000CD83AD0EE0000000022B822B80D0A03");
    }

    public static class TestCustomParser
    implements ProxyTlvParser {
        public Optional<ProxyTlv> parse(Logger log, int tlvType, byte[] bytes) {
            byte[] valueBytes = Arrays.copyOf(bytes, bytes.length + 1);
            valueBytes[valueBytes.length - 1] = 2;
            return Optional.of(new ProxyTlv(new ProxyTlvType(tlvType), valueBytes));
        }

        public void configure(Map<String, ?> configs) {
        }
    }
}

