/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.internal.EmptyArrays;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.kafka.common.network.netty.K2PStreamMetadata;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.test.TestSslUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestUtils {
    public static final int ONE_MB = 0x100000;

    private TestUtils() {
    }

    private static KeyStore createKeyStore(KeyPair keyPair, String commonName, String org, boolean utf8, String ... dnsNames) throws Exception {
        X509Certificate cert = new TestSslUtils.CertificateBuilder().sanDnsNames(dnsNames).generate(commonName, org, utf8, keyPair);
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(null, null);
        ks.setKeyEntry("kafka", keyPair.getPrivate(), null, new X509Certificate[]{cert});
        return ks;
    }

    public static SslContext buildServerSslContext() throws Exception {
        KeyPair keyPair = TestSslUtils.generateKeyPair("RSA");
        KeyStore ks = TestUtils.createKeyStore(keyPair, "*.example.com", "Kafka", true, "localhost", "*.example.com");
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(ks, EmptyArrays.EMPTY_CHARS);
        return SslContextBuilder.forServer((KeyManagerFactory)factory).build();
    }

    public static SslContext trustAllCertsSSlContext() {
        return TestUtils.trustAllCertsSSlContext(false, null);
    }

    public static SslContext trustAllCertsSSlContext(List<String> protocols) {
        return TestUtils.trustAllCertsSSlContext(false, protocols);
    }

    public static SslContext trustAllCertsSSlContext(boolean addApn) {
        return TestUtils.trustAllCertsSSlContext(addApn, null, null);
    }

    public static SslContext trustAllCertsSSlContext(boolean addApn, List<String> protocols) {
        return TestUtils.trustAllCertsSSlContext(addApn, null, protocols);
    }

    public static SslContext trustAllCertsSSlContext(boolean addApn, List<String> ciphers, List<String> protocols) {
        ApplicationProtocolConfig apn = TestUtils.getApplicationProtocolConfig(addApn);
        try {
            return SslContextBuilder.forClient().trustManager((TrustManager)new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }).ciphers(ciphers).applicationProtocolConfig(apn).protocols(protocols).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    private static ApplicationProtocolConfig getApplicationProtocolConfig(boolean addApn) {
        ApplicationProtocolConfig apn = ApplicationProtocolConfig.DISABLED;
        if (addApn) {
            apn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"});
        }
        return apn;
    }

    public static List<ChannelHandler> handlers(Channel channel) {
        return channel.pipeline().toMap().values().stream().collect(Collectors.toUnmodifiableList());
    }

    public static Http2Headers streamCreationHeaders() {
        DefaultKafkaPrincipalBuilder defaultSerializer = new DefaultKafkaPrincipalBuilder(null, null);
        MultiTenantPrincipal multiTenantPrincipal = new MultiTenantPrincipal("user", "saslAuthenticationId", new TenantMetadata("tenantName", "clusterId"));
        K2PStreamMetadata metadata = new K2PStreamMetadata(Optional.of(defaultSerializer), (KafkaPrincipal)multiTenantPrincipal, true, "tenant-id", "127.0.0.1", Integer.valueOf(8080), "client-name", "1.0", "client-id");
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        metadata.serialize((Http2Headers)headers);
        return headers;
    }

    public static Channel mockConnectionChannel() {
        Channel parent = (Channel)Mockito.mock(Channel.class);
        ChannelPipeline pipeline = (ChannelPipeline)Mockito.mock(ChannelPipeline.class);
        Mockito.when((Object)parent.pipeline()).thenReturn((Object)pipeline);
        Http2FrameCodec frameCodec = (Http2FrameCodec)Mockito.mock(Http2FrameCodec.class);
        Mockito.when((Object)((Http2FrameCodec)pipeline.get(Http2FrameCodec.class))).thenReturn((Object)frameCodec);
        Http2Connection connection = (Http2Connection)Mockito.mock(Http2Connection.class);
        Mockito.when((Object)connection.stream(ArgumentMatchers.anyInt())).thenReturn((Object)((Http2Stream)Mockito.mock(Http2Stream.class)));
        Mockito.when((Object)frameCodec.connection()).thenReturn((Object)connection);
        return parent;
    }
}

