/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrame;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.apache.kafka.common.network.netty.AbstractStreamHandler;
import org.apache.kafka.common.network.netty.NettyHttp2ConnectionInitializer;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyRawBytesConnectionInitializer;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.TestUtils;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class UpdateStreamHandlerTest {
    @Test
    public void testUpdateStreamHandlerNettyRawBytes() {
        ChannelGroup trackedChannels = (ChannelGroup)Mockito.mock(ChannelGroup.class);
        AtomicReference nettyStreamRef = new AtomicReference();
        TestApplicationStreamHandler originalApplicationStreamHandler = new TestApplicationStreamHandler("original-handler");
        LogContext logContext = new LogContext("handler-test");
        BiFunction<NettyStream, Http2Headers, NettyStream.StreamHandler> handlerCreator = (stream, headers) -> {
            nettyStreamRef.set(stream);
            return originalApplicationStreamHandler;
        };
        Channel mockChannel = (Channel)Mockito.mock(Channel.class);
        ChannelPipeline mockPipeline = (ChannelPipeline)Mockito.mock(ChannelPipeline.class);
        EventLoop mockEventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        Mockito.when((Object)mockChannel.pipeline()).thenReturn((Object)mockPipeline);
        Mockito.when((Object)mockChannel.config()).thenReturn((Object)((ChannelConfig)Mockito.mock(ChannelConfig.class)));
        Mockito.when((Object)trackedChannels.add((Object)((Channel)ArgumentMatchers.any()))).thenReturn((Object)true);
        Mockito.when((Object)mockChannel.eventLoop()).thenReturn((Object)mockEventLoop);
        Mockito.when((Object)mockEventLoop.inEventLoop()).thenReturn((Object)true);
        AtomicReference pipelineHandlerRef = new AtomicReference();
        ((ChannelPipeline)Mockito.doAnswer(invocation -> {
            pipelineHandlerRef.set((AbstractStreamHandler)invocation.getArgument(0));
            return null;
        }).when((Object)mockPipeline)).addLast((ChannelHandler[])ArgumentMatchers.any());
        NettyRawBytesConnectionInitializer initializer = new NettyRawBytesConnectionInitializer(trackedChannels, null, handlerCreator, logContext, false, true);
        initializer.initChannel(mockChannel);
        Assertions.assertEquals((Object)originalApplicationStreamHandler, (Object)((AbstractStreamHandler)pipelineHandlerRef.get()).streamHandler());
        Assertions.assertEquals((Object)"original-handler", (Object)((TestApplicationStreamHandler)((AbstractStreamHandler)pipelineHandlerRef.get()).streamHandler()).getHandlerName());
        TestApplicationStreamHandler updatedHandler = new TestApplicationStreamHandler("updated-handler");
        ((NettyStream)nettyStreamRef.get()).setStreamHandler((NettyStream.StreamHandler)updatedHandler);
        Assertions.assertEquals((Object)updatedHandler, (Object)((AbstractStreamHandler)pipelineHandlerRef.get()).streamHandler());
        Assertions.assertEquals((Object)"updated-handler", (Object)((TestApplicationStreamHandler)((AbstractStreamHandler)pipelineHandlerRef.get()).streamHandler()).getHandlerName());
    }

    @Test
    public void testUpdateStreamHandlerNettyHttp2Stream() {
        ChannelGroup trackedChannels = (ChannelGroup)Mockito.mock(ChannelGroup.class);
        AtomicReference nettyStreamRef = new AtomicReference();
        TestApplicationStreamHandler originalApplicationStreamHandler = new TestApplicationStreamHandler("original-handler");
        LogContext logContext = new LogContext("handler-test");
        BiFunction<NettyStream, Http2Headers, NettyStream.StreamHandler> handlerCreator = (stream, headers) -> {
            nettyStreamRef.set(stream);
            return originalApplicationStreamHandler;
        };
        Http2StreamChannel mockChannel = (Http2StreamChannel)Mockito.mock(Http2StreamChannel.class);
        Channel parentChannel = TestUtils.mockConnectionChannel();
        Mockito.when((Object)mockChannel.parent()).thenReturn((Object)parentChannel);
        Http2FrameStream stream2 = (Http2FrameStream)Mockito.mock(Http2FrameStream.class);
        Mockito.when((Object)mockChannel.stream()).thenReturn((Object)stream2);
        Mockito.when((Object)stream2.id()).thenReturn((Object)1);
        ChannelConfig config = (ChannelConfig)Mockito.mock(ChannelConfig.class);
        Mockito.when((Object)mockChannel.config()).thenReturn((Object)config);
        Mockito.when((Object)config.setOption((ChannelOption)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)true);
        ChannelPipeline mockPipeline = (ChannelPipeline)Mockito.mock(ChannelPipeline.class);
        EventLoop mockEventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        Mockito.when((Object)mockChannel.pipeline()).thenReturn((Object)mockPipeline);
        Mockito.when((Object)trackedChannels.add((Object)((Channel)ArgumentMatchers.any()))).thenReturn((Object)true);
        ChannelHandlerContext mockContext = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Http2HeadersFrame mockHeadersFrame = (Http2HeadersFrame)Mockito.mock(Http2HeadersFrame.class);
        Mockito.when((Object)mockHeadersFrame.headers()).thenReturn((Object)new DefaultHttp2Headers());
        Mockito.when((Object)mockChannel.eventLoop()).thenReturn((Object)mockEventLoop);
        Mockito.when((Object)mockEventLoop.inEventLoop()).thenReturn((Object)true);
        AtomicReference pipelineHandlerRef = new AtomicReference();
        ((ChannelPipeline)Mockito.doAnswer(invocation -> {
            pipelineHandlerRef.set((NettyHttp2Stream.NettyHttp2StreamHandler)invocation.getArgument(0));
            ((NettyHttp2Stream.NettyHttp2StreamHandler)pipelineHandlerRef.get()).channelRead0(mockContext, (Http2StreamFrame)mockHeadersFrame);
            return null;
        }).when((Object)mockPipeline)).addLast((ChannelHandler[])ArgumentMatchers.any());
        NettyHttp2ConnectionInitializer.NettyHttp2StreamInitializer initializer = new NettyHttp2ConnectionInitializer.NettyHttp2StreamInitializer(handlerCreator, trackedChannels, logContext, true);
        initializer.initChannel(mockChannel);
        Assertions.assertEquals((Object)originalApplicationStreamHandler, (Object)((NettyHttp2Stream.NettyHttp2StreamHandler)pipelineHandlerRef.get()).streamHandler());
        Assertions.assertEquals((Object)"original-handler", (Object)((TestApplicationStreamHandler)((NettyHttp2Stream.NettyHttp2StreamHandler)pipelineHandlerRef.get()).streamHandler()).getHandlerName());
        TestApplicationStreamHandler updatedHandler = new TestApplicationStreamHandler("updated-handler");
        ((NettyStream)nettyStreamRef.get()).setStreamHandler((NettyStream.StreamHandler)updatedHandler);
        Assertions.assertEquals((Object)updatedHandler, (Object)((NettyHttp2Stream.NettyHttp2StreamHandler)pipelineHandlerRef.get()).streamHandler());
        Assertions.assertEquals((Object)"updated-handler", (Object)((TestApplicationStreamHandler)((NettyHttp2Stream.NettyHttp2StreamHandler)pipelineHandlerRef.get()).streamHandler()).getHandlerName());
    }

    @Test
    public void testInitializenHttp2StreamWhenHandlerAlreadySetDoesntUpdate() throws Exception {
        TestApplicationStreamHandler alreadySetStreamHandler = new TestApplicationStreamHandler("already-set-handler");
        Http2StreamChannel mockChannel = (Http2StreamChannel)Mockito.mock(Http2StreamChannel.class);
        Channel parentChannel = TestUtils.mockConnectionChannel();
        Mockito.when((Object)mockChannel.parent()).thenReturn((Object)parentChannel);
        Http2FrameStream mockStream = (Http2FrameStream)Mockito.mock(Http2FrameStream.class);
        Mockito.when((Object)mockChannel.stream()).thenReturn((Object)mockStream);
        Mockito.when((Object)mockStream.id()).thenReturn((Object)1);
        ChannelConfig config = (ChannelConfig)Mockito.mock(ChannelConfig.class);
        Mockito.when((Object)mockChannel.config()).thenReturn((Object)config);
        Mockito.when((Object)config.setOption((ChannelOption)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)true);
        EventLoop mockEventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        Mockito.when((Object)mockChannel.eventLoop()).thenReturn((Object)mockEventLoop);
        Mockito.when((Object)mockEventLoop.inEventLoop()).thenReturn((Object)true);
        ChannelHandlerContext mockContext = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Http2HeadersFrame mockHeadersFrame = (Http2HeadersFrame)Mockito.mock(Http2HeadersFrame.class);
        Mockito.when((Object)mockHeadersFrame.headers()).thenReturn((Object)new DefaultHttp2Headers());
        LogContext logContext = new LogContext("handler-test");
        NettyHttp2Stream http2Stream = new NettyHttp2Stream(mockChannel, logContext);
        BiFunction<NettyStream, Http2Headers, NettyStream.StreamHandler> handlerCreator = (stream, headers) -> {
            stream.setStreamHandler((NettyStream.StreamHandler)alreadySetStreamHandler);
            return new TestApplicationStreamHandler("should-not-be-used");
        };
        NettyHttp2Stream.NettyHttp2StreamHandler testHandler = new NettyHttp2Stream.NettyHttp2StreamHandler((NettyStream)http2Stream, handlerCreator, null, new LogContext("test-log"));
        http2Stream.setAbstractStreamHandler((AbstractStreamHandler)testHandler);
        testHandler.channelRead0(mockContext, (Http2StreamFrame)mockHeadersFrame);
        Assertions.assertEquals((Object)alreadySetStreamHandler.getHandlerName(), (Object)((TestApplicationStreamHandler)testHandler.streamHandler()).getHandlerName());
    }

    private static class TestApplicationStreamHandler
    implements NettyStream.StreamHandler {
        private final String handlerName;

        public TestApplicationStreamHandler(String handlerName) {
            this.handlerName = handlerName;
        }

        public String getHandlerName() {
            return this.handlerName;
        }

        public void handleData(ByteBuf data) {
        }

        public void handleReadyForSend() {
        }

        public void handleException(Throwable t) {
        }

        public void handleClose() {
        }
    }
}

