/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class FetchRequestTest {
    private static Stream<Arguments> fetchVersions() {
        return ApiKeys.FETCH.allVersions().stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"fetchVersions"})
    public void testToReplaceWithDifferentVersions(short version) {
        boolean fetchRequestUsesTopicIds = version >= 13;
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, 0, "topic");
        Map<TopicPartition, FetchRequest.PartitionData> partitionData = Collections.singletonMap(tp.topicPartition(), new FetchRequest.PartitionData(topicId, 0L, 0L, 0, Optional.empty(), Optional.empty(), Optional.empty()));
        List<TopicIdPartition> toReplace = Collections.singletonList(tp);
        FetchRequest fetchRequest = FetchRequest.Builder.forReplica((short)version, (int)0, (long)1L, (int)1, (int)1, partitionData).removed(Collections.emptyList()).replaced(toReplace).metadata(FetchMetadata.newIncremental((int)123)).build(version);
        Assertions.assertEquals((Object)fetchRequestUsesTopicIds, (Object)(!fetchRequest.data().forgottenTopicsData().isEmpty() ? 1 : 0));
        fetchRequest.data().forgottenTopicsData().forEach(forgottenTopic -> {
            Assertions.assertEquals((Object)tp.topic(), (Object)forgottenTopic.topic());
            Assertions.assertEquals((Object)topicId, (Object)forgottenTopic.topicId());
        });
        Assertions.assertEquals((int)1, (int)fetchRequest.data().topics().size());
        fetchRequest.data().topics().forEach(topic -> {
            Assertions.assertEquals((Object)tp.topic(), (Object)topic.topic());
            Assertions.assertEquals((Object)topicId, (Object)topic.topicId());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"fetchVersions"})
    public void testFetchData(short version) {
        TopicPartition topicPartition0 = new TopicPartition("topic", 0);
        TopicPartition topicPartition1 = new TopicPartition("unknownIdTopic", 0);
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        Map<Uuid, String> topicNames = Collections.singletonMap(topicId0, topicPartition0.topic());
        LinkedList<TopicIdPartition> topicIdPartitions = new LinkedList<TopicIdPartition>();
        topicIdPartitions.add(new TopicIdPartition(topicId0, topicPartition0));
        topicIdPartitions.add(new TopicIdPartition(topicId1, topicPartition1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionData.put(topicPartition0, new FetchRequest.PartitionData(topicId0, 0L, 0L, 0, Optional.empty(), Optional.empty(), Optional.empty()));
        partitionData.put(topicPartition1, new FetchRequest.PartitionData(topicId1, 0L, 0L, 0, Optional.empty(), Optional.empty(), Optional.empty()));
        boolean fetchRequestUsesTopicIds = version >= 13;
        FetchRequest fetchRequest = FetchRequest.parse((Readable)FetchRequest.Builder.forReplica((short)version, (int)0, (long)1L, (int)1, (int)1, partitionData).removed(Collections.emptyList()).replaced(Collections.emptyList()).metadata(FetchMetadata.newIncremental((int)123)).build(version).serialize(), (short)version, (MessageContext)MessageContext.IDENTITY);
        if (version >= 15) {
            Assertions.assertEquals((long)1L, (long)fetchRequest.data().replicaState().replicaEpoch());
        }
        LinkedList expectedData = new LinkedList();
        topicIdPartitions.forEach(tidp -> {
            String expectedName = fetchRequestUsesTopicIds ? "" : tidp.topic();
            Uuid expectedTopicId = fetchRequestUsesTopicIds ? tidp.topicId() : Uuid.ZERO_UUID;
            expectedData.add(new TopicIdPartition(expectedTopicId, tidp.partition(), expectedName));
        });
        LinkedList convertedFetchData = new LinkedList();
        fetchRequest.data().topics().forEach(topic -> topic.partitions().forEach(partition -> convertedFetchData.add(new TopicIdPartition(topic.topicId(), partition.partition(), topic.topic()))));
        Assertions.assertEquals(expectedData, convertedFetchData);
        LinkedHashMap expectedFetchData = new LinkedHashMap();
        expectedData.forEach(tidp -> {
            String expectedName = fetchRequestUsesTopicIds ? (String)topicNames.get(tidp.topicId()) : tidp.topic();
            TopicIdPartition tpKey = new TopicIdPartition(tidp.topicId(), new TopicPartition(expectedName, tidp.partition()));
            int logStartOffset = version > 4 ? 0 : -1;
            expectedFetchData.put(tpKey, new FetchRequest.PartitionData(tidp.topicId(), 0L, (long)logStartOffset, 0, Optional.empty(), Optional.empty(), Optional.empty()));
        });
        Assertions.assertEquals(expectedFetchData, (Object)fetchRequest.fetchData(topicNames));
    }

    @ParameterizedTest
    @MethodSource(value={"fetchVersions"})
    public void testForgottenTopics(short version) {
        if (version >= 7) {
            TopicPartition topicPartition0 = new TopicPartition("topic", 0);
            TopicPartition topicPartition1 = new TopicPartition("unknownIdTopic", 0);
            Uuid topicId0 = Uuid.randomUuid();
            Uuid topicId1 = Uuid.randomUuid();
            Map<Uuid, String> topicNames = Collections.singletonMap(topicId0, topicPartition0.topic());
            LinkedList<TopicIdPartition> toForgetTopics = new LinkedList<TopicIdPartition>();
            toForgetTopics.add(new TopicIdPartition(topicId0, topicPartition0));
            toForgetTopics.add(new TopicIdPartition(topicId1, topicPartition1));
            boolean fetchRequestUsesTopicIds = version >= 13;
            FetchRequest fetchRequest = FetchRequest.parse((Readable)FetchRequest.Builder.forReplica((short)version, (int)0, (long)1L, (int)1, (int)1, Collections.emptyMap()).removed(toForgetTopics).replaced(Collections.emptyList()).metadata(FetchMetadata.newIncremental((int)123)).build(version).serialize(), (short)version, (MessageContext)MessageContext.IDENTITY);
            LinkedList expectedForgottenTopicData = new LinkedList();
            toForgetTopics.forEach(tidp -> {
                String expectedName = fetchRequestUsesTopicIds ? "" : tidp.topic();
                Uuid expectedTopicId = fetchRequestUsesTopicIds ? tidp.topicId() : Uuid.ZERO_UUID;
                expectedForgottenTopicData.add(new TopicIdPartition(expectedTopicId, tidp.partition(), expectedName));
            });
            LinkedList convertedForgottenTopicData = new LinkedList();
            fetchRequest.data().forgottenTopicsData().forEach(forgottenTopic -> forgottenTopic.partitions().forEach(partition -> convertedForgottenTopicData.add(new TopicIdPartition(forgottenTopic.topicId(), partition.intValue(), forgottenTopic.topic()))));
            Assertions.assertEquals(expectedForgottenTopicData, convertedForgottenTopicData);
            ArrayList forgottenTopics = new ArrayList();
            fetchRequest.data().forgottenTopicsData().forEach(forgottenTopic -> {
                String name = fetchRequest.version() < 13 ? forgottenTopic.topic() : (String)topicNames.get(forgottenTopic.topicId());
                forgottenTopic.partitions().forEach(partitionId -> forgottenTopics.add(new TopicIdPartition(forgottenTopic.topicId(), new TopicPartition(name, partitionId.intValue()))));
            });
            Assertions.assertEquals((int)expectedForgottenTopicData.size(), (int)forgottenTopics.size());
            LinkedList expectedForgottenTopics = new LinkedList();
            expectedForgottenTopicData.forEach(tidp -> {
                String expectedName = fetchRequestUsesTopicIds ? (String)topicNames.get(tidp.topicId()) : tidp.topic();
                expectedForgottenTopics.add(new TopicIdPartition(tidp.topicId(), new TopicPartition(expectedName, tidp.partition())));
            });
            Assertions.assertEquals(expectedForgottenTopics, forgottenTopics);
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.FETCH)
    public void testFetchRequestSimpleBuilderReplicaStateDowngrade(short version) {
        FetchRequestData fetchRequestData = new FetchRequestData();
        fetchRequestData.setReplicaState(new FetchRequestData.ReplicaState().setReplicaId(1));
        FetchRequest.SimpleBuilder builder = new FetchRequest.SimpleBuilder(fetchRequestData);
        fetchRequestData = builder.build(version).data();
        Assertions.assertEquals((int)1, (int)FetchRequest.replicaId((FetchRequestData)fetchRequestData));
        if (version < 15) {
            Assertions.assertEquals((int)1, (int)fetchRequestData.replicaId());
            Assertions.assertEquals((int)-1, (int)fetchRequestData.replicaState().replicaId());
        } else {
            Assertions.assertEquals((int)-1, (int)fetchRequestData.replicaId());
            Assertions.assertEquals((int)1, (int)fetchRequestData.replicaState().replicaId());
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.FETCH)
    public void testFetchRequestSimpleBuilderReplicaIdNotSupported(short version) {
        FetchRequestData fetchRequestData = new FetchRequestData().setReplicaId(1);
        FetchRequest.SimpleBuilder builder = new FetchRequest.SimpleBuilder(fetchRequestData);
        Assertions.assertThrows(IllegalStateException.class, () -> builder.build(version));
    }

    @Test
    public void testPartitionDataEquals() {
        Assertions.assertEquals((Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 300L, 0L, 300, Optional.of(0L), Optional.of(300), Optional.empty()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 300L, 0L, 300, Optional.of(0L), Optional.of(300), Optional.empty()));
        Assertions.assertNotEquals((Object)new FetchRequest.PartitionData(Uuid.randomUuid(), 300L, 0L, 300, Optional.of(0L), Optional.of(300), Optional.empty()), (Object)new FetchRequest.PartitionData(Uuid.randomUuid(), 300L, 0L, 300, Optional.of(0L), Optional.of(300), Optional.empty()));
    }

    @ParameterizedTest
    @MethodSource(value={"fetchVersions"})
    public void testFetchRequestNoCacheData(short version) {
        Uuid topicId = Uuid.randomUuid();
        int partition = 0;
        TopicIdPartition tp = new TopicIdPartition(topicId, partition, "topic");
        FetchRequest fetchRequest = this.createFetchRequestByVersion(version, topicId, tp);
        Map<Uuid, String> topicNames = Collections.singletonMap(topicId, tp.topic());
        List requestsWithTopicsName = fetchRequest.forgottenTopics(topicNames);
        Assertions.assertEquals((int)topicNames.size(), (int)requestsWithTopicsName.size());
        requestsWithTopicsName.forEach(request -> {
            Assertions.assertEquals((Object)tp.topic(), (Object)request.topic());
            Assertions.assertEquals((Object)topicId, (Object)request.topicId());
            Assertions.assertEquals((int)tp.partition(), (int)request.partition());
            Assertions.assertEquals((Object)tp.topicPartition(), (Object)request.topicPartition());
        });
        String expectedTopic = version >= 13 ? null : tp.topic();
        List requestData = fetchRequest.forgottenTopics(Collections.emptyMap());
        Assertions.assertEquals((int)1, (int)requestData.size());
        requestData.forEach(request -> {
            Assertions.assertEquals((Object)expectedTopic, (Object)request.topic());
            Assertions.assertEquals((Object)topicId, (Object)request.topicId());
            Assertions.assertEquals((int)tp.partition(), (int)request.partition());
            Assertions.assertEquals((Object)new TopicPartition(expectedTopic, partition), (Object)request.topicPartition());
        });
    }

    private FetchRequest createFetchRequestByVersion(short version, Uuid topicId, TopicIdPartition tp) {
        return this.createFetchRequestByVersion(version, tp, new FetchRequest.PartitionData(topicId, 0L, 0L, 0, Optional.empty(), Optional.empty(), Optional.empty()));
    }

    private FetchRequest createFetchRequestByVersion(short version, TopicIdPartition tp, FetchRequest.PartitionData partitionData) {
        Map<TopicPartition, FetchRequest.PartitionData> partitionDataMap = Collections.singletonMap(tp.topicPartition(), partitionData);
        if (version >= 13) {
            return FetchRequest.Builder.forReplica((short)version, (int)0, (long)1L, (int)1, (int)1, partitionDataMap).replaced(Collections.singletonList(tp)).metadata(FetchMetadata.newIncremental((int)123)).build(version);
        }
        return FetchRequest.Builder.forReplica((short)version, (int)0, (long)1L, (int)1, (int)1, partitionDataMap).removed(Collections.singletonList(tp)).metadata(FetchMetadata.newIncremental((int)123)).build(version);
    }

    @ParameterizedTest
    @MethodSource(value={"fetchVersions"})
    public void testFetchDataNoCacheData(short version) {
        Uuid topicId = Uuid.randomUuid();
        int partition = 0;
        TopicIdPartition tp = new TopicIdPartition(topicId, partition, "topic1");
        long fetchOffset = 118L;
        long logStartOffset = 119L;
        int maxBytes = 120;
        Optional<Integer> currentLeaderEpoch = Optional.of(121);
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(topicId, fetchOffset, logStartOffset, maxBytes, Optional.empty(), currentLeaderEpoch, Optional.empty());
        FetchRequest fetchRequest = this.createFetchRequestByVersion(version, tp, partitionData);
        Map<Uuid, String> topicNames = Collections.singletonMap(topicId, tp.topic());
        Map topicIdPartitionMap = fetchRequest.fetchData(topicNames);
        Assertions.assertEquals((int)topicNames.size(), (int)topicIdPartitionMap.size());
        topicIdPartitionMap.forEach((topicIdPartition, partitionDataTmp) -> {
            Assertions.assertEquals((Object)tp.topic(), (Object)topicIdPartition.topic());
            Assertions.assertEquals((Object)topicId, (Object)topicIdPartition.topicId());
            Assertions.assertEquals((int)tp.partition(), (int)topicIdPartition.partition());
            Assertions.assertEquals((Object)tp.topicPartition(), (Object)topicIdPartition.topicPartition());
            Assertions.assertEquals((long)fetchOffset, (long)partitionDataTmp.fetchOffset);
            Assertions.assertEquals((long)logStartOffset, (long)partitionDataTmp.logStartOffset);
            Assertions.assertEquals((int)maxBytes, (int)partitionDataTmp.maxBytes);
            Assertions.assertEquals((Object)currentLeaderEpoch, (Object)partitionDataTmp.currentLeaderEpoch);
        });
        String expectedTopic = version >= 13 ? null : tp.topic();
        topicIdPartitionMap = fetchRequest.fetchData(Collections.emptyMap());
        Assertions.assertEquals((int)1, (int)topicIdPartitionMap.size());
        topicIdPartitionMap.forEach((topicIdPartition, partitionDataTmp) -> {
            Assertions.assertEquals((Object)expectedTopic, (Object)topicIdPartition.topic());
            Assertions.assertEquals((Object)topicId, (Object)topicIdPartition.topicId());
            Assertions.assertEquals((int)tp.partition(), (int)topicIdPartition.partition());
            Assertions.assertEquals((Object)new TopicPartition(expectedTopic, partition), (Object)topicIdPartition.topicPartition());
            Assertions.assertEquals((long)fetchOffset, (long)partitionDataTmp.fetchOffset);
            Assertions.assertEquals((long)logStartOffset, (long)partitionDataTmp.logStartOffset);
            Assertions.assertEquals((int)maxBytes, (int)partitionDataTmp.maxBytes);
            Assertions.assertEquals((Object)currentLeaderEpoch, (Object)partitionDataTmp.currentLeaderEpoch);
        });
    }
}

