/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.ProduceResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProduceResponseTest {
    @Test
    public void produceResponseVersionTest() {
        HashMap<TopicIdPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicIdPartition, ProduceResponse.PartitionResponse>();
        Uuid topicId = Uuid.fromString((String)"5JkYABorYD4w0AQXe9TvBG");
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, 0, "test");
        responseData.put(topicIdPartition, new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L));
        ProduceResponse v0Response = new ProduceResponse(responseData);
        ProduceResponse v1Response = new ProduceResponse(responseData, 10);
        ProduceResponse v2Response = new ProduceResponse(responseData, 10);
        Assertions.assertEquals((int)0, (int)v0Response.throttleTimeMs(), (String)"Throttle time must be zero");
        Assertions.assertEquals((int)10, (int)v1Response.throttleTimeMs(), (String)"Throttle time must be 10");
        Assertions.assertEquals((int)10, (int)v2Response.throttleTimeMs(), (String)"Throttle time must be 10");
        List<ProduceResponse> arrResponse = Arrays.asList(v0Response, v1Response, v2Response);
        for (ProduceResponse produceResponse : arrResponse) {
            Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
            ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)produceResponse.data().responses().iterator().next();
            Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
            ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)topicProduceResponse.partitionResponses().iterator().next();
            Assertions.assertEquals((long)100L, (long)partitionProduceResponse.logStartOffset());
            Assertions.assertEquals((long)10000L, (long)partitionProduceResponse.baseOffset());
            Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
            Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
            Assertions.assertNull((Object)partitionProduceResponse.errorMessage());
            Assertions.assertTrue((boolean)partitionProduceResponse.recordErrors().isEmpty());
            Assertions.assertEquals((Object)topicIdPartition.topicId(), (Object)topicProduceResponse.topicId());
        }
    }

    @Test
    public void produceResponseRecordErrorsTest() {
        HashMap<TopicIdPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicIdPartition, ProduceResponse.PartitionResponse>();
        Uuid topicId = Uuid.fromString((String)"4w0AQXe9TvBG5JkYABorYD");
        TopicIdPartition tp = new TopicIdPartition(topicId, 0, "test");
        ProduceResponse.PartitionResponse partResponse = new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L, Collections.singletonList(new ProduceResponse.RecordError(3, "Record error")), "Produce failed");
        responseData.put(tp, partResponse);
        Iterator iterator = ApiKeys.PRODUCE.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ProduceResponse response = new ProduceResponse(responseData);
            ProduceResponse produceResponse = ProduceResponse.parse((Readable)response.serialize(version), (short)version, (MessageContext)MessageContext.IDENTITY);
            ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)produceResponse.data().responses().iterator().next();
            ProduceResponseData.PartitionProduceResponse deserialized = (ProduceResponseData.PartitionProduceResponse)topicProduceResponse.partitionResponses().iterator().next();
            if (version >= 8) {
                Assertions.assertEquals((int)1, (int)deserialized.recordErrors().size());
                Assertions.assertEquals((int)3, (int)((ProduceResponseData.BatchIndexAndErrorMessage)deserialized.recordErrors().get(0)).batchIndex());
                Assertions.assertEquals((Object)"Record error", (Object)((ProduceResponseData.BatchIndexAndErrorMessage)deserialized.recordErrors().get(0)).batchIndexErrorMessage());
                Assertions.assertEquals((Object)"Produce failed", (Object)deserialized.errorMessage());
                continue;
            }
            Assertions.assertEquals((int)0, (int)deserialized.recordErrors().size());
            Assertions.assertNull((Object)deserialized.errorMessage());
        }
    }
}

