/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.message.ReportQuotaConsumptionResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.ReportQuotaConsumptionRequest;
import org.apache.kafka.common.requests.ReportQuotaConsumptionResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReportQuotaConsumptionRequestTest {
    private static final ReportQuotaConsumptionRequestData DATA0 = new ReportQuotaConsumptionRequestData().setEntries(Collections.singletonList(new ReportQuotaConsumptionRequestData.EntryData().setEntity(Collections.singletonList(new ReportQuotaConsumptionRequestData.EntityData().setEntityType("confluent-tenant").setEntityName("lkc-abcdef"))).setConsumptions(Collections.singletonList(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("ingress").setThrottled(false).setUsage(100.0)))));
    private static final ReportQuotaConsumptionRequestData DATA1 = new ReportQuotaConsumptionRequestData().setEntries(Collections.singletonList(new ReportQuotaConsumptionRequestData.EntryData().setEntity(Collections.singletonList(new ReportQuotaConsumptionRequestData.EntityData().setEntityType("confluent-tenant").setEntityName("lkc-abcdef"))).setConsumptions(Collections.singletonList(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("ingress").setThrottledTimeMs(0.0).setUsage(100.0)))));
    private static final ReportQuotaConsumptionRequest REQUEST0 = new ReportQuotaConsumptionRequest(DATA0, 0);
    private static final ReportQuotaConsumptionRequest REQUEST1 = new ReportQuotaConsumptionRequest(DATA1, 1);

    @Test
    public void testGetErrorResponseWithEntities() {
        ReportQuotaConsumptionResponse resp0 = REQUEST0.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)resp0.errorCounts());
        ReportQuotaConsumptionResponse resp1 = REQUEST1.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)resp1.errorCounts());
    }

    @Test
    public void testEmptyErrorCountsWhenNoErrors() {
        ReportQuotaConsumptionResponseData data = new ReportQuotaConsumptionResponseData().setThrottleTimeMs(10);
        ReportQuotaConsumptionResponse response = new ReportQuotaConsumptionResponse(data);
        Assertions.assertEquals(Collections.emptyMap(), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsReturnsOneError() {
        ReportQuotaConsumptionResponseData data = new ReportQuotaConsumptionResponseData().setThrottleTimeMs(10);
        data.entries().add(new ReportQuotaConsumptionResponseData.EntryData().setErrorCode(Errors.NOT_COORDINATOR.code()));
        ReportQuotaConsumptionResponse response = new ReportQuotaConsumptionResponse(data);
        Map errorCounts = response.errorCounts();
        Assertions.assertEquals((int)1, (int)errorCounts.size());
        Assertions.assertEquals((int)1, (Integer)((Integer)errorCounts.get(Errors.NOT_COORDINATOR)));
    }

    @Test
    public void testAllVersionsParseCorrectly() {
        ReportQuotaConsumptionRequest.parse((Readable)REQUEST0.serialize(), (short)0, null);
        ReportQuotaConsumptionRequest.parse((Readable)REQUEST1.serialize(), (short)1, null);
    }
}

