/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals;

import io.confluent.kafka.server.plugins.auth.stats.AuthenticationStats;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenMock;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerClientInitialResponse;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredLoginCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredValidatorCallbackHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OAuthBearerSaslServerTest {
    private static final String USER = "user";
    private static final String JAAS_CONFIG_TEXT = "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule Required unsecuredLoginStringClaim_sub=\"user\";";
    private static final Map<String, ?> CONFIGS = Map.of("sasl.jaas.config", new Password("org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule Required unsecuredLoginStringClaim_sub=\"user\";"));
    private static final AuthenticateCallbackHandler LOGIN_CALLBACK_HANDLER = new OAuthBearerUnsecuredLoginCallbackHandler();
    private static final AuthenticateCallbackHandler VALIDATOR_CALLBACK_HANDLER;
    private static final AuthenticateCallbackHandler EXTENSIONS_VALIDATOR_CALLBACK_HANDLER;
    private OAuthBearerSaslServer saslServer;
    private static AuthenticationStats stats;

    @BeforeEach
    public void setUp() {
        this.saslServer = new OAuthBearerSaslServer((CallbackHandler)VALIDATOR_CALLBACK_HANDLER);
        stats.reset();
    }

    @Test
    public void noAuthorizationIdSpecified() throws Exception {
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.clientInitialResponse(null));
        Assertions.assertEquals((int)0, (int)nextChallenge.length, (String)"Next challenge is not empty");
        Assertions.assertEquals((long)1L, (long)stats.getSucceeded());
        Assertions.assertEquals((long)0L, (long)stats.getFailed());
        Assertions.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void negotiatedProperty() throws Exception {
        this.saslServer.evaluateResponse(this.clientInitialResponse(USER));
        OAuthBearerToken token = (OAuthBearerToken)this.saslServer.getNegotiatedProperty("OAUTHBEARER.token");
        Assertions.assertNotNull((Object)token);
        Assertions.assertEquals((Object)token.lifetimeMs(), (Object)this.saslServer.getNegotiatedProperty("CREDENTIAL.LIFETIME.MS"));
        Assertions.assertEquals((long)1L, (long)stats.getSucceeded());
        Assertions.assertEquals((long)0L, (long)stats.getFailed());
        Assertions.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void savesCustomExtensionAsNegotiatedProperty() throws Exception {
        HashMap<String, String> customExtensions = new HashMap<String, String>();
        customExtensions.put("firstKey", "value1");
        customExtensions.put("secondKey", "value2");
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.clientInitialResponse(null, false, customExtensions));
        Assertions.assertEquals((int)0, (int)nextChallenge.length, (String)"Next challenge is not empty");
        Assertions.assertEquals((Object)"value1", (Object)this.saslServer.getNegotiatedProperty("firstKey"));
        Assertions.assertEquals((Object)"value2", (Object)this.saslServer.getNegotiatedProperty("secondKey"));
        Assertions.assertEquals((long)1L, (long)stats.getSucceeded());
        Assertions.assertEquals((long)0L, (long)stats.getFailed());
        Assertions.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void unrecognizedExtensionsAreNotSaved() throws Exception {
        this.saslServer = new OAuthBearerSaslServer((CallbackHandler)EXTENSIONS_VALIDATOR_CALLBACK_HANDLER);
        HashMap<String, String> customExtensions = new HashMap<String, String>();
        customExtensions.put("firstKey", "value1");
        customExtensions.put("secondKey", "value1");
        customExtensions.put("thirdKey", "value1");
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.clientInitialResponse(null, false, customExtensions));
        Assertions.assertEquals((int)0, (int)nextChallenge.length, (String)"Next challenge is not empty");
        Assertions.assertNull((Object)this.saslServer.getNegotiatedProperty("thirdKey"), (String)"Extensions not recognized by the server must be ignored");
        Assertions.assertEquals((long)1L, (long)stats.getSucceeded());
        Assertions.assertEquals((long)0L, (long)stats.getFailed());
        Assertions.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void throwsAuthenticationExceptionOnInvalidExtensions() {
        OAuthBearerUnsecuredValidatorCallbackHandler invalidHandler = new OAuthBearerUnsecuredValidatorCallbackHandler(){

            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof OAuthBearerValidatorCallback) {
                        OAuthBearerValidatorCallback validationCallback = (OAuthBearerValidatorCallback)callback;
                        validationCallback.token((OAuthBearerToken)new OAuthBearerTokenMock());
                        continue;
                    }
                    if (callback instanceof OAuthBearerExtensionsValidatorCallback) {
                        OAuthBearerExtensionsValidatorCallback extensionsCallback = (OAuthBearerExtensionsValidatorCallback)callback;
                        extensionsCallback.error("firstKey", "is not valid");
                        extensionsCallback.error("secondKey", "is not valid either");
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        };
        this.saslServer = new OAuthBearerSaslServer((CallbackHandler)invalidHandler);
        HashMap<String, String> customExtensions = new HashMap<String, String>();
        customExtensions.put("firstKey", "value");
        customExtensions.put("secondKey", "value");
        Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.clientInitialResponse(null, false, customExtensions)));
        Assertions.assertEquals((long)0L, (long)stats.getSucceeded());
        Assertions.assertEquals((long)1L, (long)stats.getFailed());
        Assertions.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void authorizationIdEqualsAuthenticationId() throws Exception {
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.clientInitialResponse(USER));
        Assertions.assertEquals((int)0, (int)nextChallenge.length, (String)"Next challenge is not empty");
        Assertions.assertEquals((long)1L, (long)stats.getSucceeded());
        Assertions.assertEquals((long)0L, (long)stats.getFailed());
        Assertions.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void authorizationIdNotEqualsAuthenticationId() {
        Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.clientInitialResponse("userx")));
        Assertions.assertEquals((long)0L, (long)stats.getSucceeded());
        Assertions.assertEquals((long)1L, (long)stats.getFailed());
        Assertions.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void illegalToken() throws Exception {
        byte[] bytes = this.saslServer.evaluateResponse(this.clientInitialResponse(null, true, Collections.emptyMap()));
        String challenge = new String(bytes, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"status\":\"invalid_token\"}", (Object)challenge);
        Assertions.assertEquals((long)0L, (long)stats.getSucceeded());
        Assertions.assertEquals((long)1L, (long)stats.getFailed());
        Assertions.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void testExternalToken() {
        String token = "eyJraWQiOiJ5TmFQamhqX1hac2hrTmh0bFdpeGt3YXVXZUwxNXpHa0N1Rm1DaVVDWURzIiwiYWxnIjoiUlMyNTYifQ.eyJ2ZXIiOjEsImp0aSI6IkFULmlOQ3o1UmotSlBZVzBlRVM1ak1xZDdrMTRnd0tXNi1COGVYWVViakFzMlEiLCJpc3MiOiJodHRwczovL2NjbG91ZC1zc28tc2FuZGJveC5va3RhLmNvbS9vYXV0aDIvYXVzeDZleW03c0JsZ2F3YVM2OTYiLCJhdWQiOiJjb25mbHVlbnQiLCJpYXQiOjE3NDU1Mjc2NTEsImV4cCI6MTc0NTUzMTI1MSwiY2lkIjoiMG9heDZla2NyWVZ6MWQxZUo2OTYiLCJzY3AiOlsic3lzdGVtLXRlc3QiXSwic3ViIjoiMG9heDZla2NyWVZ6MWQxZUo2OTYiLCJjbGFpbTEiOiJ2YWx1ZTEifQ.hDZBhHDon5J0diqMdgU4M6oXRr3zkIwoRCxAyZ_J_mrvbeuVRgv4WHZ4Vj2P6aQfqsWMBdcbzf3Oh7lIJN2k8k84obRWc-pqgBk0aYZRnLYrKYFQxuBb8IdM6hThJ_sqO1rvJebFibpJsQzjufp05y2ev_YdjQBj98pHH8dM-yX1-UyayqTeIBMYQEgVP93XKYKigwJwb2yQ1YUrOV0Y5G_1UUXrRlKQfro-YI_P0xXeNxt0LKMsmMaM3RrJNNkfl9nEp2UbitGySz8qZt_3D20QCoXZWpC_Rv9pNsjEpQAJGz1Q4nqCstWN4UY8oPQMEp4adMET7Nf8LL-t1HeIVQ";
        boolean isExternal = this.saslServer.isValidExternalOAuthToken(token);
        Assertions.assertTrue((boolean)isExternal);
    }

    @Test
    public void testInternalToken() {
        String token = "eyJhbGciOiJSUzI1NiIsImprdSI6Imh0dHBzOi8vYXV0aC1zdGF0aWMtc3RhZy5jb25mbHVlbnQtZGV2LmlvL2p3a3MiLCJraWQiOiI4ZGM3ZWVhMy0yMTNiLTExZjAtOWMwYS1jYWM0MGYyYTcyYjEiLCJ0eXAiOiJKV1QifQ.eyJvcmdhbml6YXRpb25JZCI6NzIwOTMwLCJvcmdSZXNvdXJjZUlkIjoiMmYxMWQyOGItMDNhNS00M2ZkLWJjMjEtMTQ2YWUxMTExNjFiIiwidXNlcklkIjoyNjAyODE3LCJ1c2VyUmVzb3VyY2VJZCI6InUtOHE5ODVtIiwic2NvcGUiOiJodHRwczovL2FwaS5jb25mbHVlbnQuY2xvdWQvIiwiYXVkIjoiQ09OVFJPTF9QTEFORSIsImV4cCI6MTc0NTUyODczNiwianRpIjoiMzNhMzYzZDYtN2U2Zi00YmI5LTk5YTctOGE5ZWYwOTdjZDA4IiwiaWF0IjoxNzQ1NTI4NDM2LCJpc3MiOiJDb25mbHVlbnQiLCJzdWIiOiJ1LThxOTg1bSIsIm1heV9hY3QiOnsicHJpbmNpcGFscyI6WyJ1LThxOTg1bSJdfX0.YkVANFC7xJNveVxXM9ky2pdf5fXeEJsLd6pm0O9wYrE_Dg-6Q5rOgJRM9C2L5ywVPTNF41losKdDVqbI9fyPT8NvNwBQ9zGcmVqceThsFutiY-UMTotdm_nT5zcnAMlonUx2PRA9yGVm5-tEvZAVPC7cHDLxpEl9vj1pIXq07N4kAp8sKWWVUD7FeVvQLYunDyKMMJYhF-ZxhXTStgHBymi3EMgq0NieXDGbRtjnLonErggM2P1o_P5s7lm_sMoq56ps3BQGopl-2XWTS_PRcgihc5iS1avptvY9JJY09KnGSr2EmPH5CNO-IzindIFc4TkYPTXdaFRnlJ5u2VUV8g";
        boolean isExternal = this.saslServer.isValidExternalOAuthToken(token);
        Assertions.assertFalse((boolean)isExternal);
    }

    private byte[] clientInitialResponse(String authorizationId) throws OAuthBearerConfigException, IOException, UnsupportedCallbackException {
        return this.clientInitialResponse(authorizationId, false, Collections.emptyMap());
    }

    private byte[] clientInitialResponse(String authorizationId, boolean illegalToken, Map<String, String> customExtensions) throws OAuthBearerConfigException, IOException, UnsupportedCallbackException {
        OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
        LOGIN_CALLBACK_HANDLER.handle(new Callback[]{callback});
        OAuthBearerToken token = callback.token();
        String compactSerialization = token.value();
        String tokenValue = compactSerialization + (illegalToken ? "AB" : "");
        return new OAuthBearerClientInitialResponse(tokenValue, authorizationId, new SaslExtensions(customExtensions)).toBytes();
    }

    static {
        LOGIN_CALLBACK_HANDLER.configure(CONFIGS, "OAUTHBEARER", JaasContext.loadClientContext(CONFIGS).configurationEntries());
        VALIDATOR_CALLBACK_HANDLER = new OAuthBearerUnsecuredValidatorCallbackHandler();
        VALIDATOR_CALLBACK_HANDLER.configure(CONFIGS, "OAUTHBEARER", JaasContext.loadClientContext(CONFIGS).configurationEntries());
        EXTENSIONS_VALIDATOR_CALLBACK_HANDLER = new OAuthBearerUnsecuredValidatorCallbackHandler(){

            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof OAuthBearerValidatorCallback) {
                        OAuthBearerValidatorCallback validationCallback = (OAuthBearerValidatorCallback)callback;
                        validationCallback.token((OAuthBearerToken)new OAuthBearerTokenMock());
                        continue;
                    }
                    if (callback instanceof OAuthBearerExtensionsValidatorCallback) {
                        OAuthBearerExtensionsValidatorCallback extensionsCallback = (OAuthBearerExtensionsValidatorCallback)callback;
                        extensionsCallback.valid("firstKey");
                        extensionsCallback.valid("secondKey");
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        };
        stats = AuthenticationStats.getInstance();
    }
}

