/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured.assertion;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.AssertionJwtTemplate;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.AssertionUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.DefaultAssertionCreator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.DynamicAssertionJwtTemplate;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.LayeredAssertionJwtTemplate;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.StaticAssertionJwtTemplate;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class DefaultAssertionCreatorTest
extends OAuthBearerTest {
    @Test
    public void testPrivateKey() throws Exception {
        KeyPair keyPair = this.generateKeyPair();
        Builder builder = new Builder().setPrivateKeyFile(this.generatePrivateKey(keyPair.getPrivate()));
        LayeredAssertionJwtTemplate jwtTemplate = new LayeredAssertionJwtTemplate(new AssertionJwtTemplate[]{new StaticAssertionJwtTemplate(Map.of("kid", "test-id"), Map.of()), new DynamicAssertionJwtTemplate((Time)new MockTime(), builder.algorithm, 3600, 60, false)});
        try (DefaultAssertionCreator assertionCreator = builder.build();){
            String assertion = assertionCreator.create((AssertionJwtTemplate)jwtTemplate);
            this.assertClaims(keyPair.getPublic(), assertion);
        }
    }

    @Test
    public void testPrivateKeyId() throws Exception {
        KeyPair keyPair = this.generateKeyPair();
        Builder builder = new Builder().setPrivateKeyFile(this.generatePrivateKey(keyPair.getPrivate()));
        LayeredAssertionJwtTemplate jwtTemplate = new LayeredAssertionJwtTemplate(new AssertionJwtTemplate[]{new StaticAssertionJwtTemplate(Map.of("kid", "test-id"), Map.of()), new DynamicAssertionJwtTemplate((Time)new MockTime(), builder.algorithm, 3600, 60, false)});
        try (DefaultAssertionCreator assertionCreator = builder.build();){
            String assertion = assertionCreator.create((AssertionJwtTemplate)jwtTemplate);
            JwtContext context = this.assertContext(keyPair.getPublic(), assertion);
            List joseObjects = context.getJoseObjects();
            Assertions.assertNotNull((Object)joseObjects);
            Assertions.assertEquals((int)1, (int)joseObjects.size());
            JsonWebStructure jsonWebStructure = (JsonWebStructure)joseObjects.get(0);
            Assertions.assertEquals((Object)"test-id", (Object)jsonWebStructure.getKeyIdHeaderValue());
        }
    }

    @Test
    public void testInvalidPrivateKey() throws Exception {
        File privateKeyFile = this.generatePrivateKey();
        long originalFileLength = privateKeyFile.length();
        int bytesToTruncate = 10;
        try (FileChannel channel = FileChannel.open(privateKeyFile.toPath(), StandardOpenOption.WRITE);){
            long size = channel.size();
            Assertions.assertEquals((long)originalFileLength, (long)size);
            Assertions.assertTrue((size > (long)bytesToTruncate ? 1 : 0) != 0);
            channel.truncate(size - (long)bytesToTruncate);
        }
        Assertions.assertEquals((long)(originalFileLength - (long)bytesToTruncate), (long)privateKeyFile.length());
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new Builder().setPrivateKeyFile(privateKeyFile).build());
        Assertions.assertNotNull((Object)e.getCause());
        Assertions.assertInstanceOf(GeneralSecurityException.class, (Object)e.getCause());
    }

    @ParameterizedTest
    @CsvSource(value={"RS256,ES256"})
    public void testAlgorithm(String algorithm) throws Exception {
        String assertion;
        KeyPair keyPair = this.generateKeyPair();
        Builder builder = new Builder().setPrivateKeyFile(this.generatePrivateKey(keyPair.getPrivate())).setAlgorithm(algorithm);
        try (DefaultAssertionCreator assertionCreator = builder.build();){
            DynamicAssertionJwtTemplate jwtTemplate = new DynamicAssertionJwtTemplate((Time)new MockTime(), algorithm, 3600, 60, false);
            assertion = assertionCreator.create((AssertionJwtTemplate)jwtTemplate);
        }
        this.assertClaims(keyPair.getPublic(), assertion);
        JwtContext context = this.assertContext(keyPair.getPublic(), assertion);
        List joseObjects = context.getJoseObjects();
        Assertions.assertNotNull((Object)joseObjects);
        Assertions.assertEquals((int)1, (int)joseObjects.size());
        JsonWebStructure jsonWebStructure = (JsonWebStructure)joseObjects.get(0);
        Assertions.assertEquals((Object)algorithm, (Object)jsonWebStructure.getAlgorithmHeaderValue());
    }

    @Test
    public void testInvalidAlgorithm() throws IOException {
        PrivateKey privateKey = this.generateKeyPair().getPrivate();
        Builder builder = new Builder().setPrivateKeyFile(this.generatePrivateKey(privateKey)).setAlgorithm("thisisnotvalid");
        Assertions.assertThrows(NoSuchAlgorithmException.class, () -> AssertionUtils.getSignature((String)builder.algorithm));
        Assertions.assertThrows(NoSuchAlgorithmException.class, () -> AssertionUtils.sign((String)builder.algorithm, (PrivateKey)privateKey, (String)"dummy content"));
    }

    private static class Builder {
        private final Time time = new MockTime();
        private String algorithm = "RS256";
        private File privateKeyFile;
        private Optional<String> passphrase = Optional.empty();

        private Builder() {
        }

        public Builder setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder setPrivateKeyFile(File privateKeyFile) {
            this.privateKeyFile = privateKeyFile;
            return this;
        }

        public Builder setPassphrase(String passphrase) {
            this.passphrase = Optional.of(passphrase);
            return this;
        }

        private DefaultAssertionCreator build() {
            return new DefaultAssertionCreator(this.algorithm, this.privateKeyFile, this.passphrase);
        }
    }
}

