/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured.assertion;

import java.io.File;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.FileAssertionCreator;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileAssertionCreatorTest
extends OAuthBearerTest {
    @Test
    public void testBasicUsage() throws Exception {
        String expected = this.createJwt("jdoe");
        File tmpFile = TestUtils.tempFile(expected);
        try (FileAssertionCreator assertionCreator = new FileAssertionCreator(tmpFile);){
            String assertion = assertionCreator.create(null);
            Assertions.assertEquals((Object)expected, (Object)assertion);
        }
    }

    @Test
    public void testJwtWithWhitespace() throws Exception {
        String expected = this.createJwt("jdoe");
        File tmpFile = TestUtils.tempFile("    " + expected + "\n\n\n");
        try (FileAssertionCreator assertionCreator = new FileAssertionCreator(tmpFile);){
            String assertion = assertionCreator.create(null);
            Assertions.assertEquals((Object)expected, (Object)assertion);
        }
    }
}

