/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.ReferenceCountedOpenSslServerContext;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.HashMap;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactoryTest;
import org.apache.kafka.common.security.ssl.NettySslEngineFactory;
import org.apache.kafka.common.security.ssl.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class NettySslEngineFactoryTest
extends DefaultSslEngineFactoryTest {
    @Override
    @BeforeEach
    public void setUp() throws IOException {
        super.setUp();
        this.factory = new NettySslEngineFactory();
    }

    @Override
    @Test
    @Disabled
    public void testPemKeyStoreConfigNoPassword() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testPemKeyStoreFileNoKeyPassword() throws Exception {
    }

    @Test
    public void returnsTrueWhenKeystoreConfigsArePresent() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("ssl.keystore.type", "JKS");
        configs.put("ssl.keystore.location", "/path/to/keystore.jks");
        configs.put("ssl.keystore.password", "password");
        Assertions.assertTrue((boolean)NettySslEngineFactory.configsContainKeystore(configs));
    }

    @Test
    public void returnsFalseWhenKeystoreTypeConfigIsMissing() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("ssl.keystore.location", "/path/to/keystore.jks");
        configs.put("ssl.keystore.password", "password");
        Assertions.assertFalse((boolean)NettySslEngineFactory.configsContainKeystore(configs));
    }

    @Test
    public void returnsFalseWhenKeystoreLocationConfigIsMissing() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("ssl.keystore.type", "JKS");
        configs.put("ssl.keystore.password", "password");
        Assertions.assertFalse((boolean)NettySslEngineFactory.configsContainKeystore(configs));
    }

    @Test
    public void returnsFalseWhenKeystorePasswordConfigIsMissing() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("ssl.keystore.type", "JKS");
        configs.put("ssl.keystore.location", "/path/to/keystore.jks");
        Assertions.assertFalse((boolean)NettySslEngineFactory.configsContainKeystore(configs));
    }

    @Test
    public void returnsFalseWhenConfigsAreEmpty() {
        HashMap configs = new HashMap();
        Assertions.assertFalse((boolean)NettySslEngineFactory.configsContainKeystore(configs));
    }

    @Test
    public void throwsExceptionWhenClientSessionContextNotConfigured() {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        Assertions.assertThrows(RuntimeException.class, () -> ((NettySslEngineFactory)factory).clientSessionContext());
    }

    @Test
    public void throwsExceptionWhenServerSessionContextNotConfigured() {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        Assertions.assertThrows(RuntimeException.class, () -> ((NettySslEngineFactory)factory).serverSessionContext());
    }

    @Test
    public void returnsClientSessionContextWhenConfigured() {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        factory.configure(this.configs);
        Assertions.assertNotNull((Object)factory.clientSessionContext());
    }

    @Test
    public void throwsExceptionWhenServerSessionContextNotConfiguredCorrectly() {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        this.configs.put("ssl.keystore.location", "keystore.jks");
        Assertions.assertThrows(RuntimeException.class, () -> ((NettySslEngineFactory)factory).serverSessionContext());
    }

    @Test
    public void returnsServerSessionContextWhenConfigured() throws Exception {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        TestUtils.createKeystoreAndSetConfigs(this.configs);
        factory.configure(this.configs);
        Assertions.assertNotNull((Object)factory.serverSessionContext());
    }

    @Test
    public void throwsExceptionWhenClientApplicationProtocolNegotiatorNotConfigured() {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        Assertions.assertThrows(RuntimeException.class, () -> ((NettySslEngineFactory)factory).clientApplicationProtocolNegotiator());
    }

    @Test
    public void returnsClientApplicationProtocolNegotiatorWhenConfigured() {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        factory.configure(this.configs);
        Assertions.assertNotNull((Object)factory.clientApplicationProtocolNegotiator());
        Assertions.assertTrue((boolean)factory.clientApplicationProtocolNegotiator().protocols().isEmpty());
    }

    @Test
    public void returnsClientApplicationProtocolNegotiatorWhenConfiguredWithHttp2() {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        this.configs.put("confluent.listener.protocol", "HTTP2");
        factory.configure(this.configs);
        Assertions.assertNotNull((Object)factory.clientApplicationProtocolNegotiator());
        Assertions.assertEquals((int)1, (int)factory.clientApplicationProtocolNegotiator().protocols().size());
        Assertions.assertEquals((Object)"h2", factory.clientApplicationProtocolNegotiator().protocols().get(0));
    }

    @Test
    public void throwsExceptionWhenServerApplicationProtocolNegotiatorNotConfigured() {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        Assertions.assertThrows(RuntimeException.class, () -> ((NettySslEngineFactory)factory).serverApplicationProtocolNegotiator());
    }

    @Test
    public void returnsServerApplicationProtocolNegotiatorWhenConfigured() throws Exception {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        TestUtils.createKeystoreAndSetConfigs(this.configs);
        factory.configure(this.configs);
        Assertions.assertNotNull((Object)factory.serverApplicationProtocolNegotiator());
    }

    @Test
    public void returnsServerApplicationProtocolNegotiatorWhenConfiguredWithHttp2() throws Exception {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        this.configs.put("confluent.listener.protocol", "HTTP2");
        TestUtils.createKeystoreAndSetConfigs(this.configs);
        factory.configure(this.configs);
        Assertions.assertNotNull((Object)factory.serverApplicationProtocolNegotiator());
        Assertions.assertEquals((int)1, (int)factory.serverApplicationProtocolNegotiator().protocols().size());
        Assertions.assertEquals((Object)"h2", factory.serverApplicationProtocolNegotiator().protocols().get(0));
    }

    @Test
    public void throwsExceptionWhenServerSslEngineCreatedWithoutConfiguration() {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        Assertions.assertThrows(RuntimeException.class, () -> factory.createServerSslEngine(ByteBufAllocator.DEFAULT, "localhost", 9092));
    }

    @Test
    public void throwsExceptionWhenServerSslEngineCreatedWithNullContext() {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        factory.configure(this.configs);
        Assertions.assertThrows(RuntimeException.class, () -> factory.createServerSslEngine(ByteBufAllocator.DEFAULT, "localhost", 9092));
    }

    @Test
    public void createsServerSslEngineSuccessfullyWhenConfigured() throws Exception {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        TestUtils.createKeystoreAndSetConfigs(this.configs);
        this.configs.put("ssl.client.auth", SslClientAuth.REQUESTED.toString());
        factory.configure(this.configs);
        SSLEngine sslEngine = factory.createServerSslEngine(ByteBufAllocator.DEFAULT, "localhost", 9092);
        Assertions.assertNotNull((Object)sslEngine);
        Assertions.assertFalse((boolean)sslEngine.getUseClientMode());
        Assertions.assertEquals((Object)"localhost", (Object)sslEngine.getPeerHost());
        Assertions.assertEquals((int)9092, (int)sslEngine.getPeerPort());
        Assertions.assertTrue((boolean)sslEngine.getWantClientAuth());
        Assertions.assertFalse((boolean)sslEngine.getNeedClientAuth());
    }

    @Test
    public void throwsExceptionWhenClientSslEngineCreatedWithoutConfigurationWithHostAndPort() {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        Assertions.assertThrows(RuntimeException.class, () -> factory.createClientSslEngine(ByteBufAllocator.DEFAULT, "localhost", 9092, "HTTPS"));
    }

    @Test
    public void createsClientSslEngineSuccessfullyWhenConfiguredWithHostAndPort() throws Exception {
        NettySslEngineFactory factory = (NettySslEngineFactory)this.factory;
        factory.configure(this.configs);
        SSLEngine sslEngine = factory.createClientSslEngine(ByteBufAllocator.DEFAULT, "localhost", 9092, "HTTPS");
        Assertions.assertNotNull((Object)sslEngine);
        Assertions.assertTrue((boolean)sslEngine.getUseClientMode());
        Assertions.assertEquals((Object)"localhost", (Object)sslEngine.getPeerHost());
        Assertions.assertEquals((int)9092, (int)sslEngine.getPeerPort());
        Assertions.assertEquals((Object)"HTTPS", (Object)sslEngine.getSSLParameters().getEndpointIdentificationAlgorithm());
    }

    @Override
    protected DefaultSslEngineFactory sslEngineFactory() {
        return new NettySslEngineFactory();
    }

    @Override
    @Test
    public void testReloadingOnClosed() throws Exception {
        this.configs.put("confluent.ssl.enable.dynamic.store.update", "true");
        TestUtils.createKeystoreAndSetConfigs(this.configs);
        NettySslEngineFactory factory = (NettySslEngineFactory)this.sslEngineFactory();
        factory.configure(this.configs);
        ReferenceCountedOpenSslClientContext clientContext = (ReferenceCountedOpenSslClientContext)factory.clientSslContext();
        ReferenceCountedOpenSslServerContext serverContext = (ReferenceCountedOpenSslServerContext)factory.serverSslContext();
        Assertions.assertEquals((Object)clientContext, (Object)factory.clientSslContext());
        Assertions.assertEquals((Object)serverContext, (Object)factory.serverSslContext());
        Assertions.assertEquals((int)1, (int)clientContext.refCnt());
        Assertions.assertEquals((int)1, (int)serverContext.refCnt());
        ReferenceCountedOpenSslEngine sslEngine = (ReferenceCountedOpenSslEngine)factory.clientSslContext().newEngine(ByteBufAllocator.DEFAULT);
        Assertions.assertNotNull((Object)sslEngine);
        Assertions.assertEquals((int)1, (int)sslEngine.refCnt());
        Assertions.assertEquals((int)2, (int)clientContext.refCnt());
        factory.createAndSetSSLContext();
        Assertions.assertNotEquals((Object)clientContext, (Object)factory.clientSslContext());
        Assertions.assertNotEquals((Object)serverContext, (Object)factory.serverSslContext());
        Assertions.assertEquals((int)1, (int)clientContext.refCnt());
        Assertions.assertEquals((int)0, (int)serverContext.refCnt());
        ReferenceCountUtil.release((Object)sslEngine);
        Assertions.assertEquals((int)0, (int)sslEngine.refCnt());
        Assertions.assertEquals((int)0, (int)clientContext.refCnt());
        clientContext = (ReferenceCountedOpenSslClientContext)factory.clientSslContext();
        serverContext = (ReferenceCountedOpenSslServerContext)factory.serverSslContext();
        factory.close();
        Assertions.assertEquals((int)0, (int)clientContext.refCnt());
        Assertions.assertEquals((int)0, (int)serverContext.refCnt());
        Assertions.assertNull((Object)factory.clientSslContext());
        Assertions.assertNull((Object)factory.serverSslContext());
        factory.createAndSetSSLContext();
        Assertions.assertNull((Object)factory.clientSslContext());
        Assertions.assertNull((Object)factory.serverSslContext());
    }
}

