/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.InputStream;
import java.util.Properties;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SslPrincipalMapperTest {
    @Test
    public void testValidRules() {
        this.testValidRule("DEFAULT");
        this.testValidRule("RULE:^CN=(.*?),OU=ServiceUsers.*$/$1/");
        this.testValidRule("RULE:^CN=(.*?),OU=ServiceUsers.*$/$1/L, DEFAULT");
        this.testValidRule("RULE:^CN=(.*?),OU=(.*?),O=(.*?),L=(.*?),ST=(.*?),C=(.*?)$/$1@$2/");
        this.testValidRule("RULE:^.*[Cc][Nn]=([a-zA-Z0-9.]*).*$/$1/L");
        this.testValidRule("RULE:^cn=(.?),ou=(.?),dc=(.?),dc=(.?)$/$1@$2/U");
        this.testValidRule("RULE:^CN=([^,ADEFLTU,]+)(,.*|$)/$1/");
        this.testValidRule("RULE:^CN=([^,DEFAULT,]+)(,.*|$)/$1/");
    }

    private void testValidRule(String rules) {
        SslPrincipalMapper.fromRules((String)rules);
    }

    @Test
    public void testInvalidRules() {
        this.testInvalidRule("default");
        this.testInvalidRule("DEFAUL");
        this.testInvalidRule("DEFAULT/L");
        this.testInvalidRule("DEFAULT/U");
        this.testInvalidRule("RULE:CN=(.*?),OU=ServiceUsers.*/$1");
        this.testInvalidRule("rule:^CN=(.*?),OU=ServiceUsers.*$/$1/");
        this.testInvalidRule("RULE:^CN=(.*?),OU=ServiceUsers.*$/$1/L/U");
        this.testInvalidRule("RULE:^CN=(.*?),OU=ServiceUsers.*$/L");
        this.testInvalidRule("RULE:^CN=(.*?),OU=ServiceUsers.*$/U");
        this.testInvalidRule("RULE:^CN=(.*?),OU=ServiceUsers.*$/LU");
    }

    private void testInvalidRule(String rules) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SslPrincipalMapper.fromRules((String)rules));
    }

    @Test
    public void testSslPrincipalMapper() throws Exception {
        String rules = String.join((CharSequence)", ", "RULE:^CN=(.*?),OU=ServiceUsers.*$/$1/L", "RULE:^CN=(.*?),OU=(.*?),O=(.*?),L=(.*?),ST=(.*?),C=(.*?)$/$1@$2/L", "RULE:^cn=(.*?),ou=(.*?),dc=(.*?),dc=(.*?)$/$1@$2/U", "RULE:^.*[Cc][Nn]=([a-zA-Z0-9.]*).*$/$1/U", "DEFAULT");
        SslPrincipalMapper mapper = SslPrincipalMapper.fromRules((String)rules);
        Assertions.assertEquals((Object)"duke", (Object)mapper.getName("CN=Duke,OU=ServiceUsers,O=Org,C=US"));
        Assertions.assertEquals((Object)"duke@sme", (Object)mapper.getName("CN=Duke,OU=SME,O=mycp,L=Fulton,ST=MD,C=US"));
        Assertions.assertEquals((Object)"DUKE@SME", (Object)mapper.getName("cn=duke,ou=sme,dc=mycp,dc=com"));
        Assertions.assertEquals((Object)"DUKE", (Object)mapper.getName("cN=duke,OU=JavaSoft,O=Sun Microsystems"));
        Assertions.assertEquals((Object)"OU=JavaSoft,O=Sun Microsystems,C=US", (Object)mapper.getName("OU=JavaSoft,O=Sun Microsystems,C=US"));
    }

    private void testRulesSplitting(String expected, String rules) {
        SslPrincipalMapper mapper = SslPrincipalMapper.fromRules((String)rules);
        Assertions.assertEquals((Object)String.format("SslPrincipalMapper(rules = %s)", expected), (Object)mapper.toString());
    }

    @Test
    public void testRulesSplitting() {
        this.testRulesSplitting("[]", "");
        this.testRulesSplitting("[DEFAULT]", "DEFAULT");
        this.testRulesSplitting("[RULE:/]", "RULE://");
        this.testRulesSplitting("[RULE:/.*]", "RULE:/.*/");
        this.testRulesSplitting("[RULE:/.*/L]", "RULE:/.*/L");
        this.testRulesSplitting("[RULE:/, DEFAULT]", "RULE://,DEFAULT");
        this.testRulesSplitting("[RULE:/, DEFAULT]", "  RULE:// ,  DEFAULT  ");
        this.testRulesSplitting("[RULE:   /     , DEFAULT]", "  RULE:   /     / ,  DEFAULT  ");
        this.testRulesSplitting("[RULE:  /     /U, DEFAULT]", "  RULE:  /     /U   ,DEFAULT  ");
        this.testRulesSplitting("[RULE:([A-Z]*)/$1/U, RULE:([a-z]+)/$1, DEFAULT]", "  RULE:([A-Z]*)/$1/U   ,RULE:([a-z]+)/$1/,   DEFAULT  ");
        this.testRulesSplitting("[]", ",   , , ,      , , ,   ");
        this.testRulesSplitting("[RULE:/, DEFAULT]", ",,RULE://,,,DEFAULT,,");
        this.testRulesSplitting("[RULE: /   , DEFAULT]", ",  , RULE: /   /    ,,,   DEFAULT, ,   ");
        this.testRulesSplitting("[RULE:   /  /U, DEFAULT]", "     ,  , RULE:   /  /U    ,,  ,DEFAULT, ,");
        this.testRulesSplitting("[RULE:\\/\\\\\\(\\)\\n\\t/\\/\\/]", "RULE:\\/\\\\\\(\\)\\n\\t/\\/\\//");
        this.testRulesSplitting("[RULE:\\**\\/+/*/L, RULE:\\/*\\**/**]", "RULE:\\**\\/+/*/L,RULE:\\/*\\**/**/");
        this.testRulesSplitting("[RULE:,RULE:,/,RULE:,\\//U, RULE:,/RULE:,, RULE:,RULE:,/L,RULE:,/L, RULE:, DEFAULT, /DEFAULT, DEFAULT]", "RULE:,RULE:,/,RULE:,\\//U,RULE:,/RULE:,/,RULE:,RULE:,/L,RULE:,/L,RULE:, DEFAULT, /DEFAULT/,DEFAULT");
    }

    @Test
    public void testCommaWithWhitespace() throws Exception {
        String rules = "RULE:^CN=((\\\\, *|\\w)+)(,.*|$)/$1/,DEFAULT";
        SslPrincipalMapper mapper = SslPrincipalMapper.fromRules((String)rules);
        Assertions.assertEquals((Object)"Tkac\\, Adam", (Object)mapper.getName("CN=Tkac\\, Adam,OU=ITZ,DC=geodis,DC=cz"));
    }

    @Test
    public void testNeedBackslashWhenReadingFromConfig() throws Exception {
        Properties props = new Properties();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("someSSLMapper.properties");
        props.load(is);
        String rules = props.getProperty("ssl.principal.mapping.rules.with.backslash");
        SslPrincipalMapper mapper = SslPrincipalMapper.fromRules((String)rules);
        Assertions.assertEquals((Object)"CN=mirrormaker-fat,O=Org,DC=geodis,DC=cz", (Object)mapper.getName("CN=mirrormaker-fat,O=Org,DC=geodis,DC=cz"));
        rules = props.getProperty("ssl.principal.mapping.rules.without.backslash");
        mapper = SslPrincipalMapper.fromRules((String)rules);
        Assertions.assertEquals((Object)"_mirrormaker_sp_kafka", (Object)mapper.getName("CN=mirrormaker-fat, O=The Organization Name, L=Vienna, ST=Vienna, C=AT"));
    }
}

