/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.telemetry.internals;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Predicate;
import org.apache.kafka.common.telemetry.internals.ClientTelemetryEmitter;
import org.apache.kafka.common.telemetry.internals.ClientTelemetryUtils;
import org.apache.kafka.common.telemetry.internals.MetricKey;
import org.apache.kafka.common.telemetry.internals.MetricKeyable;
import org.apache.kafka.common.telemetry.internals.SinglePointMetric;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientTelemetryEmitterTest {
    private MetricKey metricKey;
    private Instant now;

    @BeforeEach
    public void setUp() {
        this.metricKey = new MetricKey("name", Collections.emptyMap());
        this.now = Instant.now();
    }

    @Test
    public void testShouldEmitMetric() {
        Predicate selector = ClientTelemetryUtils.getSelectorFromRequestedMetrics(Collections.singletonList("io.test.metric"));
        ClientTelemetryEmitter emitter = new ClientTelemetryEmitter(selector, true);
        Assertions.assertTrue((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("io.test.metric")));
        Assertions.assertTrue((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("io.test.metric1")));
        Assertions.assertTrue((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("io.test.metric.producer.bytes")));
        Assertions.assertFalse((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("io.test")));
        Assertions.assertFalse((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("org.io.test.metric")));
        Assertions.assertTrue((boolean)emitter.shouldEmitDeltaMetrics());
    }

    @Test
    public void testShouldEmitMetricSelectorAll() {
        ClientTelemetryEmitter emitter = new ClientTelemetryEmitter(ClientTelemetryUtils.SELECTOR_ALL_METRICS, true);
        Assertions.assertTrue((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("io.test.metric")));
        Assertions.assertTrue((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("io.test.metric1")));
        Assertions.assertTrue((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("io.test.metric.producer.bytes")));
        Assertions.assertTrue((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("io.test")));
        Assertions.assertTrue((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("org.io.test.metric")));
        Assertions.assertTrue((boolean)emitter.shouldEmitDeltaMetrics());
    }

    @Test
    public void testShouldEmitMetricSelectorNone() {
        ClientTelemetryEmitter emitter = new ClientTelemetryEmitter(ClientTelemetryUtils.SELECTOR_NO_METRICS, true);
        Assertions.assertFalse((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("io.test.metric")));
        Assertions.assertFalse((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("io.test.metric1")));
        Assertions.assertFalse((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("io.test.metric.producer.bytes")));
        Assertions.assertFalse((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("io.test")));
        Assertions.assertFalse((boolean)emitter.shouldEmitMetric((MetricKeyable)new MetricKey("org.io.test.metric")));
        Assertions.assertTrue((boolean)emitter.shouldEmitDeltaMetrics());
    }

    @Test
    public void testShouldEmitDeltaMetricsFalse() {
        ClientTelemetryEmitter emitter = new ClientTelemetryEmitter(ClientTelemetryUtils.SELECTOR_ALL_METRICS, false);
        Assertions.assertFalse((boolean)emitter.shouldEmitDeltaMetrics());
    }

    @Test
    public void testEmitMetric() {
        Predicate selector = ClientTelemetryUtils.getSelectorFromRequestedMetrics(Collections.singletonList("name"));
        ClientTelemetryEmitter emitter = new ClientTelemetryEmitter(selector, true);
        SinglePointMetric gauge = SinglePointMetric.gauge((MetricKey)this.metricKey, (Number)1L, (Instant)this.now, Collections.emptySet());
        SinglePointMetric sum = SinglePointMetric.sum((MetricKey)this.metricKey, (double)1.0, (boolean)true, (Instant)this.now, Collections.emptySet());
        Assertions.assertTrue((boolean)emitter.emitMetric(gauge));
        Assertions.assertTrue((boolean)emitter.emitMetric(sum));
        MetricKey anotherKey = new MetricKey("io.name", Collections.emptyMap());
        Assertions.assertFalse((boolean)emitter.emitMetric(SinglePointMetric.gauge((MetricKey)anotherKey, (Number)1L, (Instant)this.now, Collections.emptySet())));
        Assertions.assertEquals((int)2, (int)emitter.emittedMetrics().size());
        Assertions.assertEquals(Arrays.asList(gauge, sum), (Object)emitter.emittedMetrics());
    }
}

