/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.DefaultUncaughtExceptionHandler;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.KafkaThread;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KafkaThreadTest {
    private boolean exited;

    @BeforeEach
    public void setup() {
        System.setProperty("disableSystemExit", "true");
        this.exited = false;
        Exit.setHaltProcedure((statusCode, message) -> {
            this.exited = true;
        });
    }

    @AfterEach
    public void cleanup() {
        Exit.resetHaltProcedure();
    }

    @Test
    public void testExitOnOutOfMemoryError() throws InterruptedException {
        DefaultUncaughtExceptionHandler.enableExitOnOutOfMemoryError((boolean)true);
        Runnable r = () -> {
            throw new OutOfMemoryError("Simulated OutOfMemoryError");
        };
        KafkaThread t = new KafkaThread("test", r, false);
        t.start();
        t.join();
        Assertions.assertTrue((boolean)this.exited, (String)"Exit should have been invoked");
    }

    @Test
    public void testNotExitOnNormalException() throws InterruptedException {
        DefaultUncaughtExceptionHandler.enableExitOnOutOfMemoryError((boolean)true);
        Runnable r = () -> {
            throw new NullPointerException("Normal exception");
        };
        KafkaThread t = new KafkaThread("test", r, false);
        t.start();
        t.join();
        Assertions.assertFalse((boolean)this.exited, (String)"Exit should not be invoked");
    }

    @Test
    public void testNotExitOnOutOfMemoryError() throws InterruptedException {
        DefaultUncaughtExceptionHandler.enableExitOnOutOfMemoryError((boolean)false);
        Runnable r = () -> {
            throw new OutOfMemoryError("Simulated OutOfMemoryError");
        };
        KafkaThread t = new KafkaThread("test", r, false);
        t.start();
        t.join();
        Assertions.assertFalse((boolean)this.exited, (String)"Exit should not be invoked");
    }
}

