/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.oauthbearer;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;

public class OAuthBearerJwsToken
implements OAuthBearerToken {
    public static final String OAUTH_AUTHORIZED_PARTY = "azp";
    public static final String OAUTH_NEGOTIATED_LOGICAL_CLUSTER_PROPERTY_KEY = "logicalCluster";
    public static final String USER_RESOURCE_ID_CLAIM = "userResourceId";
    public static final String OAUTH_IDENTITY_POOL_PROPERTY_KEY = "identityPoolId";
    public static final String OAUTH_IDENTITY_POOL_PROVIDER_ID_PROPERTY_KEY = "providerId";
    public static final String OAUTH_ORG_RESOURCE_ID_CLAIM = "orgResourceId";
    public static final String AUD_CLAIM_VALUE_CONTROL_PLANE = "CONTROL_PLANE";
    public static final String AUD_CLAIM = "aud";
    public static final String OAUTH_MAY_ACT_CLAIM = "may_act";
    public static final String OAUTH_EXTERNAL_IDENTITY_ID = "externalIdentityId";
    public static final String NETWORK_CONTEXT_CLAIM = "network_context";
    public static final String NETWORK_CONTEXT_IP_ADDRESS = "ip_address";
    public static final String NETWORK_CONTEXT_CONNECTION_TYPE = "connection_type";
    private final String value;
    private final String principalName;
    private final Set<String> scope;
    private final long lifetimeMs;
    private final Long startTimeMs;
    private final Map<String, Object> jwtClaims;
    private final String issuer;

    public OAuthBearerJwsToken(String value, Set<String> scope, long lifetimeMs, String principalName, Long startTimeMs) {
        this(value, scope, lifetimeMs, principalName, startTimeMs, null, null);
    }

    public OAuthBearerJwsToken(String value, Set<String> scope, long lifetimeMs, String principalName, Long startTimeMs, Map<String, Object> jwtClaims) {
        this.value = value;
        this.principalName = principalName;
        this.scope = scope == null ? Collections.emptySet() : scope;
        this.lifetimeMs = lifetimeMs;
        this.startTimeMs = startTimeMs;
        this.jwtClaims = jwtClaims == null ? Collections.emptyMap() : jwtClaims;
        this.issuer = null;
    }

    public OAuthBearerJwsToken(String value, Set<String> scope, long lifetimeMs, String principalName, Long startTimeMs, Map<String, Object> jwtClaims, String issuer) {
        this.value = value;
        this.principalName = principalName;
        this.scope = scope == null ? Collections.emptySet() : scope;
        this.lifetimeMs = lifetimeMs;
        this.startTimeMs = startTimeMs;
        this.jwtClaims = jwtClaims == null ? Collections.emptyMap() : jwtClaims;
        this.issuer = issuer;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public Set<String> scope() {
        return Collections.unmodifiableSet(this.scope);
    }

    @Override
    public long lifetimeMs() {
        return this.lifetimeMs;
    }

    @Override
    public String principalName() {
        String reconciledPrincipal;
        Object principal = this.jwtClaims.get(OAUTH_AUTHORIZED_PARTY);
        String string = reconciledPrincipal = principal != null ? String.valueOf(principal) : null;
        if (reconciledPrincipal != null) {
            return reconciledPrincipal;
        }
        return this.principalName;
    }

    @Override
    public Long startTimeMs() {
        return this.startTimeMs;
    }

    public Map<String, Object> jwtClaims() {
        return this.jwtClaims;
    }

    public String issuer() {
        return this.issuer;
    }
}

