/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.BrokerHealthStatusResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class AlterBrokerHealthResult {
    private final Map<Integer, KafkaFuture<BrokerHealthStatusResult>> futures;

    AlterBrokerHealthResult(Map<Integer, KafkaFuture<BrokerHealthStatusResult>> futures) {
        this.futures = futures;
    }

    public Map<Integer, KafkaFuture<BrokerHealthStatusResult>> values() {
        return this.futures;
    }

    public KafkaFuture<Map<Integer, BrokerHealthStatusResult>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(v -> {
            HashMap resultMap = new HashMap();
            this.futures.forEach((broker, future) -> {
                try {
                    resultMap.put(broker, (BrokerHealthStatusResult)future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return resultMap;
        });
    }
}

