/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterClusterLinksRequestData
implements ApiMessage {
    List<AlterClusterLinkData> alterClusterLinks;
    int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("alter_cluster_links", new CompactArrayOf(AlterClusterLinkData.SCHEMA_0), "The cluster links to alter"), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AlterClusterLinksRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterClusterLinksRequestData() {
        this.alterClusterLinks = new ArrayList<AlterClusterLinkData>(0);
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 10043;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field alterClusterLinks was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<AlterClusterLinkData> newCollection = new ArrayList<AlterClusterLinkData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new AlterClusterLinkData(_readable, _version, _context));
        }
        this.alterClusterLinks = newCollection;
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.alterClusterLinks.size() + 1);
        for (AlterClusterLinkData alterClusterLinksElement : this.alterClusterLinks) {
            alterClusterLinksElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.alterClusterLinks.size() + 1));
        for (AlterClusterLinkData alterClusterLinksElement : this.alterClusterLinks) {
            alterClusterLinksElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterClusterLinksRequestData)) {
            return false;
        }
        AlterClusterLinksRequestData other = (AlterClusterLinksRequestData)obj;
        if (this.alterClusterLinks == null ? other.alterClusterLinks != null : !this.alterClusterLinks.equals(other.alterClusterLinks)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.alterClusterLinks == null ? 0 : this.alterClusterLinks.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public AlterClusterLinksRequestData duplicate() {
        AlterClusterLinksRequestData _duplicate = new AlterClusterLinksRequestData();
        ArrayList<AlterClusterLinkData> newAlterClusterLinks = new ArrayList<AlterClusterLinkData>(this.alterClusterLinks.size());
        for (AlterClusterLinkData _element : this.alterClusterLinks) {
            newAlterClusterLinks.add(_element.duplicate());
        }
        _duplicate.alterClusterLinks = newAlterClusterLinks;
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "AlterClusterLinksRequestData(alterClusterLinks=" + MessageUtil.deepToString(this.alterClusterLinks.iterator()) + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<AlterClusterLinkData> alterClusterLinks() {
        return this.alterClusterLinks;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterClusterLinksRequestData setAlterClusterLinks(List<AlterClusterLinkData> v) {
        this.alterClusterLinks = v;
        return this;
    }

    public AlterClusterLinksRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public static class AlterClusterLinkData
    implements Message {
        Uuid linkId;
        byte alterClusterLinkOp;
        byte switchoverType;
        long switchoverTimestamp;
        byte switchoverState;
        short errorCode;
        String errorMessage;
        long controlPlaneTimestamp;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("link_id", Type.UUID, "The ID of the link being altered."), new Field("alter_cluster_link_op", Type.INT8, "The operation being performed on the cluster link. "), Field.TaggedFieldsSection.of(0, new Field("switchover_type", Type.INT8, "The most recent type of switchover (failover, reverse, or restore) to update the metadata to, or EMPTY if it isn't being updated."), 1, new Field("switchover_timestamp", Type.INT64, "The timestamp of the most recent switchover, or -1 if it isn't being updated."), 2, new Field("switchover_state", Type.INT8, "Whether the switchover is currently the active, passive, or in progress of changing into one of those states, or EMPTY if it isn't being updated."), 3, new Field("error_code", Type.INT16, "Link-level error code for the switchover operation in the persisted metadata, or -1 if it isn't being updated."), 4, new Field("error_message", Type.COMPACT_STRING, "Link-level error message for the switchover operation in the persisted metadata, or 'unchanged' if it isn't being updated."), 5, new Field("control_plane_timestamp", Type.INT64, "The time when control plane receives the switchover info, or -1 if it isn't being updated.")));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public AlterClusterLinkData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public AlterClusterLinkData() {
            this.linkId = Uuid.ZERO_UUID;
            this.alterClusterLinkOp = 0;
            this.switchoverType = 0;
            this.switchoverTimestamp = 0L;
            this.switchoverState = 0;
            this.errorCode = 0;
            this.errorMessage = "";
            this.controlPlaneTimestamp = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterClusterLinkData");
            }
            this.linkId = _readable.readUuid();
            this.alterClusterLinkOp = _readable.readByte();
            this.switchoverType = 0;
            this.switchoverTimestamp = 0L;
            this.switchoverState = 0;
            this.errorCode = 0;
            this.errorMessage = "";
            this.controlPlaneTimestamp = 0L;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            block8: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        this.switchoverType = _readable.readByte();
                        continue block8;
                    }
                    case 1: {
                        this.switchoverTimestamp = _readable.readLong();
                        continue block8;
                    }
                    case 2: {
                        this.switchoverState = _readable.readByte();
                        continue block8;
                    }
                    case 3: {
                        this.errorCode = _readable.readShort();
                        continue block8;
                    }
                    case 4: {
                        int length = _readable.readUnsignedVarint() - 1;
                        if (length < 0) {
                            throw new RuntimeException("non-nullable field errorMessage was serialized as null");
                        }
                        if (length > Short.MAX_VALUE) {
                            throw new RuntimeException("string field errorMessage had invalid length " + length);
                        }
                        this.errorMessage = _readable.readString(length);
                        continue block8;
                    }
                    case 5: {
                        this.controlPlaneTimestamp = _readable.readLong();
                        continue block8;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.linkId);
            _writable.writeByte(this.alterClusterLinkOp);
            if (this.switchoverType != 0) {
                ++_numTaggedFields;
            }
            if (this.switchoverTimestamp != 0L) {
                ++_numTaggedFields;
            }
            if (this.switchoverState != 0) {
                ++_numTaggedFields;
            }
            if (this.errorCode != 0) {
                ++_numTaggedFields;
            }
            if (!this.errorMessage.equals("")) {
                ++_numTaggedFields;
            }
            if (this.controlPlaneTimestamp != 0L) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            if (this.switchoverType != 0) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.switchoverType);
            }
            if (this.switchoverTimestamp != 0L) {
                _writable.writeUnsignedVarint(1);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.switchoverTimestamp);
            }
            if (this.switchoverState != 0) {
                _writable.writeUnsignedVarint(2);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.switchoverState);
            }
            if (this.errorCode != 0) {
                _writable.writeUnsignedVarint(3);
                _writable.writeUnsignedVarint(2);
                _writable.writeShort(this.errorCode);
            }
            if (!this.errorMessage.equals("")) {
                _writable.writeUnsignedVarint(4);
                byte[] _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (this.controlPlaneTimestamp != 0L) {
                _writable.writeUnsignedVarint(5);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.controlPlaneTimestamp);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterClusterLinkData");
            }
            _size.addBytes(16);
            _size.addBytes(1);
            if (this.switchoverType != 0) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (this.switchoverTimestamp != 0L) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(8);
            }
            if (this.switchoverState != 0) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (this.errorCode != 0) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(2);
            }
            if (!this.errorMessage.equals("")) {
                ++_numTaggedFields;
                _size.addBytes(1);
                byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
                _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes.length));
            }
            if (this.controlPlaneTimestamp != 0L) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(8);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterClusterLinkData)) {
                return false;
            }
            AlterClusterLinkData other = (AlterClusterLinkData)obj;
            if (!this.linkId.equals(other.linkId)) {
                return false;
            }
            if (this.alterClusterLinkOp != other.alterClusterLinkOp) {
                return false;
            }
            if (this.switchoverType != other.switchoverType) {
                return false;
            }
            if (this.switchoverTimestamp != other.switchoverTimestamp) {
                return false;
            }
            if (this.switchoverState != other.switchoverState) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.controlPlaneTimestamp != other.controlPlaneTimestamp) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.linkId.hashCode();
            hashCode = 31 * hashCode + this.alterClusterLinkOp;
            hashCode = 31 * hashCode + this.switchoverType;
            hashCode = 31 * hashCode + ((int)(this.switchoverTimestamp >> 32) ^ (int)this.switchoverTimestamp);
            hashCode = 31 * hashCode + this.switchoverState;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + ((int)(this.controlPlaneTimestamp >> 32) ^ (int)this.controlPlaneTimestamp);
            return hashCode;
        }

        @Override
        public AlterClusterLinkData duplicate() {
            AlterClusterLinkData _duplicate = new AlterClusterLinkData();
            _duplicate.linkId = this.linkId;
            _duplicate.alterClusterLinkOp = this.alterClusterLinkOp;
            _duplicate.switchoverType = this.switchoverType;
            _duplicate.switchoverTimestamp = this.switchoverTimestamp;
            _duplicate.switchoverState = this.switchoverState;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage;
            _duplicate.controlPlaneTimestamp = this.controlPlaneTimestamp;
            return _duplicate;
        }

        public String toString() {
            return "AlterClusterLinkData(linkId=" + this.linkId.toString() + ", alterClusterLinkOp=" + this.alterClusterLinkOp + ", switchoverType=" + this.switchoverType + ", switchoverTimestamp=" + this.switchoverTimestamp + ", switchoverState=" + this.switchoverState + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", controlPlaneTimestamp=" + this.controlPlaneTimestamp + ")";
        }

        public Uuid linkId() {
            return this.linkId;
        }

        public byte alterClusterLinkOp() {
            return this.alterClusterLinkOp;
        }

        public byte switchoverType() {
            return this.switchoverType;
        }

        public long switchoverTimestamp() {
            return this.switchoverTimestamp;
        }

        public byte switchoverState() {
            return this.switchoverState;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public long controlPlaneTimestamp() {
            return this.controlPlaneTimestamp;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterClusterLinkData setLinkId(Uuid v) {
            this.linkId = v;
            return this;
        }

        public AlterClusterLinkData setAlterClusterLinkOp(byte v) {
            this.alterClusterLinkOp = v;
            return this;
        }

        public AlterClusterLinkData setSwitchoverType(byte v) {
            this.switchoverType = v;
            return this;
        }

        public AlterClusterLinkData setSwitchoverTimestamp(long v) {
            this.switchoverTimestamp = v;
            return this;
        }

        public AlterClusterLinkData setSwitchoverState(byte v) {
            this.switchoverState = v;
            return this;
        }

        public AlterClusterLinkData setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public AlterClusterLinkData setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public AlterClusterLinkData setControlPlaneTimestamp(long v) {
            this.controlPlaneTimestamp = v;
            return this;
        }
    }
}

