/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeNetworkRequestData
implements ApiMessage {
    String listenerName;
    String tenantId;
    List<String> ipAddresses;
    List<String> clientApiKeys;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("listener_name", Type.COMPACT_STRING, "Name of the listener to match (External/Internal) etc."), new Field("tenant_id", Type.COMPACT_STRING, "Id of the tenant to fetch the network information."), new Field("ip_addresses", new CompactArrayOf(Type.COMPACT_STRING), "Fetch the information for the given IP addresses"), new Field("client_api_keys", new CompactArrayOf(Type.COMPACT_STRING), "Fetch the information for the given client API key addresses"), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeNetworkRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeNetworkRequestData() {
        this.listenerName = "";
        this.tenantId = "";
        this.ipAddresses = new ArrayList<String>(0);
        this.clientApiKeys = new ArrayList<String>(0);
    }

    @Override
    public short apiKey() {
        return 10036;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int length;
        int i;
        int length2 = _readable.readUnsignedVarint() - 1;
        if (length2 < 0) {
            throw new RuntimeException("non-nullable field listenerName was serialized as null");
        }
        if (length2 > Short.MAX_VALUE) {
            throw new RuntimeException("string field listenerName had invalid length " + length2);
        }
        this.listenerName = _readable.readString(length2);
        length2 = _readable.readUnsignedVarint() - 1;
        if (length2 < 0) {
            throw new RuntimeException("non-nullable field tenantId was serialized as null");
        }
        if (length2 > Short.MAX_VALUE) {
            throw new RuntimeException("string field tenantId had invalid length " + length2);
        }
        this.tenantId = _readable.readString(length2);
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field ipAddresses was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field ipAddresses element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field ipAddresses element had invalid length " + length);
            }
            newCollection.add(_readable.readString(length));
        }
        this.ipAddresses = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field clientApiKeys was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientApiKeys element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientApiKeys element had invalid length " + length);
            }
            newCollection.add(_readable.readString(length));
        }
        this.clientApiKeys = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        Object _stringBytes2 = _cache.getSerializedValue(this.listenerName);
        _writable.writeUnsignedVarint(((byte[])_stringBytes2).length + 1);
        _writable.writeByteArray((byte[])_stringBytes2);
        _stringBytes2 = _cache.getSerializedValue(this.tenantId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes2).length + 1);
        _writable.writeByteArray((byte[])_stringBytes2);
        _writable.writeUnsignedVarint(this.ipAddresses.size() + 1);
        _stringBytes2 = this.ipAddresses.iterator();
        while (_stringBytes2.hasNext()) {
            String ipAddressesElement = (String)_stringBytes2.next();
            _stringBytes = _cache.getSerializedValue(ipAddressesElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeUnsignedVarint(this.clientApiKeys.size() + 1);
        for (String clientApiKeysElement : this.clientApiKeys) {
            _stringBytes = _cache.getSerializedValue(clientApiKeysElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        byte[] _stringBytes2 = this.listenerName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes2.length > Short.MAX_VALUE) {
            throw new RuntimeException("'listenerName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.listenerName, _stringBytes2);
        _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
        _stringBytes2 = this.tenantId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes2.length > Short.MAX_VALUE) {
            throw new RuntimeException("'tenantId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.tenantId, _stringBytes2);
        _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.ipAddresses.size() + 1));
        for (String ipAddressesElement : this.ipAddresses) {
            _stringBytes = ipAddressesElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'ipAddressesElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(ipAddressesElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.clientApiKeys.size() + 1));
        for (String clientApiKeysElement : this.clientApiKeys) {
            _stringBytes = clientApiKeysElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientApiKeysElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(clientApiKeysElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeNetworkRequestData)) {
            return false;
        }
        DescribeNetworkRequestData other = (DescribeNetworkRequestData)obj;
        if (this.listenerName == null ? other.listenerName != null : !this.listenerName.equals(other.listenerName)) {
            return false;
        }
        if (this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId)) {
            return false;
        }
        if (this.ipAddresses == null ? other.ipAddresses != null : !this.ipAddresses.equals(other.ipAddresses)) {
            return false;
        }
        if (this.clientApiKeys == null ? other.clientApiKeys != null : !this.clientApiKeys.equals(other.clientApiKeys)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.listenerName == null ? 0 : this.listenerName.hashCode());
        hashCode = 31 * hashCode + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        hashCode = 31 * hashCode + (this.ipAddresses == null ? 0 : this.ipAddresses.hashCode());
        hashCode = 31 * hashCode + (this.clientApiKeys == null ? 0 : this.clientApiKeys.hashCode());
        return hashCode;
    }

    @Override
    public DescribeNetworkRequestData duplicate() {
        DescribeNetworkRequestData _duplicate = new DescribeNetworkRequestData();
        _duplicate.listenerName = this.listenerName;
        _duplicate.tenantId = this.tenantId;
        ArrayList<String> newIpAddresses = new ArrayList<String>(this.ipAddresses.size());
        for (String _element : this.ipAddresses) {
            newIpAddresses.add(_element);
        }
        _duplicate.ipAddresses = newIpAddresses;
        ArrayList<String> newClientApiKeys = new ArrayList<String>(this.clientApiKeys.size());
        for (String _element : this.clientApiKeys) {
            newClientApiKeys.add(_element);
        }
        _duplicate.clientApiKeys = newClientApiKeys;
        return _duplicate;
    }

    public String toString() {
        return "DescribeNetworkRequestData(listenerName=" + (String)(this.listenerName == null ? "null" : "'" + this.listenerName.toString() + "'") + ", tenantId=" + (String)(this.tenantId == null ? "null" : "'" + this.tenantId.toString() + "'") + ", ipAddresses=" + MessageUtil.deepToString(this.ipAddresses.iterator()) + ", clientApiKeys=" + MessageUtil.deepToString(this.clientApiKeys.iterator()) + ")";
    }

    public String listenerName() {
        return this.listenerName;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public List<String> ipAddresses() {
        return this.ipAddresses;
    }

    public List<String> clientApiKeys() {
        return this.clientApiKeys;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeNetworkRequestData setListenerName(String v) {
        this.listenerName = v;
        return this;
    }

    public DescribeNetworkRequestData setTenantId(String v) {
        this.tenantId = v;
        return this;
    }

    public DescribeNetworkRequestData setIpAddresses(List<String> v) {
        this.ipAddresses = v;
        return this;
    }

    public DescribeNetworkRequestData setClientApiKeys(List<String> v) {
        this.clientApiKeys = v;
        return this;
    }
}

