/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.message.ReplicaStatusRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class ReplicaStatusRequestDataJsonConverter {
    public static ReplicaStatusRequestData read(JsonNode _node, short _version) {
        ReplicaStatusRequestData _object = new ReplicaStatusRequestData();
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("ReplicaStatusRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("ReplicaStatusRequestData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<ReplicaStatusRequestData.ReplicaStatusTopic> _collection = new ArrayList<ReplicaStatusRequestData.ReplicaStatusTopic>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(ReplicaStatusTopicJsonConverter.read(_element, _version));
        }
        JsonNode _includeLinkedReplicasNode = _node.get("includeLinkedReplicas");
        if (_includeLinkedReplicasNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("ReplicaStatusRequestData: unable to locate field 'includeLinkedReplicas', which is mandatory in version " + _version);
            }
            _object.includeLinkedReplicas = false;
        } else {
            if (!_includeLinkedReplicasNode.isBoolean()) {
                throw new RuntimeException("ReplicaStatusRequestData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.includeLinkedReplicas = _includeLinkedReplicasNode.asBoolean();
        }
        return _object;
    }

    public static JsonNode write(ReplicaStatusRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ReplicaStatusRequestData.ReplicaStatusTopic _element : _object.topics) {
            _topicsArray.add(ReplicaStatusTopicJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        if (_version >= 1) {
            _node.set("includeLinkedReplicas", (JsonNode)BooleanNode.valueOf((boolean)_object.includeLinkedReplicas));
        }
        return _node;
    }

    public static JsonNode write(ReplicaStatusRequestData _object, short _version) {
        return ReplicaStatusRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class ReplicaStatusTopicJsonConverter {
        public static ReplicaStatusRequestData.ReplicaStatusTopic read(JsonNode _node, short _version) {
            ReplicaStatusRequestData.ReplicaStatusTopic _object = new ReplicaStatusRequestData.ReplicaStatusTopic();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("ReplicaStatusTopic: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("ReplicaStatusTopic expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.name = _nameNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("ReplicaStatusTopic: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("ReplicaStatusTopic expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(MessageUtil.jsonNodeToInt(_element, "ReplicaStatusTopic element"));
            }
            return _object;
        }

        public static JsonNode write(ReplicaStatusRequestData.ReplicaStatusTopic _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.partitions) {
                _partitionsArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(ReplicaStatusRequestData.ReplicaStatusTopic _object, short _version) {
            return ReplicaStatusTopicJsonConverter.write(_object, _version, true);
        }
    }
}

