/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import java.util.function.BiFunction;
import org.apache.kafka.common.network.netty.AbstractConnectionInitializer;
import org.apache.kafka.common.network.netty.NettyRawBytesStream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.utils.LogContext;

public class NettyRawBytesConnectionInitializer
extends AbstractConnectionInitializer<Channel> {
    private final BiFunction<NettyStream, Http2Headers, NettyStream.StreamHandler> handlerCreator;
    private final SslContext sslContext;
    private final LogContext logContext;
    private final boolean addLoggingHandler;
    private final boolean flowControlEnabled;

    public NettyRawBytesConnectionInitializer(ChannelGroup trackedChannels, SslContext sslContext, BiFunction<NettyStream, Http2Headers, NettyStream.StreamHandler> handlerCreator, LogContext logContext, boolean addLoggingHandler, boolean flowControlEnabled) {
        super(trackedChannels);
        if (handlerCreator == null) {
            throw new IllegalArgumentException("Handler creator cannot be null.");
        }
        this.handlerCreator = handlerCreator;
        this.sslContext = sslContext;
        this.logContext = logContext;
        this.addLoggingHandler = addLoggingHandler;
        this.flowControlEnabled = flowControlEnabled;
    }

    public void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.sslContext != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslContext.newHandler(channel.alloc())});
        }
        if (this.addLoggingHandler) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO)});
        }
        NettyRawBytesStream nettyRawBytesStream = new NettyRawBytesStream(channel, 8192, 8192, this.logContext, this.flowControlEnabled);
        NettyRawBytesStream.NettyRawBytesStreamHandler pipelineHandler = new NettyRawBytesStream.NettyRawBytesStreamHandler(nettyRawBytesStream, this.logContext);
        nettyRawBytesStream.setAbstractStreamHandler(pipelineHandler);
        NettyStream.StreamHandler streamHandler = this.handlerCreator.apply(nettyRawBytesStream, null);
        if (pipelineHandler.streamHandler() == null) {
            pipelineHandler.streamHandler(streamHandler);
        }
        channel.pipeline().addLast(new ChannelHandler[]{pipelineHandler});
        this.trackedChannels.add((Object)channel);
    }
}

