/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorTopicsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class AlterMirrorTopicsResponse
extends AbstractResponse {
    private final AlterMirrorTopicsResponseData data;

    public AlterMirrorTopicsResponse(AlterMirrorTopicsResponseData data) {
        super(ApiKeys.ALTER_MIRROR_TOPICS);
        this.data = data;
    }

    @Override
    public AlterMirrorTopicsResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errors = new HashMap<Errors, Integer>();
        errors.put(Errors.forCode(this.data.errorCode()), 1);
        this.data.alterMirrorResults().forEach(alterMirrorResult -> errors.compute(Errors.forCode(this.data.errorCode()), (k, v) -> v == null ? 1 : v + 1));
        return errors;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static AlterMirrorTopicsResponse parse(Readable readable, short version, MessageContext context) {
        return new AlterMirrorTopicsResponse(new AlterMirrorTopicsResponseData(readable, version, context));
    }

    public void complete(Map<String, KafkaFutureImpl<Void>> futures) {
        Iterator<KafkaFutureImpl<Void>> iterator = futures.values().iterator();
        for (AlterMirrorTopicsResponseData.AlterMirrorResult result : this.data.alterMirrorResults()) {
            Errors error = Errors.forCode(result.errorCode());
            KafkaFutureImpl<Void> future = iterator.next();
            if (error != Errors.NONE) {
                future.completeExceptionally(error.exception(result.errorMessage()));
                continue;
            }
            future.complete(null);
        }
    }
}

