/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.ApiError;

public class AlterPartitionReassignmentsRequest
extends AbstractRequest {
    private final AlterPartitionReassignmentsRequestData data;

    private AlterPartitionReassignmentsRequest(AlterPartitionReassignmentsRequestData data, short version) {
        super(ApiKeys.ALTER_PARTITION_REASSIGNMENTS, version);
        this.data = data;
    }

    public static AlterPartitionReassignmentsRequest parse(Readable readable, short version, MessageContext context) {
        return new AlterPartitionReassignmentsRequest(new AlterPartitionReassignmentsRequestData(readable, version, context), version);
    }

    @Override
    public AlterPartitionReassignmentsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        ArrayList<AlterPartitionReassignmentsResponseData.ReassignableTopicResponse> topicResponses = new ArrayList<AlterPartitionReassignmentsResponseData.ReassignableTopicResponse>();
        for (AlterPartitionReassignmentsRequestData.ReassignableTopic topic : this.data.topics()) {
            List<AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse> partitionResponses = topic.partitions().stream().map(partition -> new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(partition.partitionIndex()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message())).collect(Collectors.toList());
            topicResponses.add(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName(topic.name()).setPartitions(partitionResponses));
        }
        AlterPartitionReassignmentsResponseData responseData = new AlterPartitionReassignmentsResponseData().setResponses(topicResponses).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs);
        return new AlterPartitionReassignmentsResponse(responseData);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterPartitionReassignmentsRequest> {
        private final AlterPartitionReassignmentsRequestData data;

        public Builder(AlterPartitionReassignmentsRequestData data) {
            super(ApiKeys.ALTER_PARTITION_REASSIGNMENTS);
            this.data = data;
        }

        @Override
        public AlterPartitionReassignmentsRequest build(short version) {
            if (!this.data.allowReplicationFactorChange() && version < 1) {
                throw new UnsupportedVersionException("The broker does not support the AllowReplicationFactorChange option for the AlterPartitionReassignments API. Consider re-sending the request without the option or updating the server version");
            }
            return new AlterPartitionReassignmentsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

