/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.DeleteCellRequestData;
import org.apache.kafka.common.message.DeleteCellResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DeleteCellResponse;

public class DeleteCellRequest
extends AbstractRequest {
    private final DeleteCellRequestData data;

    DeleteCellRequest(DeleteCellRequestData data, short version) {
        super(ApiKeys.DELETE_CELL, version);
        this.data = data;
    }

    @Override
    public DeleteCellRequestData data() {
        return this.data;
    }

    public int cellId() {
        return this.data.cellId();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t) {
        ApiError err = ApiError.fromThrowable(t);
        return new DeleteCellResponse(new DeleteCellResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(err.error().code()).setErrorMessage(err.message()));
    }

    public static DeleteCellRequest parse(Readable readable, short version, MessageContext context) {
        return new DeleteCellRequest(new DeleteCellRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteCellRequest> {
        private final DeleteCellRequestData data;

        public Builder() {
            super(ApiKeys.DELETE_CELL);
            this.data = new DeleteCellRequestData();
        }

        public Builder(DeleteCellRequestData data) {
            super(ApiKeys.DELETE_CELL);
            this.data = data;
        }

        public Builder setCellId(int id) {
            this.data.setCellId(id);
            return this;
        }

        @Override
        public DeleteCellRequest build(short version) {
            return new DeleteCellRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

