/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class DeleteRecordsResponse
extends AbstractResponse {
    public static final long INVALID_LOW_WATERMARK = -1L;
    private final DeleteRecordsResponseData data;

    public DeleteRecordsResponse(DeleteRecordsResponseData data) {
        super(ApiKeys.DELETE_RECORDS);
        this.data = data;
    }

    @Override
    public DeleteRecordsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> errorCounts = new EnumMap<Errors, Integer>(Errors.class);
        this.data.topics().forEach(topicResponses -> topicResponses.partitions().forEach(response -> DeleteRecordsResponse.updateErrorCounts(errorCounts, Errors.forCode(response.errorCode()))));
        return errorCounts;
    }

    public static DeleteRecordsResponse parse(Readable readable, short version, MessageContext context) {
        return new DeleteRecordsResponse(new DeleteRecordsResponseData(readable, version, context));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

