/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.Replicas;

public final class TopicsDelta {
    private final TopicsImage image;
    private final Map<Uuid, TopicDelta> changedTopics = new HashMap<Uuid, TopicDelta>();
    private final Set<Uuid> deletedTopicIds = new HashSet<Uuid>();

    public TopicsDelta(TopicsImage image) {
        this.image = image;
    }

    public TopicsImage image() {
        return this.image;
    }

    public Map<Uuid, TopicDelta> changedTopics() {
        return this.changedTopics;
    }

    public void replay(TopicRecord record) {
        TopicDelta delta = new TopicDelta(new TopicImage(record.name(), record.topicId(), Collections.emptyMap()));
        this.changedTopics.put(record.topicId(), delta);
    }

    TopicDelta getOrCreateTopicDelta(Uuid id) {
        TopicDelta topicDelta = this.changedTopics.get(id);
        if (topicDelta == null) {
            topicDelta = new TopicDelta(this.image.getTopic(id));
            this.changedTopics.put(id, topicDelta);
        }
        return topicDelta;
    }

    public void replay(PartitionRecord record) {
        TopicDelta topicDelta = this.getOrCreateTopicDelta(record.topicId());
        topicDelta.replay(record);
    }

    public void replay(PartitionChangeRecord record) {
        TopicDelta topicDelta = this.getOrCreateTopicDelta(record.topicId());
        topicDelta.replay(record);
    }

    public String replay(RemoveTopicRecord record) {
        String topicName;
        TopicDelta topicDelta = this.changedTopics.remove(record.topicId());
        if (topicDelta != null) {
            topicName = topicDelta.image().name();
            if (this.image.topicsById().containsKey(record.topicId())) {
                this.deletedTopicIds.add(record.topicId());
            }
        } else {
            TopicImage topicImage = this.image.getTopic(record.topicId());
            if (topicImage == null) {
                throw new RuntimeException("Unable to delete topic with id " + record.topicId() + ": no such topic found.");
            }
            topicName = topicImage.name();
            this.deletedTopicIds.add(record.topicId());
        }
        return topicName;
    }

    public void finishSnapshot() {
        for (Uuid topicId : this.image.topicsById().keySet()) {
            if (this.changedTopics.containsKey(topicId)) continue;
            this.deletedTopicIds.add(topicId);
        }
    }

    public TopicsImage apply() {
        HashMap<Uuid, TopicImage> newTopicsById = new HashMap<Uuid, TopicImage>(this.image.topicsById().size());
        HashMap<String, TopicImage> newTopicsByName = new HashMap<String, TopicImage>(this.image.topicsByName().size());
        for (Map.Entry<Uuid, TopicImage> entry : this.image.topicsById().entrySet()) {
            Uuid id = entry.getKey();
            TopicImage prevTopicImage = entry.getValue();
            TopicDelta delta = this.changedTopics.get(id);
            if (delta == null) {
                if (this.deletedTopicIds.contains(id)) continue;
                newTopicsById.put(id, prevTopicImage);
                newTopicsByName.put(prevTopicImage.name(), prevTopicImage);
                continue;
            }
            TopicImage newTopicImage = delta.apply();
            newTopicsById.put(id, newTopicImage);
            newTopicsByName.put(delta.name(), newTopicImage);
        }
        for (Map.Entry<Uuid, Object> entry : this.changedTopics.entrySet()) {
            if (newTopicsById.containsKey(entry.getKey())) continue;
            TopicImage newTopicImage = ((TopicDelta)entry.getValue()).apply();
            newTopicsById.put(newTopicImage.id(), newTopicImage);
            newTopicsByName.put(newTopicImage.name(), newTopicImage);
        }
        return new TopicsImage(newTopicsById, newTopicsByName);
    }

    public TopicDelta changedTopic(Uuid topicId) {
        return this.changedTopics.get(topicId);
    }

    public boolean topicWasDeleted(String topicName) {
        TopicImage topicImage = this.image.getTopic(topicName);
        if (topicImage == null) {
            return false;
        }
        return this.deletedTopicIds.contains(topicImage.id());
    }

    public Set<Uuid> deletedTopicIds() {
        return this.deletedTopicIds;
    }

    public LocalReplicaChanges localChanges(int brokerId) {
        HashSet<TopicPartition> deletes = new HashSet<TopicPartition>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> leaders = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> followers = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        for (TopicDelta delta : this.changedTopics.values()) {
            LocalReplicaChanges changes = delta.localChanges(brokerId);
            deletes.addAll(changes.deletes());
            leaders.putAll(changes.leaders());
            followers.putAll(changes.followers());
        }
        this.deletedTopicIds().forEach(topicId -> {
            TopicImage topicImage = this.image().getTopic((Uuid)topicId);
            topicImage.partitions().forEach((partitionId, prevPartition) -> {
                if (Replicas.contains(prevPartition.replicas, brokerId)) {
                    deletes.add(new TopicPartition(topicImage.name(), partitionId.intValue()));
                }
            });
        });
        return new LocalReplicaChanges(deletes, leaders, followers);
    }
}

