/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Objects;

public class VersionRange {
    public static final VersionRange ALL = new VersionRange(0, Short.MAX_VALUE);
    private final short min;
    private final short max;

    public VersionRange(short min, short max) {
        this.min = min;
        this.max = max;
    }

    public short min() {
        return this.min;
    }

    public short max() {
        return this.max;
    }

    public boolean contains(VersionRange other) {
        return other.min >= this.min && other.max <= this.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public boolean equals(Object o) {
        if (!(o instanceof VersionRange)) {
            return false;
        }
        VersionRange other = (VersionRange)o;
        return other.min == this.min && other.max == this.max;
    }

    public String toString() {
        if (this.min == this.max) {
            return String.valueOf(this.min);
        }
        if (this.max == Short.MAX_VALUE) {
            return String.valueOf(this.min) + "+";
        }
        return String.valueOf(this.min) + "-" + String.valueOf(this.max);
    }
}

