/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class TopicsImage {
    public static final TopicsImage EMPTY = new TopicsImage(Collections.emptyMap(), Collections.emptyMap());
    private final Map<Uuid, TopicImage> topicsById;
    private final Map<String, TopicImage> topicsByName;

    public TopicsImage(Map<Uuid, TopicImage> topicsById, Map<String, TopicImage> topicsByName) {
        this.topicsById = Collections.unmodifiableMap(topicsById);
        this.topicsByName = Collections.unmodifiableMap(topicsByName);
    }

    public boolean isEmpty() {
        return this.topicsById.isEmpty() && this.topicsByName.isEmpty();
    }

    public Map<Uuid, TopicImage> topicsById() {
        return this.topicsById;
    }

    public Map<String, TopicImage> topicsByName() {
        return this.topicsByName;
    }

    public PartitionRegistration getPartition(Uuid id, int partitionId) {
        TopicImage topicImage = this.topicsById.get(id);
        if (topicImage == null) {
            return null;
        }
        return topicImage.partitions().get(partitionId);
    }

    public TopicImage getTopic(Uuid id) {
        return this.topicsById.get(id);
    }

    public TopicImage getTopic(String name) {
        return this.topicsByName.get(name);
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out) {
        for (TopicImage topicImage : this.topicsById.values()) {
            topicImage.write(out);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof TopicsImage)) {
            return false;
        }
        TopicsImage other = (TopicsImage)o;
        return this.topicsById.equals(other.topicsById) && this.topicsByName.equals(other.topicsByName);
    }

    public int hashCode() {
        return Objects.hash(this.topicsById, this.topicsByName);
    }

    public String toString() {
        return "TopicsImage(topicsById=" + this.topicsById.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", ")) + ", topicsByName=" + this.topicsByName.entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", ")) + ")";
    }
}

