/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.timeline.BaseHashTable;
import org.apache.kafka.timeline.Delta;
import org.apache.kafka.timeline.Revertable;
import org.apache.kafka.timeline.Snapshot;
import org.apache.kafka.timeline.SnapshotRegistry;

class SnapshottableHashTable<T extends ElementWithStartEpoch>
extends BaseHashTable<T>
implements Revertable {
    static final long LATEST_EPOCH = Long.MAX_VALUE;
    private final SnapshotRegistry snapshotRegistry;

    SnapshottableHashTable(SnapshotRegistry snapshotRegistry, int expectedSize) {
        super(expectedSize);
        this.snapshotRegistry = snapshotRegistry;
        snapshotRegistry.register(this);
    }

    int snapshottableSize(long epoch) {
        if (epoch == Long.MAX_VALUE) {
            return this.baseSize();
        }
        Iterator<Snapshot> iterator = this.snapshotRegistry.iterator(epoch);
        while (iterator.hasNext()) {
            Snapshot snapshot = iterator.next();
            HashTier tier = (HashTier)snapshot.getDelta(this);
            if (tier == null) continue;
            return tier.size;
        }
        return this.baseSize();
    }

    T snapshottableGet(Object key, long epoch) {
        ElementWithStartEpoch result = (ElementWithStartEpoch)this.baseGet(key);
        if (result != null && result.startEpoch() <= epoch) {
            return (T)result;
        }
        if (epoch == Long.MAX_VALUE) {
            return null;
        }
        Iterator<Snapshot> iterator = this.snapshotRegistry.iterator(epoch);
        while (iterator.hasNext()) {
            Snapshot snapshot = iterator.next();
            HashTier tier = (HashTier)snapshot.getDelta(this);
            if (tier == null || tier.deltaTable == null || (result = (ElementWithStartEpoch)tier.deltaTable.baseGet(key)) == null) continue;
            if (result.startEpoch() <= epoch) {
                return (T)result;
            }
            return null;
        }
        return null;
    }

    boolean snapshottableAddUnlessPresent(T object) {
        ElementWithStartEpoch prev = (ElementWithStartEpoch)this.baseGet(object);
        if (prev != null) {
            return false;
        }
        object.setStartEpoch(this.snapshotRegistry.latestEpoch() + 1L);
        int prevSize = this.baseSize();
        this.baseAddOrReplace(object);
        this.updateTierData(prevSize);
        return true;
    }

    T snapshottableAddOrReplace(T object) {
        object.setStartEpoch(this.snapshotRegistry.latestEpoch() + 1L);
        int prevSize = this.baseSize();
        ElementWithStartEpoch prev = (ElementWithStartEpoch)this.baseAddOrReplace(object);
        if (prev == null) {
            this.updateTierData(prevSize);
        } else {
            this.updateTierData(prev, prevSize);
        }
        return (T)prev;
    }

    T snapshottableRemove(Object object) {
        ElementWithStartEpoch prev = (ElementWithStartEpoch)this.baseRemove(object);
        if (prev == null) {
            return null;
        }
        this.updateTierData(prev, this.baseSize() + 1);
        return (T)prev;
    }

    private void updateTierData(int prevSize) {
        Snapshot snapshot;
        HashTier tier;
        Iterator<Snapshot> iterator = this.snapshotRegistry.reverseIterator();
        if (iterator.hasNext() && (tier = (HashTier)(snapshot = iterator.next()).getDelta(this)) == null) {
            tier = new HashTier(prevSize);
            snapshot.setDelta(this, tier);
        }
    }

    private void updateTierData(T prev, int prevSize) {
        Iterator<Snapshot> iterator = this.snapshotRegistry.reverseIterator();
        if (iterator.hasNext()) {
            Snapshot snapshot = iterator.next();
            if (prev.startEpoch() <= snapshot.epoch()) {
                HashTier tier = (HashTier)snapshot.getDelta(this);
                if (tier == null) {
                    tier = new HashTier(prevSize);
                    snapshot.setDelta(this, tier);
                }
                if (tier.deltaTable == null) {
                    tier.deltaTable = new BaseHashTable(1);
                }
                tier.deltaTable.baseAddOrReplace(prev);
            }
        }
    }

    Iterator<T> snapshottableIterator(long epoch) {
        if (epoch == Long.MAX_VALUE) {
            return new CurrentIterator(this.baseElements());
        }
        return new HistoricalIterator(this.baseElements(), this.snapshotRegistry.getSnapshot(epoch));
    }

    String snapshottableToDebugString() {
        StringBuilder bld = new StringBuilder();
        bld.append(String.format("SnapshottableHashTable{%n", new Object[0]));
        bld.append("top tier: ");
        bld.append(this.baseToDebugString());
        bld.append(String.format(",%nsnapshot tiers: [%n", new Object[0]));
        String prefix = "";
        Iterator<Snapshot> iter = this.snapshotRegistry.iterator();
        while (iter.hasNext()) {
            Snapshot snapshot = iter.next();
            bld.append(prefix);
            bld.append("epoch ").append(snapshot.epoch()).append(": ");
            HashTier tier = (HashTier)snapshot.getDelta(this);
            if (tier == null) {
                bld.append("null");
            } else {
                bld.append("HashTier{");
                bld.append("size=").append(tier.size);
                bld.append(", deltaTable=");
                if (tier.deltaTable == null) {
                    bld.append("null");
                } else {
                    bld.append(tier.deltaTable.baseToDebugString());
                }
                bld.append("}");
            }
            bld.append(String.format("%n", new Object[0]));
        }
        bld.append(String.format("]}%n", new Object[0]));
        return bld.toString();
    }

    @Override
    public void executeRevert(long targetEpoch, Delta delta) {
        HashTier tier = (HashTier)delta;
        Iterator<T> iter = this.snapshottableIterator(Long.MAX_VALUE);
        while (iter.hasNext()) {
            ElementWithStartEpoch element = (ElementWithStartEpoch)iter.next();
            if (element.startEpoch() <= targetEpoch) continue;
            iter.remove();
        }
        BaseHashTable deltaTable = tier.deltaTable;
        if (deltaTable != null) {
            ArrayList out = new ArrayList();
            for (int i = 0; i < deltaTable.baseElements().length; ++i) {
                BaseHashTable.unpackSlot(out, deltaTable.baseElements(), i);
                for (ElementWithStartEpoch value : out) {
                    this.baseAddOrReplace(value);
                }
                out.clear();
            }
        }
    }

    @Override
    public void reset() {
        Iterator<T> iter = this.snapshottableIterator(Long.MAX_VALUE);
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    class HistoricalIterator
    implements Iterator<T> {
        private final Object[] topTier;
        private final Snapshot snapshot;
        private final List<T> temp;
        private final List<T> ready;
        private int slot;

        HistoricalIterator(Object[] topTier, Snapshot snapshot) {
            this.topTier = topTier;
            this.snapshot = snapshot;
            this.temp = new ArrayList();
            this.ready = new ArrayList();
            this.slot = 0;
        }

        @Override
        public boolean hasNext() {
            while (this.ready.isEmpty()) {
                if (this.slot == this.topTier.length) {
                    return false;
                }
                BaseHashTable.unpackSlot(this.temp, this.topTier, this.slot);
                for (ElementWithStartEpoch object : this.temp) {
                    if (object.startEpoch() > this.snapshot.epoch()) continue;
                    this.ready.add(object);
                }
                this.temp.clear();
                Iterator<Snapshot> iterator = SnapshottableHashTable.this.snapshotRegistry.iterator(this.snapshot);
                while (iterator.hasNext()) {
                    Snapshot curSnapshot = iterator.next();
                    HashTier tier = (HashTier)curSnapshot.getDelta(SnapshottableHashTable.this);
                    if (tier == null || tier.deltaTable == null) continue;
                    BaseHashTable deltaTable = tier.deltaTable;
                    int shift = Integer.numberOfLeadingZeros(deltaTable.baseElements().length) - Integer.numberOfLeadingZeros(this.topTier.length);
                    int tierSlot = this.slot >>> shift;
                    BaseHashTable.unpackSlot(this.temp, deltaTable.baseElements(), tierSlot);
                    for (ElementWithStartEpoch object : this.temp) {
                        if (BaseHashTable.findSlot(object, this.topTier.length) != this.slot) continue;
                        this.ready.add(object);
                    }
                    this.temp.clear();
                }
                ++this.slot;
            }
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (ElementWithStartEpoch)this.ready.remove(this.ready.size() - 1);
        }
    }

    class CurrentIterator
    implements Iterator<T> {
        private final Object[] topTier;
        private final List<T> ready;
        private int slot;
        private T lastReturned;

        CurrentIterator(Object[] topTier) {
            this.topTier = topTier;
            this.ready = new ArrayList();
            this.slot = 0;
            this.lastReturned = null;
        }

        @Override
        public boolean hasNext() {
            while (this.ready.isEmpty()) {
                if (this.slot == this.topTier.length) {
                    return false;
                }
                BaseHashTable.unpackSlot(this.ready, this.topTier, this.slot);
                ++this.slot;
            }
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = (ElementWithStartEpoch)this.ready.remove(this.ready.size() - 1);
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new UnsupportedOperationException("remove");
            }
            SnapshottableHashTable.this.snapshottableRemove(this.lastReturned);
            this.lastReturned = null;
        }
    }

    static class HashTier<T extends ElementWithStartEpoch>
    implements Delta {
        private final int size;
        private BaseHashTable<T> deltaTable;

        HashTier(int size) {
            this.size = size;
        }

        @Override
        public void mergeFrom(long epoch, Delta source) {
            HashTier other = (HashTier)source;
            ArrayList list = new ArrayList();
            Object[] otherElements = other.deltaTable.baseElements();
            for (int slot = 0; slot < otherElements.length; ++slot) {
                BaseHashTable.unpackSlot(list, otherElements, slot);
                for (ElementWithStartEpoch element : list) {
                    if (element.startEpoch() > epoch) continue;
                    this.deltaTable.baseAddOrReplace(element);
                }
            }
        }
    }

    static interface ElementWithStartEpoch {
        public void setStartEpoch(long var1);

        public long startEpoch();
    }
}

