/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class MetadataImage {
    public static final MetadataImage EMPTY = new MetadataImage(new OffsetAndEpoch(0L, 0), FeaturesImage.EMPTY, ClusterImage.EMPTY, TopicsImage.EMPTY, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY);
    private final OffsetAndEpoch highestOffsetAndEpoch;
    private final FeaturesImage features;
    private final ClusterImage cluster;
    private final TopicsImage topics;
    private final ConfigurationsImage configs;
    private final ClientQuotasImage clientQuotas;
    private final ProducerIdsImage producerIds;
    private final AclsImage acls;

    public MetadataImage(OffsetAndEpoch highestOffsetAndEpoch, FeaturesImage features, ClusterImage cluster, TopicsImage topics, ConfigurationsImage configs, ClientQuotasImage clientQuotas, ProducerIdsImage producerIds, AclsImage acls) {
        this.highestOffsetAndEpoch = highestOffsetAndEpoch;
        this.features = features;
        this.cluster = cluster;
        this.topics = topics;
        this.configs = configs;
        this.clientQuotas = clientQuotas;
        this.producerIds = producerIds;
        this.acls = acls;
    }

    public boolean isEmpty() {
        return this.features.isEmpty() && this.cluster.isEmpty() && this.topics.isEmpty() && this.configs.isEmpty() && this.clientQuotas.isEmpty() && this.producerIds.isEmpty() && this.acls.isEmpty();
    }

    public OffsetAndEpoch highestOffsetAndEpoch() {
        return this.highestOffsetAndEpoch;
    }

    public FeaturesImage features() {
        return this.features;
    }

    public ClusterImage cluster() {
        return this.cluster;
    }

    public TopicsImage topics() {
        return this.topics;
    }

    public ConfigurationsImage configs() {
        return this.configs;
    }

    public ClientQuotasImage clientQuotas() {
        return this.clientQuotas;
    }

    public ProducerIdsImage producerIds() {
        return this.producerIds;
    }

    public AclsImage acls() {
        return this.acls;
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out) {
        this.features.write(out);
        this.cluster.write(out);
        this.topics.write(out);
        this.configs.write(out);
        this.clientQuotas.write(out);
        this.producerIds.write(out);
        this.acls.write(out);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MetadataImage)) {
            return false;
        }
        MetadataImage other = (MetadataImage)o;
        return this.highestOffsetAndEpoch.equals((Object)other.highestOffsetAndEpoch) && this.features.equals(other.features) && this.cluster.equals(other.cluster) && this.topics.equals(other.topics) && this.configs.equals(other.configs) && this.clientQuotas.equals(other.clientQuotas) && this.producerIds.equals(other.producerIds) && this.acls.equals(other.acls);
    }

    public int hashCode() {
        return Objects.hash(this.highestOffsetAndEpoch, this.features, this.cluster, this.topics, this.configs, this.clientQuotas, this.producerIds, this.acls);
    }

    public String toString() {
        return "MetadataImage(highestOffsetAndEpoch=" + this.highestOffsetAndEpoch + ", features=" + this.features + ", cluster=" + this.cluster + ", topics=" + this.topics + ", configs=" + this.configs + ", clientQuotas=" + this.clientQuotas + ", producerIdsImage=" + this.producerIds + ", acls=" + this.acls + ")";
    }
}

