/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclRecordIterator;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineHashSet;

public class AclControlManager {
    private final TimelineHashMap<Uuid, ConfluentStandardAcl> idToAcl;
    private final TimelineHashSet<ConfluentStandardAcl> existingAcls;
    private final Optional<ClusterMetadataAuthorizer> authorizer;

    AclControlManager(SnapshotRegistry snapshotRegistry, Optional<ClusterMetadataAuthorizer> authorizer) {
        this.idToAcl = new TimelineHashMap(snapshotRegistry, 0);
        this.existingAcls = new TimelineHashSet(snapshotRegistry, 0);
        this.authorizer = authorizer;
    }

    ControllerResult<List<AclCreateResult>> createAcls(List<AclBinding> acls) {
        ArrayList<AclCreateResult> results = new ArrayList<AclCreateResult>(acls.size());
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>(acls.size());
        for (AclBinding acl : acls) {
            try {
                AclControlManager.validateNewAcl(acl);
            }
            catch (Throwable t) {
                ApiException e = t instanceof ApiException ? (ApiException)t : new UnknownServerException("Unknown error while trying to create ACL", t);
                results.add(new AclCreateResult(e));
                continue;
            }
            List<ConfluentStandardAcl> confluentStandardAclList = ConfluentStandardAcl.fromAclBinding(acl);
            for (ConfluentStandardAcl confluentStandardAcl : confluentStandardAclList) {
                if (!this.existingAcls.add(confluentStandardAcl)) continue;
                StandardAclWithId standardAclWithId = new StandardAclWithId(this.newAclId(), confluentStandardAcl);
                this.idToAcl.put(standardAclWithId.id(), confluentStandardAcl);
                records.add(new ApiMessageAndVersion((ApiMessage)standardAclWithId.toRecord(), 0));
            }
            results.add(AclCreateResult.SUCCESS);
        }
        return new ControllerResult<List<AclCreateResult>>(records, results, true);
    }

    Uuid newAclId() {
        Uuid uuid;
        while (this.idToAcl.containsKey(uuid = Uuid.randomUuid())) {
        }
        return uuid;
    }

    static void validateNewAcl(AclBinding binding) {
        switch (binding.pattern().resourceType()) {
            case UNKNOWN: 
            case ANY: {
                throw new InvalidRequestException("Invalid resourceType " + binding.pattern().resourceType());
            }
        }
        switch (binding.pattern().patternType()) {
            case LITERAL: 
            case PREFIXED: {
                break;
            }
            default: {
                throw new InvalidRequestException("Invalid patternType " + binding.pattern().patternType());
            }
        }
        switch (binding.entry().operation()) {
            case UNKNOWN: 
            case ANY: {
                throw new InvalidRequestException("Invalid operation " + binding.entry().operation());
            }
        }
        switch (binding.entry().permissionType()) {
            case DENY: 
            case ALLOW: {
                break;
            }
            default: {
                throw new InvalidRequestException("Invalid permissionType " + binding.entry().permissionType());
            }
        }
    }

    ControllerResult<List<AclDeleteResult>> deleteAcls(List<AclBindingFilter> filters) {
        ArrayList<AclDeleteResult> results = new ArrayList<AclDeleteResult>();
        HashSet<ApiMessageAndVersion> records = new HashSet<ApiMessageAndVersion>();
        for (AclBindingFilter filter : filters) {
            try {
                AclControlManager.validateFilter(filter);
                AclDeleteResult result = this.deleteAclsForFilter(filter, records);
                results.add(result);
            }
            catch (Throwable e) {
                results.add(new AclDeleteResult(ApiError.fromThrowable((Throwable)e).exception()));
            }
        }
        return ControllerResult.atomicOf(records.stream().collect(Collectors.toList()), results);
    }

    AclDeleteResult deleteAclsForFilter(AclBindingFilter filter, Set<ApiMessageAndVersion> records) {
        ArrayList<AclDeleteResult.AclBindingDeleteResult> deleted = new ArrayList<AclDeleteResult.AclBindingDeleteResult>();
        for (Map.Entry<Uuid, ConfluentStandardAcl> entry : this.idToAcl.entrySet()) {
            Uuid id = entry.getKey();
            ConfluentStandardAcl acl = entry.getValue();
            AclBinding binding = acl.toBinding();
            if (!filter.matches(binding)) continue;
            deleted.add(new AclDeleteResult.AclBindingDeleteResult(binding));
            records.add(new ApiMessageAndVersion((ApiMessage)new RemoveAccessControlEntryRecord().setId(id), 0));
        }
        return new AclDeleteResult(deleted);
    }

    static void validateFilter(AclBindingFilter filter) {
        if (filter.patternFilter().isUnknown()) {
            throw new InvalidRequestException("Unknown patternFilter.");
        }
        if (filter.entryFilter().isUnknown()) {
            throw new InvalidRequestException("Unknown entryFilter.");
        }
    }

    public void replay(AccessControlEntryRecord record, Optional<OffsetAndEpoch> snapshotId) {
        StandardAclWithId aclWithId = StandardAclWithId.fromRecord(record);
        this.idToAcl.put(aclWithId.id(), aclWithId.acl());
        this.existingAcls.add(aclWithId.acl());
        if (!snapshotId.isPresent()) {
            this.authorizer.ifPresent(a -> a.addAcl(aclWithId.id(), aclWithId.acl()));
        }
    }

    public void replay(RemoveAccessControlEntryRecord record, Optional<OffsetAndEpoch> snapshotId) {
        ConfluentStandardAcl acl = this.idToAcl.remove(record.id());
        if (acl == null) {
            throw new RuntimeException("Unable to replay " + record + ": no acl with that ID found.");
        }
        if (!this.existingAcls.remove(acl)) {
            throw new RuntimeException("Unable to replay " + record + " for " + acl + ": acl not found in existingAcls.");
        }
        if (!snapshotId.isPresent()) {
            this.authorizer.ifPresent(a -> a.removeAcl(record.id()));
        }
    }

    Map<Uuid, ConfluentStandardAcl> idToAcl() {
        return Collections.unmodifiableMap(this.idToAcl);
    }

    Iterator<List<ApiMessageAndVersion>> iterator(long epoch) {
        final Iterator<Map.Entry<Uuid, ConfluentStandardAcl>> iterator = this.idToAcl.entrySet(epoch).iterator();
        return new StandardAclRecordIterator(new Iterator<StandardAclWithId>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public StandardAclWithId next() {
                Map.Entry entry = (Map.Entry)iterator.next();
                return new StandardAclWithId((Uuid)entry.getKey(), (ConfluentStandardAcl)entry.getValue());
            }
        });
    }
}

