/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.DuplicateBrokerRegistrationException;
import org.apache.kafka.common.errors.InconsistentClusterIdException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.BrokerHeartbeatManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerRegistrationFencingChange;
import org.apache.kafka.metadata.BrokerRegistrationInControlledShutdownChange;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.metadata.placement.ReplicaPlacer;
import org.apache.kafka.metadata.placement.StripedReplicaPlacer;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.apache.kafka.server.common.AlterReplicaExclusionsReply;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.BrokerReplicaExclusionModificationResult;
import org.apache.kafka.server.common.BrokerReplicaExclusionResult;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.BrokerReplicaExclusionUtils;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.slf4j.Logger;

public class ClusterControlManager {
    static final long DEFAULT_SESSION_TIMEOUT_NS = TimeUnit.NANOSECONDS.convert(18L, TimeUnit.SECONDS);
    private final LogContext logContext;
    private final String clusterId;
    private final Logger log;
    private final Time time;
    private final long sessionTimeoutNs;
    private final ReplicaPlacer replicaPlacer;
    private final TimelineHashMap<Integer, BrokerRegistration> brokerRegistrations;
    private final TimelineHashMap<Integer, Long> registerBrokerRecordOffsets;
    private final TimelineHashMap<Integer, String> brokerReplicaExclusions;
    private BrokerHeartbeatManager heartbeatManager;
    private Optional<ReadyBrokersFuture> readyBrokersFuture;
    private final FeatureControlManager featureControl;

    private ClusterControlManager(LogContext logContext, String clusterId, Time time, SnapshotRegistry snapshotRegistry, long sessionTimeoutNs, ReplicaPlacer replicaPlacer, FeatureControlManager featureControl) {
        this.logContext = logContext;
        this.clusterId = clusterId;
        this.log = logContext.logger(ClusterControlManager.class);
        this.time = time;
        this.sessionTimeoutNs = sessionTimeoutNs;
        this.replicaPlacer = replicaPlacer;
        this.brokerRegistrations = new TimelineHashMap(snapshotRegistry, 0);
        this.registerBrokerRecordOffsets = new TimelineHashMap(snapshotRegistry, 0);
        this.brokerReplicaExclusions = new TimelineHashMap(snapshotRegistry, 0);
        this.heartbeatManager = null;
        this.readyBrokersFuture = Optional.empty();
        this.featureControl = featureControl;
    }

    ReplicaPlacer replicaPlacer() {
        return this.replicaPlacer;
    }

    public void activate() {
        this.heartbeatManager = new BrokerHeartbeatManager(this.logContext, this.time, this.sessionTimeoutNs);
        for (BrokerRegistration registration : this.brokerRegistrations.values()) {
            this.heartbeatManager.touch(registration.id(), registration.fenced(), -1L);
        }
    }

    public void deactivate() {
        this.heartbeatManager = null;
    }

    Map<Integer, BrokerRegistration> brokerRegistrations() {
        return this.brokerRegistrations;
    }

    Map<Integer, Map<String, VersionRange>> brokerSupportedVersions() {
        return this.brokerRegistrations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((BrokerRegistration)entry.getValue()).supportedFeatures()));
    }

    Set<Integer> fencedBrokerIds() {
        return this.brokerRegistrations.values().stream().filter(BrokerRegistration::fenced).map(BrokerRegistration::id).collect(Collectors.toSet());
    }

    public Map<Integer, String> activeBrokerReplicaExclusions() {
        return Collections.unmodifiableMap(this.brokerReplicaExclusions);
    }

    public ControllerResult<BrokerRegistrationReply> registerBroker(BrokerRegistrationRequestData request, long brokerEpoch, FinalizedControllerFeatures finalizedFeatures) {
        if (this.heartbeatManager == null) {
            throw new RuntimeException("ClusterControlManager is not active.");
        }
        if (!this.clusterId.equals(request.clusterId())) {
            throw new InconsistentClusterIdException("Expected cluster ID " + this.clusterId + ", but got cluster ID " + request.clusterId());
        }
        int brokerId = request.brokerId();
        BrokerRegistration existing = this.brokerRegistrations.get(brokerId);
        if (existing != null) {
            if (this.heartbeatManager.hasValidSession(brokerId)) {
                if (!existing.incarnationId().equals((Object)request.incarnationId())) {
                    throw new DuplicateBrokerRegistrationException("Another broker is registered with that broker id.");
                }
            } else if (!existing.incarnationId().equals((Object)request.incarnationId())) {
                this.heartbeatManager.remove(brokerId);
            }
        }
        RegisterBrokerRecord record = new RegisterBrokerRecord().setBrokerId(brokerId).setIncarnationId(request.incarnationId()).setBrokerEpoch(brokerEpoch).setRack(request.rack());
        for (BrokerRegistrationRequestData.Listener listener : request.listeners()) {
            record.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setHost(listener.host()).setName(listener.name()).setPort(listener.port()).setSecurityProtocol(listener.securityProtocol()));
        }
        for (BrokerRegistrationRequestData.Feature feature : request.features()) {
            record.features().add(this.processRegistrationFeature(brokerId, finalizedFeatures, feature));
        }
        if (request.features().find("metadata.version") == null && request.features().find("confluent.metadata.version") == null) {
            record.features().add(this.processRegistrationFeature(brokerId, finalizedFeatures, new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_KRAFT_VERSION.apacheFeatureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_KRAFT_VERSION.apacheFeatureLevel())));
            record.features().add(this.processRegistrationFeature(brokerId, finalizedFeatures, new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_KRAFT_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_KRAFT_VERSION.confluentFeatureLevel())));
        }
        this.heartbeatManager.register(brokerId, record.fenced());
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.add(new ApiMessageAndVersion((ApiMessage)record, this.featureControl.metadataVersion().registerBrokerRecordVersion()));
        return ControllerResult.atomicOf(records, new BrokerRegistrationReply(brokerEpoch));
    }

    private void throwUnsupportedVersionDueToIncompatibleFeature(int brokerId, BrokerRegistrationRequestData.Feature feature, short finalizedLevel) {
        String logMessage = "Unable to register broker " + brokerId + " because it does not support version " + finalizedLevel + " of " + feature.name() + ". It wants a version between " + feature.minSupportedVersion() + " and " + feature.maxSupportedVersion() + ", inclusive.";
        this.log.error(logMessage);
        throw new UnsupportedVersionException(logMessage);
    }

    RegisterBrokerRecord.BrokerFeature processRegistrationFeature(int brokerId, FinalizedControllerFeatures finalizedFeatures, BrokerRegistrationRequestData.Feature feature) {
        Optional<Short> finalized = finalizedFeatures.get(feature.name());
        if (finalized.isPresent()) {
            if (!VersionRange.of(feature.minSupportedVersion(), feature.maxSupportedVersion()).contains(finalized.get())) {
                if ("confluent.metadata.version".equals(feature.name())) {
                    MetadataVersion finalizedMetadataVersion = MetadataVersion.fromConfluentFeatureLevel((short)finalized.get());
                    short confluentLevel = finalizedMetadataVersion.confluentFeatureLevel();
                    short apacheLevel = finalizedMetadataVersion.apacheFeatureLevel();
                    if (confluentLevel > 107 || !VersionRange.of(feature.minSupportedVersion(), feature.maxSupportedVersion()).contains(apacheLevel)) {
                        this.throwUnsupportedVersionDueToIncompatibleFeature(brokerId, feature, finalized.get());
                    }
                } else {
                    this.throwUnsupportedVersionDueToIncompatibleFeature(brokerId, feature, finalized.get());
                }
            }
        } else {
            this.log.warn("Broker {} registered with feature {} that is unknown to the controller", (Object)brokerId, (Object)feature.name());
        }
        return new RegisterBrokerRecord.BrokerFeature().setName(feature.name()).setMinSupportedVersion(feature.minSupportedVersion()).setMaxSupportedVersion(feature.maxSupportedVersion());
    }

    public OptionalLong registerBrokerRecordOffset(int brokerId) {
        Long registrationOffset = this.registerBrokerRecordOffsets.get(brokerId);
        if (registrationOffset != null) {
            return OptionalLong.of(registrationOffset);
        }
        return OptionalLong.empty();
    }

    public ControllerResult<AlterReplicaExclusionsReply> processAlterReplicaExclusions(Set<AlterReplicaExclusionOp> requestedExclusions) {
        if (BrokerReplicaExclusionUtils.exclusionsMatchCurrentState(this.brokerReplicaExclusions, requestedExclusions)) {
            Set results = requestedExclusions.stream().map(op -> new BrokerReplicaExclusionResult(op.brokerId(), Optional.empty(), op.opType(), op.reason())).collect(Collectors.toSet());
            this.log.debug("Request with exclusion operations {} was matches the current state of the cluster - returning a successful response and not applying anything.", requestedExclusions);
            return ControllerResult.of(Collections.emptyList(), new AlterReplicaExclusionsReply(true, true, results));
        }
        BrokerReplicaExclusionModificationResult modificationResult = BrokerReplicaExclusionUtils.prepareReplicaExclusions(this.brokerReplicaExclusions, requestedExclusions);
        if (!modificationResult.shouldApply()) {
            List errorStrings = modificationResult.reply().exclusionResults().stream().filter(r -> r.apiErrorOptional().isPresent()).map(e -> String.format("%s for broker %d, error %s", e.opType(), e.brokerId(), e.apiErrorOptional().get())).collect(Collectors.toList());
            this.log.info("Will not apply replica exclusions {} due to {} errors ({}})", new Object[]{requestedExclusions, errorStrings.size(), errorStrings});
            return ControllerResult.of(Collections.emptyList(), modificationResult.reply());
        }
        this.log.info("Applying {} replica exclusion operations ({})", (Object)requestedExclusions.size(), requestedExclusions.stream().map(e -> String.format("Broker %d -> %s (reason: %s)", e.brokerId(), e.opType(), e.reason())).collect(Collectors.toList()));
        return ControllerResult.of(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)this.exclusionRecord(modificationResult.modifiedExclusions().entrySet()), MetadataRecordType.BROKER_REPLICA_EXCLUSION_RECORD.highestSupportedVersion())), modificationResult.reply());
    }

    public void replay(RegisterBrokerRecord record, long offset) {
        Object endpoint;
        this.registerBrokerRecordOffsets.put(record.brokerId(), offset);
        int brokerId = record.brokerId();
        ArrayList<Endpoint> listeners = new ArrayList<Endpoint>();
        Iterator iterator = record.endPoints().iterator();
        while (iterator.hasNext()) {
            endpoint = (RegisterBrokerRecord.BrokerEndpoint)iterator.next();
            listeners.add(new Endpoint(((RegisterBrokerRecord.BrokerEndpoint)endpoint).name(), SecurityProtocol.forId((short)((RegisterBrokerRecord.BrokerEndpoint)endpoint).securityProtocol()), ((RegisterBrokerRecord.BrokerEndpoint)endpoint).host(), ((RegisterBrokerRecord.BrokerEndpoint)endpoint).port()));
        }
        HashMap<String, VersionRange> features = new HashMap<String, VersionRange>();
        endpoint = record.features().iterator();
        while (endpoint.hasNext()) {
            RegisterBrokerRecord.BrokerFeature feature = (RegisterBrokerRecord.BrokerFeature)endpoint.next();
            features.put(feature.name(), VersionRange.of(feature.minSupportedVersion(), feature.maxSupportedVersion()));
        }
        BrokerRegistration prevRegistration = this.brokerRegistrations.put(brokerId, new BrokerRegistration(brokerId, record.brokerEpoch(), record.incarnationId(), listeners, features, Optional.ofNullable(record.rack()), record.fenced(), record.inControlledShutdown()));
        if (this.heartbeatManager != null) {
            if (prevRegistration != null) {
                this.heartbeatManager.remove(brokerId);
            }
            this.heartbeatManager.register(brokerId, record.fenced());
        }
        if (prevRegistration == null) {
            this.log.info("Registered new broker: {}", (Object)record);
        } else if (prevRegistration.incarnationId().equals((Object)record.incarnationId())) {
            this.log.info("Re-registered broker incarnation: {}", (Object)record);
        } else {
            this.log.info("Re-registered broker id {}: {}", (Object)brokerId, (Object)record);
        }
    }

    public void replay(UnregisterBrokerRecord record) {
        this.registerBrokerRecordOffsets.remove(record.brokerId());
        int brokerId = record.brokerId();
        BrokerRegistration registration = this.brokerRegistrations.get(brokerId);
        if (registration == null) {
            throw new RuntimeException(String.format("Unable to replay %s: no broker registration found for that id", record));
        }
        if (registration.epoch() != record.brokerEpoch()) {
            throw new RuntimeException(String.format("Unable to replay %s: no broker registration with that epoch found", record));
        }
        if (this.heartbeatManager != null) {
            this.heartbeatManager.remove(brokerId);
        }
        this.brokerRegistrations.remove(brokerId);
        this.log.info("Unregistered broker: {}", (Object)record);
    }

    public void replay(BrokerReplicaExclusionRecord record) {
        Map<Integer, String> exclusionsInRecord = record.brokerExclusions().stream().collect(Collectors.toMap(BrokerReplicaExclusionRecord.BrokerReplicaExclusion::brokerId, BrokerReplicaExclusionRecord.BrokerReplicaExclusion::reason));
        HashMap<Integer, String> oldExclusions = new HashMap<Integer, String>(this.brokerReplicaExclusions);
        this.brokerReplicaExclusions.clear();
        this.brokerReplicaExclusions.putAll(exclusionsInRecord);
        this.log.info("Loaded new broker replica exclusions {} (old exclusions {})", new TreeMap<Integer, String>(this.brokerReplicaExclusions), new TreeMap<Integer, String>(oldExclusions));
    }

    public void replay(FenceBrokerRecord record) {
        this.replayRegistrationChange(record, record.id(), record.epoch(), BrokerRegistrationFencingChange.FENCE.asBoolean(), BrokerRegistrationInControlledShutdownChange.NONE.asBoolean());
    }

    public void replay(UnfenceBrokerRecord record) {
        this.replayRegistrationChange(record, record.id(), record.epoch(), BrokerRegistrationFencingChange.UNFENCE.asBoolean(), BrokerRegistrationInControlledShutdownChange.NONE.asBoolean());
    }

    public void replay(BrokerRegistrationChangeRecord record) {
        BrokerRegistrationFencingChange fencingChange = BrokerRegistrationFencingChange.fromValue(record.fenced()).orElseThrow(() -> new IllegalStateException(String.format("Unable to replay %s: unknown value for fenced field: %x", record, record.fenced())));
        BrokerRegistrationInControlledShutdownChange inControlledShutdownChange = BrokerRegistrationInControlledShutdownChange.fromValue(record.inControlledShutdown()).orElseThrow(() -> new IllegalStateException(String.format("Unable to replay %s: unknown value for inControlledShutdown field: %x", record, record.inControlledShutdown())));
        this.replayRegistrationChange(record, record.brokerId(), record.brokerEpoch(), fencingChange.asBoolean(), inControlledShutdownChange.asBoolean());
    }

    private void replayRegistrationChange(ApiMessage record, int brokerId, long brokerEpoch, Optional<Boolean> fencingChange, Optional<Boolean> inControlledShutdownChange) {
        BrokerRegistration curRegistration = this.brokerRegistrations.get(brokerId);
        if (curRegistration == null) {
            throw new RuntimeException(String.format("Unable to replay %s: no broker registration found for that id", record.toString()));
        }
        if (curRegistration.epoch() != brokerEpoch) {
            throw new RuntimeException(String.format("Unable to replay %s: no broker registration with that epoch found", record.toString()));
        }
        BrokerRegistration nextRegistration = curRegistration.cloneWith(fencingChange, inControlledShutdownChange);
        if (!curRegistration.equals(nextRegistration)) {
            this.brokerRegistrations.put(brokerId, nextRegistration);
        } else {
            this.log.info("Ignoring no-op registration change for {}", (Object)curRegistration);
        }
        if (this.heartbeatManager != null) {
            this.heartbeatManager.register(brokerId, nextRegistration.fenced());
        }
        if (this.readyBrokersFuture.isPresent() && this.readyBrokersFuture.get().check()) {
            this.readyBrokersFuture.get().future.complete(null);
            this.readyBrokersFuture = Optional.empty();
        }
    }

    Iterator<UsableBroker> usableBrokers() {
        if (this.heartbeatManager == null) {
            throw new RuntimeException("ClusterControlManager is not active.");
        }
        return this.heartbeatManager.usableBrokers(id -> this.brokerRegistrations.get(id).rack(), this.brokerReplicaExclusions.keySet());
    }

    public boolean isUnfenced(int brokerId) {
        BrokerRegistration registration = this.brokerRegistrations.get(brokerId);
        if (registration == null) {
            return false;
        }
        return !registration.fenced();
    }

    public BrokerRegistration registration(int brokerId) {
        return this.brokerRegistrations.get(brokerId);
    }

    public boolean inControlledShutdown(int brokerId) {
        BrokerRegistration registration = this.brokerRegistrations.get(brokerId);
        if (registration == null) {
            return false;
        }
        return registration.inControlledShutdown();
    }

    public boolean isActive(int brokerId) {
        BrokerRegistration registration = this.brokerRegistrations.get(brokerId);
        if (registration == null) {
            return false;
        }
        return !registration.inControlledShutdown() && !registration.fenced();
    }

    MetadataResponseData.MetadataResponseBrokerCollection unfencedBrokerEndpoints(ListenerName listenerName) {
        MetadataResponseData.MetadataResponseBrokerCollection brokers = new MetadataResponseData.MetadataResponseBrokerCollection();
        for (BrokerRegistration registration : this.brokerRegistrations.values()) {
            Endpoint endpoint;
            if (registration.fenced() || (endpoint = registration.listeners().get(listenerName.value())) == null) continue;
            MetadataResponseData.MetadataResponseBroker metadataResponseBroker = new MetadataResponseData.MetadataResponseBroker().setNodeId(registration.id()).setHost(endpoint.host()).setPort(endpoint.port());
            registration.rack().ifPresent(arg_0 -> ((MetadataResponseData.MetadataResponseBroker)metadataResponseBroker).setRack(arg_0));
            brokers.add((ImplicitLinkedHashCollection.Element)metadataResponseBroker);
        }
        return brokers;
    }

    BrokerHeartbeatManager heartbeatManager() {
        if (this.heartbeatManager == null) {
            throw new RuntimeException("ClusterControlManager is not active.");
        }
        return this.heartbeatManager;
    }

    public void checkBrokerEpoch(int brokerId, long brokerEpoch) {
        BrokerRegistration registration = this.brokerRegistrations.get(brokerId);
        if (registration == null) {
            throw new StaleBrokerEpochException("No broker registration found for broker id " + brokerId);
        }
        if (registration.epoch() != brokerEpoch) {
            throw new StaleBrokerEpochException("Expected broker epoch " + registration.epoch() + ", but got broker epoch " + brokerEpoch);
        }
    }

    public void addReadyBrokersFuture(CompletableFuture<Void> future, int minBrokers) {
        this.readyBrokersFuture = Optional.of(new ReadyBrokersFuture(future, minBrokers));
        if (this.readyBrokersFuture.get().check()) {
            this.readyBrokersFuture.get().future.complete(null);
            this.readyBrokersFuture = Optional.empty();
        }
    }

    ClusterControlIterator iterator(long epoch) {
        return new ClusterControlIterator(epoch);
    }

    private BrokerReplicaExclusionRecord exclusionRecord(Set<Map.Entry<Integer, String>> exclusions) {
        return new BrokerReplicaExclusionRecord().setBrokerExclusions(exclusions.stream().map(pair -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId((Integer)pair.getKey()).setReason((String)pair.getValue())).collect(Collectors.toList()));
    }

    class ClusterControlIterator
    implements Iterator<List<ApiMessageAndVersion>> {
        private final Iterator<Map.Entry<Integer, BrokerRegistration>> brokerRegistrationIterator;
        private final MetadataVersion metadataVersion;
        private final Set<Map.Entry<Integer, String>> replicaExclusions;
        private boolean replicaExclusionsIterated = false;

        ClusterControlIterator(long epoch) {
            this.brokerRegistrationIterator = ClusterControlManager.this.brokerRegistrations.entrySet(epoch).iterator();
            this.replicaExclusions = ClusterControlManager.this.brokerReplicaExclusions.entrySet(epoch);
            this.metadataVersion = ClusterControlManager.this.featureControl.metadataVersion();
        }

        @Override
        public boolean hasNext() {
            return this.brokerRegistrationIterator.hasNext() || !this.replicaExclusionsIterated;
        }

        @Override
        public List<ApiMessageAndVersion> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ArrayList<ApiMessageAndVersion> batch = new ArrayList<ApiMessageAndVersion>();
            if (this.brokerRegistrationIterator.hasNext()) {
                Map.Entry<Integer, BrokerRegistration> entry = this.brokerRegistrationIterator.next();
                int brokerId = entry.getKey();
                BrokerRegistration registration = entry.getValue();
                RegisterBrokerRecord.BrokerEndpointCollection endpoints = new RegisterBrokerRecord.BrokerEndpointCollection();
                for (Map.Entry<String, Endpoint> entry2 : registration.listeners().entrySet()) {
                    endpoints.add(new RegisterBrokerRecord.BrokerEndpoint().setName(entry2.getKey()).setHost(entry2.getValue().host()).setPort(entry2.getValue().port()).setSecurityProtocol(entry2.getValue().securityProtocol().id));
                }
                RegisterBrokerRecord.BrokerFeatureCollection features = new RegisterBrokerRecord.BrokerFeatureCollection();
                for (Map.Entry<String, VersionRange> entry3 : registration.supportedFeatures().entrySet()) {
                    features.add(new RegisterBrokerRecord.BrokerFeature().setName(entry3.getKey()).setMaxSupportedVersion(entry3.getValue().max()).setMinSupportedVersion(entry3.getValue().min()));
                }
                RegisterBrokerRecord registerBrokerRecord = new RegisterBrokerRecord().setBrokerId(brokerId).setIncarnationId(registration.incarnationId()).setBrokerEpoch(registration.epoch()).setEndPoints(endpoints).setFeatures(features).setRack(registration.rack().orElse(null)).setFenced(registration.fenced());
                if (this.metadataVersion.isInControlledShutdownStateSupported()) {
                    registerBrokerRecord.setInControlledShutdown(registration.inControlledShutdown());
                }
                batch.add(new ApiMessageAndVersion((ApiMessage)registerBrokerRecord, this.metadataVersion.registerBrokerRecordVersion()));
            }
            if (!this.replicaExclusionsIterated) {
                batch.add(new ApiMessageAndVersion((ApiMessage)ClusterControlManager.this.exclusionRecord(this.replicaExclusions), MetadataRecordType.BROKER_REPLICA_EXCLUSION_RECORD.highestSupportedVersion()));
                this.replicaExclusionsIterated = true;
            }
            return batch;
        }
    }

    class ReadyBrokersFuture {
        private final CompletableFuture<Void> future;
        private final int minBrokers;

        ReadyBrokersFuture(CompletableFuture<Void> future, int minBrokers) {
            this.future = future;
            this.minBrokers = minBrokers;
        }

        boolean check() {
            int numUnfenced = 0;
            for (BrokerRegistration registration : ClusterControlManager.this.brokerRegistrations.values()) {
                if (!registration.fenced()) {
                    ++numUnfenced;
                }
                if (numUnfenced < this.minBrokers) continue;
                return true;
            }
            return false;
        }
    }

    static class Builder {
        private LogContext logContext = null;
        private String clusterId = null;
        private Time time = Time.SYSTEM;
        private SnapshotRegistry snapshotRegistry = null;
        private long sessionTimeoutNs = DEFAULT_SESSION_TIMEOUT_NS;
        private ReplicaPlacer replicaPlacer = null;
        private FeatureControlManager featureControl = null;

        Builder() {
        }

        Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder setClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        Builder setTime(Time time) {
            this.time = time;
            return this;
        }

        Builder setSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        Builder setSessionTimeoutNs(long sessionTimeoutNs) {
            this.sessionTimeoutNs = sessionTimeoutNs;
            return this;
        }

        Builder setReplicaPlacer(ReplicaPlacer replicaPlacer) {
            this.replicaPlacer = replicaPlacer;
            return this;
        }

        Builder setFeatureControlManager(FeatureControlManager featureControl) {
            this.featureControl = featureControl;
            return this;
        }

        ClusterControlManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.clusterId == null) {
                this.clusterId = Uuid.randomUuid().toString();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.replicaPlacer == null) {
                this.replicaPlacer = new StripedReplicaPlacer(new Random());
            }
            if (this.featureControl == null) {
                throw new RuntimeException("You must specify FeatureControlManager");
            }
            return new ClusterControlManager(this.logContext, this.clusterId, this.time, this.snapshotRegistry, this.sessionTimeoutNs, this.replicaPlacer, this.featureControl);
        }
    }
}

