/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.server.common.MetadataVersion;

public final class AclsDelta {
    private final AclsImage image;
    private final Map<Uuid, Optional<ConfluentStandardAcl>> changes = new LinkedHashMap<Uuid, Optional<ConfluentStandardAcl>>();
    private boolean isSnapshotDelta = false;

    public AclsDelta(AclsImage image) {
        this.image = image;
    }

    public Map<Uuid, Optional<ConfluentStandardAcl>> changes() {
        return this.changes;
    }

    void finishSnapshot() {
        this.isSnapshotDelta = true;
    }

    public void handleMetadataVersionChange(MetadataVersion newVersion) {
    }

    public boolean isSnapshotDelta() {
        return this.isSnapshotDelta;
    }

    public void replay(AccessControlEntryRecord record) {
        StandardAclWithId aclWithId = StandardAclWithId.fromRecord(record);
        this.changes.put(aclWithId.id(), Optional.of(aclWithId.acl()));
    }

    public void replay(RemoveAccessControlEntryRecord record) {
        if (this.image.acls().containsKey(record.id())) {
            this.changes.put(record.id(), Optional.empty());
        } else if (this.changes.containsKey(record.id())) {
            this.changes.remove(record.id());
        } else {
            throw new IllegalStateException("Failed to find existing ACL with ID " + record.id() + " in either image or changes");
        }
    }

    public AclsImage apply() {
        HashMap<Uuid, ConfluentStandardAcl> newAcls = new HashMap<Uuid, ConfluentStandardAcl>();
        if (!this.isSnapshotDelta) {
            for (Map.Entry<Uuid, Object> entry : this.image.acls().entrySet()) {
                Optional<ConfluentStandardAcl> change = this.changes.get(entry.getKey());
                if (change == null) {
                    newAcls.put(entry.getKey(), (ConfluentStandardAcl)entry.getValue());
                    continue;
                }
                if (!change.isPresent()) continue;
                newAcls.put(entry.getKey(), change.get());
            }
        }
        for (Map.Entry<Uuid, Object> entry : this.changes.entrySet()) {
            if (newAcls.containsKey(entry.getKey()) || !((Optional)entry.getValue()).isPresent()) continue;
            newAcls.put(entry.getKey(), (ConfluentStandardAcl)((Optional)entry.getValue()).get());
        }
        return new AclsImage(newAcls);
    }

    public String toString() {
        return "AclsDelta(isSnapshotDelta=" + this.isSnapshotDelta + ", changes=" + this.changes.entrySet().stream().map(e -> "" + e.getKey() + "=" + e.getValue()).collect(Collectors.joining(", ")) + ")";
    }
}

