/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class AclsImage {
    public static final AclsImage EMPTY = new AclsImage(Collections.emptyMap());
    private final Map<Uuid, ConfluentStandardAcl> acls;

    public AclsImage(Map<Uuid, ConfluentStandardAcl> acls) {
        this.acls = Collections.unmodifiableMap(acls);
    }

    public boolean isEmpty() {
        return this.acls.isEmpty();
    }

    public Map<Uuid, ConfluentStandardAcl> acls() {
        return this.acls;
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out) {
        ArrayList<ApiMessageAndVersion> batch = new ArrayList<ApiMessageAndVersion>();
        for (Map.Entry<Uuid, ConfluentStandardAcl> entry : this.acls.entrySet()) {
            StandardAclWithId aclWithId = new StandardAclWithId(entry.getKey(), entry.getValue());
            batch.add(new ApiMessageAndVersion((ApiMessage)aclWithId.toRecord(), 0));
        }
        out.accept(batch);
    }

    public int hashCode() {
        return this.acls.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AclsImage)) {
            return false;
        }
        AclsImage other = (AclsImage)o;
        return this.acls.equals(other.acls);
    }

    public String toString() {
        return "AclsImage(" + this.acls.values().stream().map(a -> a.toString()).collect(Collectors.joining(", ")) + ")";
    }
}

