/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class BrokerReplicaExclusionsImage {
    public static final BrokerReplicaExclusionsImage EMPTY = new BrokerReplicaExclusionsImage(Collections.emptyMap());
    private final Map<Integer, String> exclusionReasonsByBrokerId;

    public BrokerReplicaExclusionsImage(Map<Integer, String> exclusions) {
        this.exclusionReasonsByBrokerId = Collections.unmodifiableMap(exclusions);
    }

    public Map<Integer, String> activeBrokerReplicaExclusions() {
        return this.exclusionReasonsByBrokerId;
    }

    public boolean isEmpty() {
        return this.exclusionReasonsByBrokerId.isEmpty();
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out) {
        BrokerReplicaExclusionRecord record = new BrokerReplicaExclusionRecord().setBrokerExclusions(this.exclusionReasonsByBrokerId.entrySet().stream().map(entry -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId((Integer)entry.getKey()).setReason((String)entry.getValue())).collect(Collectors.toList()));
        out.accept(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)record, MetadataRecordType.BROKER_REPLICA_EXCLUSION_RECORD.highestSupportedVersion())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerReplicaExclusionsImage that = (BrokerReplicaExclusionsImage)o;
        return Objects.equals(this.exclusionReasonsByBrokerId, that.exclusionReasonsByBrokerId);
    }

    public int hashCode() {
        return Objects.hash(this.exclusionReasonsByBrokerId);
    }

    public String toString() {
        return "BrokerReplicaExclusionsImage{exclusionReasonsByBrokerId=" + this.exclusionReasonsByBrokerId + "}";
    }
}

