/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class ConfigurationImage {
    public static final ConfigurationImage EMPTY = new ConfigurationImage(Collections.emptyMap());
    private final Map<String, String> data;

    public ConfigurationImage(Map<String, String> data) {
        this.data = data;
    }

    Map<String, String> data() {
        return this.data;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll(this.data);
        return properties;
    }

    public void write(ConfigResource configResource, MetadataEncryptor encryptor, KafkaConfigSchema configSchema, Consumer<List<ApiMessageAndVersion>> out) {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            ConfigRecord configRecord = new ConfigRecord().setResourceType(configResource.type().id()).setResourceName(configResource.name()).setName(entry.getKey()).setValue(entry.getValue());
            ApiMessageAndVersion messageAndVersion = new ApiMessageAndVersion((ApiMessage)configRecord, MetadataRecordType.CONFIG_RECORD.highestSupportedVersion());
            if (configSchema.isSensitive(configRecord)) {
                records.add(encryptor.encrypt(messageAndVersion));
                continue;
            }
            records.add(messageAndVersion);
        }
        out.accept(records);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConfigurationImage)) {
            return false;
        }
        ConfigurationImage other = (ConfigurationImage)o;
        return this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        return "ConfigurationImage(data=" + this.data.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(", ")) + ")";
    }
}

