/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.ConfigurationImage;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class ConfigurationsImage {
    public static final ConfigurationsImage EMPTY = new ConfigurationsImage(Collections.emptyMap());
    private final Map<ConfigResource, ConfigurationImage> data;

    public ConfigurationsImage(Map<ConfigResource, ConfigurationImage> data) {
        this.data = Collections.unmodifiableMap(data);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    Map<ConfigResource, ConfigurationImage> resourceData() {
        return this.data;
    }

    public Properties configProperties(ConfigResource configResource) {
        ConfigurationImage configurationImage = this.data.get(configResource);
        if (configurationImage != null) {
            return configurationImage.toProperties();
        }
        return new Properties();
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out, MetadataEncryptor encryptor, KafkaConfigSchema configSchema) {
        for (Map.Entry<ConfigResource, ConfigurationImage> entry : this.data.entrySet()) {
            ConfigResource configResource = entry.getKey();
            ConfigurationImage configImage = entry.getValue();
            configImage.write(configResource, encryptor, configSchema, out);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConfigurationsImage)) {
            return false;
        }
        ConfigurationsImage other = (ConfigurationsImage)o;
        return this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        return "ConfigurationsImage(data=" + this.data.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", ")) + ")";
    }
}

