/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;

public final class TopicDelta {
    private final TopicImage image;
    private final Map<Integer, PartitionRegistration> partitionChanges = new HashMap<Integer, PartitionRegistration>();
    private MirrorTopic mirrorTopicChange = null;
    private MirrorTopic previousMirrorTopic = null;
    private boolean clusterLinkDeleted = false;

    public TopicDelta(TopicImage image) {
        this.image = image;
    }

    public TopicImage image() {
        return this.image;
    }

    public Map<Integer, PartitionRegistration> partitionChanges() {
        return this.partitionChanges;
    }

    public String name() {
        return this.image.name();
    }

    public Uuid id() {
        return this.image.id();
    }

    public void replay(PartitionRecord record) {
        PartitionRegistration partition = new PartitionRegistration(record);
        if (partition.isMirror() && !this.hasMirrorTopicState()) {
            throw new RuntimeException("Topic is not a mirror, but we saw linked partition state");
        }
        this.partitionChanges.put(record.partitionId(), partition);
    }

    public void replay(PartitionChangeRecord record) {
        PartitionRegistration partition = this.partitionChanges.get(record.partitionId());
        if (partition == null && (partition = this.image.partitions().get(record.partitionId())) == null) {
            throw new RuntimeException("Unable to find partition " + record.topicId() + ":" + record.partitionId());
        }
        if (partition.isMirror() && !this.hasMirrorTopicState()) {
            throw new RuntimeException("Topic " + this.image.id() + " is not a mirror, but we saw linked partition state");
        }
        this.partitionChanges.put(record.partitionId(), partition.merge(record));
    }

    void replay(MirrorTopicRecord record) {
        if (!this.image.mirrorTopic().isPresent()) {
            if (this.mirrorTopicChange != null) {
                throw new RuntimeException("Unable to set mirror topic state in delta due to existing " + this.mirrorTopicChange);
            }
        } else {
            throw new RuntimeException("Unable to set mirror topic state on mirrored topic " + this.image.mirrorTopic().get());
        }
        this.mirrorTopicChange = MirrorTopic.fromRecord(record);
    }

    void replay(MirrorTopicChangeRecord record) {
        if (this.hasMirrorTopicState()) {
            this.previousMirrorTopic = this.image.mirrorTopic().orElse(this.mirrorTopicChange);
            this.mirrorTopicChange = MirrorTopic.fromChangeRecord(this.previousMirrorTopic, record);
            for (Map.Entry<Integer, PartitionRegistration> entry : this.image.partitions().entrySet()) {
                this.partitionChanges.putIfAbsent(entry.getKey(), entry.getValue());
            }
        } else {
            throw new RuntimeException("Unable to change the mirror topic state on non-mirrored topic " + this.image.id());
        }
    }

    void replay(RemoveClusterLinkRecord record) {
        if (this.hasMirrorTopicState()) {
            for (Integer partitionId : this.image.partitions().keySet()) {
                PartitionRegistration prevPartition = this.partitionChanges.get(partitionId);
                if (prevPartition == null && (prevPartition = this.image.partitions().get(partitionId)) == null) {
                    throw new RuntimeException("Unable to find partition " + this.image.id() + ":" + partitionId);
                }
                this.partitionChanges.put(partitionId, prevPartition.unlink());
            }
        } else {
            throw new RuntimeException("Unable to remove mirror topic state on non-mirrored topic " + this.image.id());
        }
        this.clusterLinkDeleted = true;
        this.mirrorTopicChange = null;
        this.previousMirrorTopic = this.image.mirrorTopic().get();
    }

    public TopicImage apply() {
        HashMap<Integer, PartitionRegistration> newPartitions = new HashMap<Integer, PartitionRegistration>();
        for (Map.Entry<Integer, PartitionRegistration> entry : this.image.partitions().entrySet()) {
            int partitionId = entry.getKey();
            PartitionRegistration changedPartition = this.partitionChanges.get(partitionId);
            if (changedPartition == null) {
                newPartitions.put(partitionId, entry.getValue());
                continue;
            }
            newPartitions.put(partitionId, changedPartition);
        }
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitionChanges.entrySet()) {
            if (newPartitions.containsKey(entry.getKey())) continue;
            newPartitions.put(entry.getKey(), entry.getValue());
        }
        MirrorTopic newMirrorTopic = this.clusterLinkDeleted ? null : (this.mirrorTopicChange != null ? this.mirrorTopicChange : (MirrorTopic)this.image.mirrorTopic().orElse(null));
        return new TopicImage(this.image.name(), this.image.id(), newPartitions, newMirrorTopic);
    }

    public LocalReplicaChanges localChanges(int brokerId) {
        HashSet<TopicPartition> deletes = new HashSet<TopicPartition>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> leaders = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> followers = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitionChanges.entrySet()) {
            PartitionRegistration prevPartition;
            if (!Replicas.contains(entry.getValue().replicas, brokerId)) {
                prevPartition = this.image.partitions().get(entry.getKey());
                if (prevPartition == null || !Replicas.contains(prevPartition.replicas, brokerId)) continue;
                deletes.add(new TopicPartition(this.name(), entry.getKey().intValue()));
                continue;
            }
            if (entry.getValue().leader == brokerId) {
                prevPartition = this.image.partitions().get(entry.getKey());
                if (prevPartition != null && prevPartition.partitionEpoch == entry.getValue().partitionEpoch && this.mirrorTopicChange == null) continue;
                leaders.put(new TopicPartition(this.name(), entry.getKey().intValue()), new LocalReplicaChanges.PartitionInfo(this.id(), entry.getValue()));
                continue;
            }
            if (entry.getValue().leader == brokerId || !Replicas.contains(entry.getValue().replicas, brokerId) || (prevPartition = this.image.partitions().get(entry.getKey())) != null && prevPartition.partitionEpoch == entry.getValue().partitionEpoch && this.mirrorTopicChange == null) continue;
            followers.put(new TopicPartition(this.name(), entry.getKey().intValue()), new LocalReplicaChanges.PartitionInfo(this.id(), entry.getValue()));
        }
        return new LocalReplicaChanges(deletes, leaders, followers);
    }

    public Optional<MirrorTopic> mirrorTopicStateChange() {
        return Optional.ofNullable(this.mirrorTopicChange);
    }

    public Optional<MirrorTopic> previousMirrorTopicState() {
        return Optional.ofNullable(this.previousMirrorTopic);
    }

    private boolean hasMirrorTopicState() {
        return this.image.mirrorTopic().isPresent() || this.mirrorTopicChange != null;
    }

    public String toString() {
        String mirrorTopicState = this.mirrorTopicChange == null ? "" : ", mirrorTopic=" + this.mirrorTopicChange;
        return "TopicDelta(partitionChanges=" + this.partitionChanges + mirrorTopicState + ')';
    }
}

