/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;

public class ClusterLink {
    private final String linkName;
    private final Uuid linkId;
    private final String tenantPrefix;
    private final String sourceClusterId;

    public ClusterLink(ClusterLinkRecord record) {
        this(record.clusterLinkName(), record.clusterLinkId(), record.tenantPrefix(), record.sourceClusterId());
    }

    public ClusterLink(String linkName, Uuid linkId, String tenantPrefix, String sourceClusterId) {
        this.linkName = linkName;
        this.linkId = linkId;
        this.tenantPrefix = tenantPrefix;
        this.sourceClusterId = sourceClusterId;
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public Optional<String> tenantPrefix() {
        return Optional.ofNullable(this.tenantPrefix);
    }

    public String sourceClusterId() {
        return this.sourceClusterId;
    }

    public ClusterLinkRecord toRecord() {
        return new ClusterLinkRecord().setClusterLinkName(this.linkName).setClusterLinkId(this.linkId).setSourceClusterId(this.sourceClusterId).setTenantPrefix(this.tenantPrefix);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterLink)) {
            return false;
        }
        ClusterLink other = (ClusterLink)o;
        return this.linkName.equals(other.linkName) && this.linkId.equals((Object)other.linkId) && this.tenantPrefix.equals(other.tenantPrefix) && this.sourceClusterId.equals(other.sourceClusterId);
    }

    public int hashCode() {
        return Objects.hash(this.linkName, this.linkId, this.tenantPrefix, this.sourceClusterId);
    }

    public String toString() {
        String tenantPrefixString = this.tenantPrefix != null ? ", tenantPrefix=" + this.tenantPrefix : "";
        return "ClusterLinkImage(linkName=" + this.linkName + ", linkId=" + this.linkId + tenantPrefixString + ", sourceClusterId=" + this.sourceClusterId + ")";
    }
}

