/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.EncryptedEnvelopeRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public interface MetadataEncryptor {
    public Uuid id();

    public byte[] decrypt(byte[] var1);

    default public String decryptString(byte[] input) {
        byte[] value = this.decrypt(input);
        return new String(value, StandardCharsets.UTF_8);
    }

    default public ApiMessageAndVersion decrypt(EncryptedEnvelopeRecord record) {
        byte[] plaintext = this.decrypt(record.ciphertext());
        return MetadataRecordSerde.INSTANCE.read((Readable)new ByteBufferAccessor(ByteBuffer.wrap(plaintext)), plaintext.length);
    }

    public byte[] encrypt(byte[] var1);

    default public byte[] encryptString(String input) {
        return this.encrypt(input.getBytes(StandardCharsets.UTF_8));
    }

    default public ApiMessageAndVersion encrypt(ApiMessageAndVersion messageAndVersion) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = MetadataRecordSerde.INSTANCE.recordSize(messageAndVersion, cache);
        byte[] serialized = new byte[size];
        MetadataRecordSerde.INSTANCE.write(messageAndVersion, cache, (Writable)new ByteBufferAccessor(ByteBuffer.wrap(serialized)));
        return new ApiMessageAndVersion((ApiMessage)new EncryptedEnvelopeRecord().setCiphertext(this.encrypt(serialized)), 0);
    }

    public byte[] secret();
}

