/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.lang.reflect.Constructor;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.metadata.InstallMetadataEncryptorRecord;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;

public class MetadataEncryptorFactory {
    public static final String ACTIVE = "confluent.metadata.active.encryptor";
    public static final String CLASSES = "confluent.metadata.encryptor.classes";
    public static final String SECRETS = "confluent.metadata.encryptor.secrets";
    private final Map<Uuid, MetadataEncryptorConfig> configs;
    private final Uuid activeId;

    public MetadataEncryptorFactory(Map<String, Object> configs) {
        Map<Uuid, String> uuidsToSecrets;
        Map<Uuid, String> uuidsToClasses;
        try {
            this.activeId = Uuid.fromString((String)configs.getOrDefault(ACTIVE, Uuid.ZERO_UUID).toString());
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Unable to parse confluent.metadata.active.encryptor", (Throwable)e);
        }
        try {
            uuidsToClasses = MetadataEncryptorFactory.parseCompoundConfigValue(configs.getOrDefault(CLASSES, "").toString());
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Unable to parse confluent.metadata.encryptor.classes", (Throwable)e);
        }
        try {
            uuidsToSecrets = MetadataEncryptorFactory.parseCompoundConfigValue(configs.getOrDefault(SECRETS, "").toString());
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Unable to parse confluent.metadata.encryptor.secrets", (Throwable)e);
        }
        HashMap<Uuid, MetadataEncryptorConfig> newConfigs = new HashMap<Uuid, MetadataEncryptorConfig>();
        for (Map.Entry<Uuid, String> entry : uuidsToClasses.entrySet()) {
            byte[] secret;
            Uuid uuid = entry.getKey();
            String className = entry.getValue();
            String secretString = uuidsToSecrets.get(uuid);
            if (secretString == null) {
                throw new InvalidConfigurationException("No secret configured for " + uuid);
            }
            try {
                secret = Base64.getUrlDecoder().decode(secretString);
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Unable to base64 decode secretString " + secretString, (Throwable)e);
            }
            newConfigs.put(uuid, new MetadataEncryptorConfig(className, secret));
        }
        this.configs = Collections.unmodifiableMap(newConfigs);
    }

    static Map<Uuid, String> parseCompoundConfigValue(String value) {
        String[] inners = value.split(",");
        HashMap<Uuid, String> results = new HashMap<Uuid, String>();
        for (String inner : inners) {
            String effectiveInner = inner.trim();
            if (effectiveInner.isEmpty()) continue;
            int equalsIndex = effectiveInner.indexOf(61);
            if (equalsIndex < 0) {
                throw new RuntimeException("Invalid format: no equals sign found in entry.");
            }
            String uuidString = effectiveInner.substring(0, equalsIndex);
            Uuid uuid = Uuid.fromString((String)uuidString);
            results.put(uuid, effectiveInner.substring(equalsIndex + 1));
        }
        return results;
    }

    public MetadataEncryptor createFromConfig(InstallMetadataEncryptorRecord record) {
        return this.createFromConfig(record.keyId());
    }

    public MetadataEncryptor createFromConfig(Uuid id) {
        MetadataEncryptor encryptor;
        Constructor<?> constructor;
        Class<?> clazz;
        if (id.equals((Object)Uuid.ZERO_UUID)) {
            return NoOpMetadataEncryptor.INSTANCE;
        }
        MetadataEncryptorConfig config = this.configs.get(id);
        if (config == null) {
            throw new InvalidConfigurationException("No configuration found for metadata encryptor " + id);
        }
        try {
            clazz = Class.forName(config.className);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load class " + config.className + " for metadata encryptor " + id, e);
        }
        try {
            constructor = clazz.getConstructor(Uuid.class, byte[].class);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load constructor for " + config.className + " for metadata encryptor " + id, e);
        }
        try {
            encryptor = (MetadataEncryptor)constructor.newInstance(id, config.secret);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new RuntimeException("Problem invoking constructor for " + config.className + " for metadata encryptor " + id, e);
        }
        return encryptor;
    }

    public MetadataEncryptor createRandom(String className) {
        MetadataEncryptor encryptor;
        Constructor<?> constructor;
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load class " + className + " for new random metadata encryptor.", e);
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load constructor for " + className + " for new random metadata encryptor.", e);
        }
        try {
            encryptor = (MetadataEncryptor)constructor.newInstance(new Object[0]);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new RuntimeException("Problem invoking constructor for " + className + " for new random metadata encryptor.", e);
        }
        return encryptor;
    }

    public Uuid activeId() {
        return this.activeId;
    }

    static class MetadataEncryptorConfig {
        final String className;
        final byte[] secret;

        MetadataEncryptorConfig(String className, byte[] secret) {
            this.className = className;
            this.secret = secret;
        }
    }
}

