/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.utils.Time;

public interface MirrorTopic {
    public Uuid linkId();

    public String linkName();

    public Uuid topicId();

    public String topicName();

    public Uuid sourceTopicId();

    public String sourceTopicName();

    public State mirrorState();

    public long timeMs();

    public static MirrorTopic paused(MirrorTopic mirrorTopic, long timeMs, boolean topicLevel, boolean linkLevel, State previousState) {
        return new PausedMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), timeMs, topicLevel, linkLevel, previousState);
    }

    public static MirrorTopic pendingStopped(MirrorTopic mirrorTopic, long timeMs, boolean promoted) {
        return new PendingStoppedMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), timeMs, promoted);
    }

    public static MirrorTopic mirror(MirrorTopic mirrorTopic, long timeMs) {
        return new BaseMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), State.MIRROR, timeMs);
    }

    public static MirrorTopic failed(MirrorTopic mirrorTopic, long timeMs) {
        return new BaseMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), State.FAILED, timeMs);
    }

    public static MirrorTopic stopped(MirrorTopic mirrorTopic, long timeMs, List<Long> offsets) {
        return new StoppedMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), timeMs, offsets);
    }

    public static MirrorTopic fromRecord(MirrorTopicRecord record) {
        State state = State.fromStateName(record.mirrorTopicState());
        switch (state) {
            case MIRROR: 
            case FAILED: {
                return BaseMirrorTopic.fromRecord(record);
            }
            case PAUSED: {
                return PausedMirrorTopic.fromRecord(record);
            }
            case PENDING_STOPPED: {
                return PendingStoppedMirrorTopic.fromRecord(record);
            }
            case STOPPED: {
                return StoppedMirrorTopic.fromRecord(record);
            }
        }
        throw new IllegalStateException("Unknown mirror topic state " + record.mirrorTopicState());
    }

    public static MirrorTopic fromChangeRecord(MirrorTopic mirrorTopic, MirrorTopicChangeRecord changeRecord) {
        State state = State.fromStateName(changeRecord.mirrorTopicState());
        switch (state) {
            case MIRROR: {
                return MirrorTopic.mirror(mirrorTopic, changeRecord.timeMs());
            }
            case PAUSED: {
                return MirrorTopic.paused(mirrorTopic, changeRecord.timeMs(), changeRecord.topicLevelPause(), changeRecord.linkLevelPause(), State.fromStateName(changeRecord.previousToPausedState()));
            }
            case FAILED: {
                return MirrorTopic.failed(mirrorTopic, changeRecord.timeMs());
            }
            case PENDING_STOPPED: {
                return MirrorTopic.pendingStopped(mirrorTopic, changeRecord.timeMs(), changeRecord.promoted());
            }
            case STOPPED: {
                return MirrorTopic.stopped(mirrorTopic, changeRecord.timeMs(), changeRecord.stoppedLogEndOffsets());
            }
        }
        throw new IllegalStateException("Unknown mirror topic state " + changeRecord.mirrorTopicState());
    }

    public static MirrorTopicRecord toSnapshotRecord(MirrorTopic mirrorTopic, String topicName) {
        MirrorTopicRecord record = new MirrorTopicRecord().setTopicId(mirrorTopic.topicId()).setTopicName(topicName).setSourceTopicName(mirrorTopic.sourceTopicName()).setSourceTopicId(mirrorTopic.sourceTopicId()).setClusterLinkId(mirrorTopic.linkId()).setClusterLinkName(mirrorTopic.linkName()).setMirrorTopicState(mirrorTopic.mirrorState().stateName());
        switch (mirrorTopic.mirrorState()) {
            case MIRROR: 
            case FAILED: {
                break;
            }
            case PAUSED: {
                record.setPreviousToPausedState(((PausedMirrorTopic)mirrorTopic).prevToPausedState().stateName());
                record.setLinkLevelPause(((PausedMirrorTopic)mirrorTopic).linkLevel);
                record.setTopicLevelPause(((PausedMirrorTopic)mirrorTopic).topicLevel);
                break;
            }
            case PENDING_STOPPED: {
                record.setPromoted(((PendingStoppedMirrorTopic)mirrorTopic).promoted());
                break;
            }
            case STOPPED: {
                record.setStoppedLogEndOffsets(((StoppedMirrorTopic)mirrorTopic).offsets());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled mirror topic state " + (Object)((Object)mirrorTopic.mirrorState()));
            }
        }
        return record;
    }

    public static MirrorTopicChangeRecord toChangeRecord(MirrorTopic mirrorTopic) {
        MirrorTopicChangeRecord record = new MirrorTopicChangeRecord().setTopicId(mirrorTopic.topicId()).setTimeMs(Time.SYSTEM.milliseconds()).setClusterLinkId(mirrorTopic.linkId()).setClusterLinkName(mirrorTopic.linkName()).setMirrorTopicState(mirrorTopic.mirrorState().stateName());
        switch (mirrorTopic.mirrorState()) {
            case MIRROR: 
            case FAILED: {
                break;
            }
            case PAUSED: {
                record.setPreviousToPausedState(((PausedMirrorTopic)mirrorTopic).prevToPausedState().stateName());
                record.setLinkLevelPause(((PausedMirrorTopic)mirrorTopic).linkLevel);
                record.setTopicLevelPause(((PausedMirrorTopic)mirrorTopic).topicLevel);
                break;
            }
            case PENDING_STOPPED: {
                record.setPromoted(((PendingStoppedMirrorTopic)mirrorTopic).promoted());
                break;
            }
            case STOPPED: {
                record.setStoppedLogEndOffsets(((StoppedMirrorTopic)mirrorTopic).offsets());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled mirror topic state " + (Object)((Object)mirrorTopic.mirrorState()));
            }
        }
        return record;
    }

    public static final class StoppedMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final List<Long> offsets;

        StoppedMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, long timeMs, List<Long> offsets) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.STOPPED, timeMs);
            this.offsets = offsets == null ? Collections.emptyList() : Collections.unmodifiableList(offsets);
        }

        public static StoppedMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.STOPPED)) {
                throw new IllegalStateException();
            }
            return new StoppedMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.timeMs(), record.stoppedLogEndOffsets());
        }

        public List<Long> offsets() {
            return this.offsets;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StoppedMirrorTopic that = (StoppedMirrorTopic)o;
            return Objects.equals(this.offsets, that.offsets);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.offsets);
        }

        @Override
        public String toString() {
            return "StoppedMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", timeMs=" + this.timeMs() + ", offsets=" + this.offsets() + '}';
        }
    }

    public static final class PendingStoppedMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final boolean promoted;

        PendingStoppedMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, long timeMs, boolean promoted) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.PENDING_STOPPED, timeMs);
            this.promoted = promoted;
        }

        public static PendingStoppedMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.PENDING_STOPPED)) {
                throw new IllegalStateException();
            }
            return new PendingStoppedMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.timeMs(), record.promoted());
        }

        public boolean promoted() {
            return this.promoted;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PendingStoppedMirrorTopic that = (PendingStoppedMirrorTopic)o;
            return this.promoted == that.promoted;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.promoted);
        }

        @Override
        public String toString() {
            return "PendingStoppedMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", timeMs=" + this.timeMs() + ", promoted=" + this.promoted + '}';
        }
    }

    public static final class PausedMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final boolean topicLevel;
        private final boolean linkLevel;
        private final State prevToPausedState;

        public PausedMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, long timeMs, boolean topicLevel, boolean linkLevel, State prevToPausedState) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.PAUSED, timeMs);
            this.topicLevel = topicLevel;
            this.linkLevel = linkLevel;
            this.prevToPausedState = prevToPausedState;
        }

        public static PausedMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.PAUSED)) {
                throw new IllegalStateException();
            }
            return new PausedMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.timeMs(), record.topicLevelPause(), record.linkLevelPause(), State.fromStateName(record.previousToPausedState()));
        }

        public boolean topicLevel() {
            return this.topicLevel;
        }

        public boolean linkLevel() {
            return this.linkLevel;
        }

        public State prevToPausedState() {
            return this.prevToPausedState;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PausedMirrorTopic that = (PausedMirrorTopic)o;
            return this.topicLevel == that.topicLevel && this.linkLevel == that.linkLevel && this.prevToPausedState == that.prevToPausedState;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.topicLevel, this.linkLevel, this.prevToPausedState});
        }

        @Override
        public String toString() {
            return "PausedMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", timeMs=" + this.timeMs() + ", topicLevel=" + this.topicLevel + ", linkLevel=" + this.linkLevel + ", prevToPausedState=" + (Object)((Object)this.prevToPausedState) + '}';
        }
    }

    public static class BaseMirrorTopic
    implements MirrorTopic {
        private final Uuid linkId;
        private final String linkName;
        private final Uuid topicId;
        private final String topicName;
        private final Uuid sourceTopicId;
        private final String sourceTopicName;
        private final State mirrorState;
        private final long timeMs;

        BaseMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, State mirrorState, long timeMs) {
            this.linkId = linkId;
            this.linkName = linkName;
            this.topicId = topicId;
            this.topicName = topicName;
            this.sourceTopicId = sourceTopicId;
            this.sourceTopicName = sourceTopicName;
            this.mirrorState = mirrorState;
            this.timeMs = timeMs;
        }

        public static BaseMirrorTopic fromRecord(MirrorTopicRecord record) {
            State recordState = State.fromStateName(record.mirrorTopicState());
            if (!recordState.equals((Object)State.MIRROR) && !recordState.equals((Object)State.FAILED)) {
                throw new IllegalStateException("Must use state specific sub-class of MirrorTopic");
            }
            return new BaseMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), recordState, record.timeMs());
        }

        @Override
        public Uuid linkId() {
            return this.linkId;
        }

        @Override
        public String linkName() {
            return this.linkName;
        }

        @Override
        public Uuid topicId() {
            return this.topicId;
        }

        @Override
        public String topicName() {
            return this.topicName;
        }

        @Override
        public Uuid sourceTopicId() {
            return this.sourceTopicId;
        }

        @Override
        public String sourceTopicName() {
            return this.sourceTopicName;
        }

        @Override
        public State mirrorState() {
            return this.mirrorState;
        }

        @Override
        public long timeMs() {
            return this.timeMs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseMirrorTopic that = (BaseMirrorTopic)o;
            return this.timeMs == that.timeMs && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.topicId, that.topicId) && Objects.equals(this.sourceTopicId, that.sourceTopicId) && Objects.equals(this.sourceTopicName, that.sourceTopicName) && this.mirrorState == that.mirrorState;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.linkId, this.topicId, this.sourceTopicId, this.sourceTopicName, this.mirrorState, this.timeMs});
        }

        public String toString() {
            String prettyName = this.mirrorState.stateName + "Topic";
            return prettyName + "{linkId=" + this.linkId + ", linkName=" + this.linkName + ", topicId=" + this.topicId + ", topicName=" + this.topicName + ", sourceTopicId=" + this.sourceTopicId + ", sourceTopicName=" + this.sourceTopicName + ", mirrorState=" + (Object)((Object)this.mirrorState) + ", timeMs=" + this.timeMs + '}';
        }
    }

    public static enum State {
        MIRROR("Mirror"),
        PAUSED("PausedMirror"),
        FAILED("FailedMirror"),
        PENDING_STOPPED("PendingStoppedMirror"),
        STOPPED("StoppedMirror");

        private final String stateName;

        private State(String stateName) {
            this.stateName = stateName;
        }

        public String stateName() {
            return this.stateName;
        }

        public static State fromStateName(String stateName) {
            for (State state : State.values()) {
                if (!stateName.equals(state.stateName())) continue;
                return state;
            }
            throw new IllegalArgumentException("Unknown mirror topic state '" + stateName + "'.");
        }
    }
}

