/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.slf4j.Logger;

public class PartitionRegistration {
    public final int[] replicas;
    public final int[] isr;
    public final int[] removingReplicas;
    public final int[] addingReplicas;
    public final int leader;
    public final LeaderRecoveryState leaderRecoveryState;
    public final int leaderEpoch;
    public final int partitionEpoch;
    public final int linkedLeaderEpoch;
    public final LinkState linkState;

    public static boolean electionWasClean(int newLeader, int[] isr) {
        return newLeader == -1 || Replicas.contains(isr, newLeader);
    }

    public PartitionRegistration(PartitionRecord record) {
        this(Replicas.toArray(record.replicas()), Replicas.toArray(record.isr()), Replicas.toArray(record.removingReplicas()), Replicas.toArray(record.addingReplicas()), record.leader(), LeaderRecoveryState.of(record.leaderRecoveryState()), record.leaderEpoch(), record.partitionEpoch(), record.linkedLeaderEpoch(), LinkState.fromCode(record.linkState()));
    }

    public PartitionRegistration(int[] replicas, int[] isr, int[] removingReplicas, int[] addingReplicas, int leader, LeaderRecoveryState leaderRecoveryState, int leaderEpoch, int partitionEpoch, int linkedLeaderEpoch, LinkState linkState) {
        this.replicas = replicas;
        this.isr = isr;
        this.removingReplicas = removingReplicas;
        this.addingReplicas = addingReplicas;
        this.leader = leader;
        this.leaderRecoveryState = leaderRecoveryState;
        this.leaderEpoch = leaderEpoch;
        this.partitionEpoch = partitionEpoch;
        this.linkedLeaderEpoch = linkedLeaderEpoch;
        this.linkState = linkState;
    }

    public PartitionRegistration(int[] replicas, int[] isr, int[] removingReplicas, int[] addingReplicas, int leader, LeaderRecoveryState leaderRecoveryState, int leaderEpoch, int partitionEpoch) {
        this(replicas, isr, removingReplicas, addingReplicas, leader, leaderRecoveryState, leaderEpoch, partitionEpoch, -1, LinkState.NOT_MIRROR);
    }

    public PartitionRegistration merge(PartitionChangeRecord record) {
        int newLinkedLeaderEpoch;
        LinkState newLinkState;
        int newLeaderEpoch;
        int newLeader;
        int[] newReplicas = record.replicas() == null ? this.replicas : Replicas.toArray(record.replicas());
        int[] newIsr = record.isr() == null ? this.isr : Replicas.toArray(record.isr());
        int[] newRemovingReplicas = record.removingReplicas() == null ? this.removingReplicas : Replicas.toArray(record.removingReplicas());
        int[] newAddingReplicas = record.addingReplicas() == null ? this.addingReplicas : Replicas.toArray(record.addingReplicas());
        LinkState recordLinkState = LinkState.fromCode(record.linkState());
        if (this.linkState == LinkState.NOT_MIRROR && recordLinkState != LinkState.NOT_MIRROR) {
            throw new RuntimeException("Cannot merge a non-mirror partition registration with a mirror partition record");
        }
        if (record.leader() == -2) {
            newLeader = this.leader;
            newLeaderEpoch = this.linkState == LinkState.NOT_MIRROR ? this.leaderEpoch : Math.max(this.leaderEpoch, record.linkedLeaderEpoch());
        } else {
            newLeader = record.leader();
            newLeaderEpoch = this.linkState == LinkState.NOT_MIRROR ? this.leaderEpoch + 1 : Math.max(this.leaderEpoch + 1, record.linkedLeaderEpoch());
        }
        LeaderRecoveryState newLeaderRecoveryState = this.leaderRecoveryState.changeTo(record.leaderRecoveryState());
        if (this.linkState == LinkState.NOT_MIRROR) {
            newLinkState = this.linkState;
            newLinkedLeaderEpoch = this.linkedLeaderEpoch;
        } else {
            newLinkedLeaderEpoch = record.linkState() == LinkState.NOT_MIRROR.levelCode ? -1 : (record.linkedLeaderEpoch() == -1 ? this.linkedLeaderEpoch : record.linkedLeaderEpoch());
            newLinkState = recordLinkState;
        }
        return new PartitionRegistration(newReplicas, newIsr, newRemovingReplicas, newAddingReplicas, newLeader, newLeaderRecoveryState, newLeaderEpoch, this.partitionEpoch + 1, newLinkedLeaderEpoch, newLinkState);
    }

    public String diff(PartitionRegistration prev) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        if (!Arrays.equals(this.replicas, prev.replicas)) {
            builder.append(prefix).append("replicas: ").append(Arrays.toString(prev.replicas)).append(" -> ").append(Arrays.toString(this.replicas));
            prefix = ", ";
        }
        if (!Arrays.equals(this.isr, prev.isr)) {
            builder.append(prefix).append("isr: ").append(Arrays.toString(prev.isr)).append(" -> ").append(Arrays.toString(this.isr));
            prefix = ", ";
        }
        if (!Arrays.equals(this.removingReplicas, prev.removingReplicas)) {
            builder.append(prefix).append("removingReplicas: ").append(Arrays.toString(prev.removingReplicas)).append(" -> ").append(Arrays.toString(this.removingReplicas));
            prefix = ", ";
        }
        if (!Arrays.equals(this.addingReplicas, prev.addingReplicas)) {
            builder.append(prefix).append("addingReplicas: ").append(Arrays.toString(prev.addingReplicas)).append(" -> ").append(Arrays.toString(this.addingReplicas));
            prefix = ", ";
        }
        if (this.leader != prev.leader) {
            builder.append(prefix).append("leader: ").append(prev.leader).append(" -> ").append(this.leader);
            prefix = ", ";
        }
        if (this.leaderRecoveryState != prev.leaderRecoveryState) {
            builder.append(prefix).append("leaderRecoveryState: ").append((Object)prev.leaderRecoveryState).append(" -> ").append((Object)this.leaderRecoveryState);
            prefix = ", ";
        }
        if (this.leaderEpoch != prev.leaderEpoch) {
            builder.append(prefix).append("leaderEpoch: ").append(prev.leaderEpoch).append(" -> ").append(this.leaderEpoch);
            prefix = ", ";
        }
        if (this.partitionEpoch != prev.partitionEpoch) {
            builder.append(prefix).append("partitionEpoch: ").append(prev.partitionEpoch).append(" -> ").append(this.partitionEpoch);
        }
        return builder.toString();
    }

    public PartitionRegistration unlink() {
        return new PartitionRegistration(this.replicas, this.isr, this.removingReplicas, this.addingReplicas, this.leader, this.leaderRecoveryState, this.leaderEpoch, this.partitionEpoch + 1);
    }

    public void maybeLogPartitionChange(Logger log, String description, PartitionRegistration prev) {
        if (!PartitionRegistration.electionWasClean(this.leader, prev.isr)) {
            log.info("UNCLEAN partition change for {}: {}", (Object)description, (Object)this.diff(prev));
        } else if (log.isDebugEnabled()) {
            log.debug("partition change for {}: {}", (Object)description, (Object)this.diff(prev));
        }
    }

    public boolean hasLeader() {
        return this.leader != -1;
    }

    public boolean hasPreferredLeader() {
        return this.leader == this.preferredReplica();
    }

    public int preferredReplica() {
        return this.replicas.length == 0 ? -1 : this.replicas[0];
    }

    public boolean isMirror() {
        return this.linkState != LinkState.NOT_MIRROR;
    }

    public ApiMessageAndVersion toRecord(Uuid topicId, int partitionId) {
        return new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(partitionId).setTopicId(topicId).setReplicas(Replicas.toList(this.replicas)).setIsr(Replicas.toList(this.isr)).setRemovingReplicas(Replicas.toList(this.removingReplicas)).setAddingReplicas(Replicas.toList(this.addingReplicas)).setLeader(this.leader).setLeaderRecoveryState(this.leaderRecoveryState.value()).setLeaderEpoch(this.leaderEpoch).setPartitionEpoch(this.partitionEpoch).setLinkedLeaderEpoch(this.linkedLeaderEpoch).setLinkState(this.linkState.levelCode), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion());
    }

    public LeaderAndIsrRequestData.LeaderAndIsrPartitionState toLeaderAndIsrPartitionState(TopicPartition tp, boolean isNew, Optional<MirrorTopic> mirrorTopicOptional) {
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState state = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setControllerEpoch(-1).setLeader(this.leader).setLeaderEpoch(this.leaderEpoch).setIsr(Replicas.toList(this.isr)).setPartitionEpoch(this.partitionEpoch).setReplicas(Replicas.toList(this.replicas)).setAddingReplicas(Replicas.toList(this.addingReplicas)).setRemovingReplicas(Replicas.toList(this.removingReplicas)).setLeaderRecoveryState(this.leaderRecoveryState.value()).setIsNew(isNew);
        mirrorTopicOptional.ifPresent(mirrorTopic -> state.setLinkedLeaderEpoch(this.linkedLeaderEpoch).setClusterLinkTopicState(mirrorTopic.mirrorState().stateName()).setClusterLinkId(Utils.toJavaUuid((Uuid)mirrorTopic.linkId()).toString()).setClusterLinkSourceTopicId(mirrorTopic.sourceTopicId()));
        return state;
    }

    public boolean isReassigning() {
        return this.removingReplicas.length > 0 || this.addingReplicas.length > 0;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.replicas), Arrays.hashCode(this.isr), Arrays.hashCode(this.removingReplicas), Arrays.hashCode(this.addingReplicas), this.leader, this.leaderRecoveryState, this.leaderEpoch, this.partitionEpoch});
    }

    public boolean equals(Object o) {
        if (!(o instanceof PartitionRegistration)) {
            return false;
        }
        PartitionRegistration other = (PartitionRegistration)o;
        return Arrays.equals(this.replicas, other.replicas) && Arrays.equals(this.isr, other.isr) && Arrays.equals(this.removingReplicas, other.removingReplicas) && Arrays.equals(this.addingReplicas, other.addingReplicas) && this.leader == other.leader && this.leaderRecoveryState == other.leaderRecoveryState && this.leaderEpoch == other.leaderEpoch && this.partitionEpoch == other.partitionEpoch && this.linkedLeaderEpoch == other.linkedLeaderEpoch && this.linkState == other.linkState;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PartitionRegistration(");
        builder.append("replicas=").append(Arrays.toString(this.replicas));
        builder.append(", isr=").append(Arrays.toString(this.isr));
        builder.append(", removingReplicas=").append(Arrays.toString(this.removingReplicas));
        builder.append(", addingReplicas=").append(Arrays.toString(this.addingReplicas));
        builder.append(", leader=").append(this.leader);
        builder.append(", leaderRecoveryState=").append((Object)this.leaderRecoveryState);
        builder.append(", leaderEpoch=").append(this.leaderEpoch);
        builder.append(", partitionEpoch=").append(this.partitionEpoch);
        builder.append(", linkedLeaderEpoch=").append(this.linkedLeaderEpoch);
        builder.append(", linkState=").append((Object)this.linkState);
        builder.append(")");
        return builder.toString();
    }

    public static enum LinkState {
        FAILED(1),
        ACTIVE(0),
        NOT_MIRROR(-1);

        public final byte levelCode;

        private LinkState(int levelCode) {
            this.levelCode = (byte)levelCode;
        }

        public static LinkState fromCode(int linkState) {
            LinkState value = linkState == 0 ? ACTIVE : (linkState == 1 ? FAILED : NOT_MIRROR);
            return value;
        }
    }
}

