/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.AuthorizerNotReadyException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAuthorizerData {
    public static final String WILDCARD = "*";
    public static final String WILDCARD_PRINCIPAL = "User:*";
    public static final KafkaPrincipal WILDCARD_KAFKA_PRINCIPAL = new KafkaPrincipal("User", "*");
    final Logger log;
    final Logger auditLog;
    final AclMutator aclMutator;
    final boolean loadingComplete;
    private final Set<String> superUsers;
    private final DefaultRule noAclRule;
    private final TreeMap<StandardAcl, AclLinks> aclsByResource;
    private final HashMap<Uuid, ConfluentStandardAcl> aclsById;
    private static final Set<AclOperation> IMPLIES_DESCRIBE = Collections.unmodifiableSet(EnumSet.of(AclOperation.DESCRIBE, AclOperation.READ, AclOperation.WRITE, AclOperation.DELETE, AclOperation.ALTER));
    private static final Set<AclOperation> IMPLIES_DESCRIBE_CONFIGS = Collections.unmodifiableSet(EnumSet.of(AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS));

    private static Logger createLogger(int nodeId) {
        return new LogContext("[StandardAuthorizer " + nodeId + "] ").logger(StandardAuthorizerData.class);
    }

    private static Logger auditLogger() {
        return LoggerFactory.getLogger((String)"kafka.authorizer.logger");
    }

    static StandardAuthorizerData createEmpty() {
        return new StandardAuthorizerData(StandardAuthorizerData.createLogger(-1), null, false, Collections.emptySet(), AuthorizationResult.DENIED, new TreeMap<StandardAcl, AclLinks>(), new HashMap<Uuid, ConfluentStandardAcl>());
    }

    private StandardAuthorizerData(Logger log, AclMutator aclMutator, boolean loadingComplete, Set<String> superUsers, AuthorizationResult defaultResult, TreeMap<StandardAcl, AclLinks> aclsByResource, HashMap<Uuid, ConfluentStandardAcl> aclsById) {
        this.log = log;
        this.auditLog = StandardAuthorizerData.auditLogger();
        this.aclMutator = aclMutator;
        this.loadingComplete = loadingComplete;
        this.superUsers = superUsers;
        this.noAclRule = new DefaultRule(defaultResult);
        this.aclsByResource = aclsByResource;
        this.aclsById = aclsById;
    }

    StandardAuthorizerData copyWithNewAclMutator(AclMutator newAclMutator) {
        return new StandardAuthorizerData(this.log, newAclMutator, this.loadingComplete, this.superUsers, this.noAclRule.result, this.aclsByResource, this.aclsById);
    }

    StandardAuthorizerData copyWithNewLoadingComplete(boolean newLoadingComplete) {
        return new StandardAuthorizerData(this.log, this.aclMutator, newLoadingComplete, this.superUsers, this.noAclRule.result, this.aclsByResource, this.aclsById);
    }

    StandardAuthorizerData copyWithNewConfig(int nodeId, Set<String> newSuperUsers, AuthorizationResult newDefaultResult) {
        return new StandardAuthorizerData(StandardAuthorizerData.createLogger(nodeId), this.aclMutator, this.loadingComplete, newSuperUsers, newDefaultResult, this.aclsByResource, this.aclsById);
    }

    StandardAuthorizerData copyWithNewAcls(TreeMap<StandardAcl, AclLinks> aclsByResource, HashMap<Uuid, ConfluentStandardAcl> aclsById) {
        StandardAuthorizerData newData = new StandardAuthorizerData(this.log, this.aclMutator, this.loadingComplete, this.superUsers, this.noAclRule.result, aclsByResource, aclsById);
        this.log.info("Initialized with {} acl(s).", (Object)aclsById.size());
        return newData;
    }

    void addAcl(Uuid id, ConfluentStandardAcl acl) {
        try {
            ConfluentStandardAcl prevAcl = this.aclsById.putIfAbsent(id, acl);
            if (prevAcl != null) {
                throw new RuntimeException("An ACL with ID " + id + " already exists.");
            }
            Optional<Uuid> linkIdToAdd = acl.clusterLinkId();
            this.aclsByResource.compute(acl.standardAcl(), (k, v) -> {
                AclLinks links;
                AclLinks aclLinks = links = v == null ? new AclLinks() : v;
                if (!links.addLinkId(linkIdToAdd)) {
                    throw new IllegalStateException("aclsByResource already contains " + linkIdToAdd + " for " + k);
                }
                return links;
            });
            this.log.trace("Added ACL {}: {}", (Object)id, (Object)acl);
        }
        catch (Throwable e) {
            this.log.error("addAcl error", e);
            throw e;
        }
    }

    void removeAcl(Uuid id) {
        try {
            ConfluentStandardAcl acl = this.aclsById.remove(id);
            if (acl == null) {
                throw new RuntimeException("ID " + id + " not found in aclsById.");
            }
            AclLinks links = this.aclsByResource.get(acl.standardAcl());
            if (links == null) {
                throw new RuntimeException("ACL  " + acl + " not found in aclsByResource");
            }
            if (!links.removeLinkId(acl.clusterLinkId())) {
                throw new RuntimeException("Link ID for ACL " + acl + " not found in aclsByResource");
            }
            if (links.isEmpty() && this.aclsByResource.remove(acl.standardAcl()) == null) {
                throw new RuntimeException("Unable to remove the ACL with ID " + id + " from aclsByResource");
            }
            this.log.trace("Removed ACL {}: {}", (Object)id, (Object)acl);
        }
        catch (Throwable e) {
            this.log.error("removeAcl error", e);
            throw e;
        }
    }

    Set<String> superUsers() {
        return this.superUsers;
    }

    AuthorizationResult defaultResult() {
        return this.noAclRule.result;
    }

    int aclCount() {
        return this.aclsById.size();
    }

    public AuthorizationResult authorize(AuthorizableRequestContext requestContext, Action action) {
        MatchingRule rule;
        KafkaPrincipal principal = StandardAuthorizerData.baseKafkaPrincipal(requestContext);
        if (this.superUsers.contains(principal.toString())) {
            rule = SuperUserRule.INSTANCE;
        } else {
            if (!this.loadingComplete) {
                throw new AuthorizerNotReadyException();
            }
            MatchingRule aclRule = this.findAclRule(StandardAuthorizerData.matchingPrincipals(requestContext), requestContext.clientAddress().getHostAddress(), action);
            rule = aclRule != null ? aclRule : this.noAclRule;
        }
        this.logAuditMessage(principal, requestContext, action, rule);
        return rule.result();
    }

    public List<StandardAcl> findRulesByResourceType(ResourceType resourceType, AclOperation operation, Set<KafkaPrincipal> matchingPrincipals, String host) {
        StandardAcl exemplar = new StandardAcl(resourceType, "", PatternType.UNKNOWN, "", "", AclOperation.UNKNOWN, AclPermissionType.UNKNOWN);
        ArrayList<StandardAcl> matchingAcls = new ArrayList<StandardAcl>();
        NavigableSet<StandardAcl> candidateAcls = this.aclsByResource.navigableKeySet().headSet(exemplar, true);
        for (StandardAcl candidateAcl : candidateAcls) {
            if (candidateAcl.resourceType() != resourceType) break;
            if (candidateAcl.operation() != AclOperation.ALL && candidateAcl.operation() != operation || !matchingPrincipals.contains(candidateAcl.kafkaPrincipal()) || !candidateAcl.host().equals(WILDCARD) && !candidateAcl.host().equals(host)) continue;
            matchingAcls.add(candidateAcl);
        }
        return matchingAcls;
    }

    private String buildAuditMessage(KafkaPrincipal principal, AuthorizableRequestContext context, Action action, MatchingRule rule) {
        StringBuilder bldr = new StringBuilder();
        bldr.append("Principal = ").append(principal);
        bldr.append(" is ").append(rule.result() == AuthorizationResult.ALLOWED ? "Allowed" : "Denied");
        bldr.append(" operation = ").append(action.operation());
        bldr.append(" from host = ").append(context.clientAddress().getHostAddress());
        bldr.append(" on resource = ");
        this.appendResourcePattern(action.resourcePattern(), bldr);
        bldr.append(" for request = ").append(ApiKeys.forId((int)context.requestType()).name);
        bldr.append(" with resourceRefCount = ").append(action.resourceReferenceCount());
        bldr.append(" based on rule ").append(rule);
        return bldr.toString();
    }

    private void appendResourcePattern(ResourcePattern resourcePattern, StringBuilder bldr) {
        bldr.append(SecurityUtils.resourceTypeName((ResourceType)resourcePattern.resourceType())).append(":").append(resourcePattern.patternType()).append(":").append(resourcePattern.name());
    }

    private void logAuditMessage(KafkaPrincipal principal, AuthorizableRequestContext requestContext, Action action, MatchingRule rule) {
        switch (rule.result()) {
            case ALLOWED: {
                if (action.logIfAllowed() && this.auditLog.isDebugEnabled()) {
                    this.auditLog.debug(this.buildAuditMessage(principal, requestContext, action, rule));
                } else if (this.auditLog.isTraceEnabled()) {
                    this.auditLog.trace(this.buildAuditMessage(principal, requestContext, action, rule));
                }
                return;
            }
            case DENIED: {
                if (action.logIfDenied()) {
                    this.auditLog.info(this.buildAuditMessage(principal, requestContext, action, rule));
                    break;
                }
                if (!this.auditLog.isTraceEnabled()) break;
                this.auditLog.trace(this.buildAuditMessage(principal, requestContext, action, rule));
            }
        }
    }

    public MatchingRule findAclRule(Set<KafkaPrincipal> matchingPrincipals, String host, Action action) {
        MatchingRuleBuilder matchingRuleBuilder = new MatchingRuleBuilder(this.noAclRule);
        StandardAcl exemplar = new StandardAcl(action.resourcePattern().resourceType(), action.resourcePattern().name(), PatternType.UNKNOWN, "", "", AclOperation.UNKNOWN, AclPermissionType.UNKNOWN);
        this.checkSection(action, exemplar, matchingPrincipals, host, matchingRuleBuilder);
        if (matchingRuleBuilder.foundDeny()) {
            return matchingRuleBuilder.build();
        }
        exemplar = new StandardAcl(action.resourcePattern().resourceType(), WILDCARD, PatternType.LITERAL, "", "", AclOperation.UNKNOWN, AclPermissionType.UNKNOWN);
        this.checkSection(action, exemplar, matchingPrincipals, host, matchingRuleBuilder);
        return matchingRuleBuilder.build();
    }

    static int matchesUpTo(String resource, String pattern) {
        int i;
        for (i = 0; resource.length() != i && pattern.length() != i && resource.charAt(i) == pattern.charAt(i); ++i) {
        }
        return i;
    }

    private void checkSection(Action action, StandardAcl exemplar, Set<KafkaPrincipal> matchingPrincipals, String host, MatchingRuleBuilder matchingRuleBuilder) {
        StandardAcl acl;
        String resourceName = action.resourcePattern().name();
        NavigableSet<StandardAcl> tailSet = this.aclsByResource.navigableKeySet().tailSet(exemplar, true);
        Iterator<StandardAcl> iterator = tailSet.iterator();
        while (iterator.hasNext() && (acl = iterator.next()).resourceType().equals((Object)action.resourcePattern().resourceType())) {
            int matchesUpTo = StandardAuthorizerData.matchesUpTo(resourceName, acl.resourceName());
            if (matchesUpTo == acl.resourceName().length()) {
                if (acl.patternType() == PatternType.LITERAL && matchesUpTo != resourceName.length()) {
                    continue;
                }
            } else if (!acl.resourceName().equals(WILDCARD) || acl.patternType() != PatternType.LITERAL) {
                exemplar = new StandardAcl(exemplar.resourceType(), exemplar.resourceName().substring(0, matchesUpTo), exemplar.patternType(), exemplar.principal(), exemplar.host(), exemplar.operation(), exemplar.permissionType());
                tailSet = this.aclsByResource.navigableKeySet().tailSet(exemplar, true);
                iterator = tailSet.iterator();
                continue;
            }
            matchingRuleBuilder.hasResourceAcls = true;
            AuthorizationResult result = StandardAuthorizerData.findResult(action, matchingPrincipals, host, acl);
            if (AuthorizationResult.ALLOWED == result) {
                matchingRuleBuilder.allowAcl = acl;
                continue;
            }
            if (AuthorizationResult.DENIED != result) continue;
            matchingRuleBuilder.denyAcl = acl;
            return;
        }
    }

    static AuthorizationResult findResult(Action action, AuthorizableRequestContext requestContext, StandardAcl acl) {
        return StandardAuthorizerData.findResult(action, StandardAuthorizerData.matchingPrincipals(requestContext), requestContext.clientAddress().getHostAddress(), acl);
    }

    static KafkaPrincipal baseKafkaPrincipal(AuthorizableRequestContext context) {
        KafkaPrincipal sessionPrincipal = context.principal();
        return sessionPrincipal.getClass().equals(KafkaPrincipal.class) ? sessionPrincipal : new KafkaPrincipal(sessionPrincipal.getPrincipalType(), sessionPrincipal.getName());
    }

    static Set<KafkaPrincipal> matchingPrincipals(AuthorizableRequestContext context) {
        KafkaPrincipal sessionPrincipal = context.principal();
        KafkaPrincipal basePrincipal = sessionPrincipal.getClass().equals(KafkaPrincipal.class) ? sessionPrincipal : new KafkaPrincipal(sessionPrincipal.getPrincipalType(), sessionPrincipal.getName());
        return Utils.mkSet((Object[])new KafkaPrincipal[]{basePrincipal, WILDCARD_KAFKA_PRINCIPAL});
    }

    static AuthorizationResult findResult(Action action, Set<KafkaPrincipal> matchingPrincipals, String host, StandardAcl acl) {
        block10: {
            block11: {
                if (!matchingPrincipals.contains(acl.kafkaPrincipal())) {
                    return null;
                }
                if (!acl.host().equals(WILDCARD) && !acl.host().equals(host)) {
                    return null;
                }
                if (acl.operation() == AclOperation.ALL) break block10;
                if (!acl.permissionType().equals((Object)AclPermissionType.ALLOW)) break block11;
                switch (action.operation()) {
                    case DESCRIBE: {
                        if (!IMPLIES_DESCRIBE.contains(acl.operation())) {
                            return null;
                        }
                        break block10;
                    }
                    case DESCRIBE_CONFIGS: {
                        if (!IMPLIES_DESCRIBE_CONFIGS.contains(acl.operation())) {
                            return null;
                        }
                        break block10;
                    }
                    default: {
                        if (action.operation() != acl.operation()) {
                            return null;
                        }
                        break block10;
                    }
                }
            }
            if (action.operation() != acl.operation()) {
                return null;
            }
        }
        return acl.permissionType().equals((Object)AclPermissionType.ALLOW) ? AuthorizationResult.ALLOWED : AuthorizationResult.DENIED;
    }

    Iterable<AclBinding> acls(AclBindingFilter filter) {
        ArrayList<AclBinding> aclBindingList = new ArrayList<AclBinding>();
        this.aclsByResource.forEach((acl, links) -> {
            AclBinding aclBinding = acl.toBinding(links.aclBindingLinksIds());
            if (filter.matches(aclBinding)) {
                aclBindingList.add(aclBinding);
            }
        });
        return aclBindingList;
    }

    void clear() {
        this.aclsById.clear();
        this.aclsByResource.clear();
        this.superUsers.clear();
    }

    TreeMap<StandardAcl, AclLinks> getAclsByResource() {
        return this.aclsByResource;
    }

    HashMap<Uuid, ConfluentStandardAcl> getAclsById() {
        return this.aclsById;
    }

    private static class AclLinks {
        final HashSet<Uuid> linkIds = new HashSet();

        AclLinks() {
        }

        boolean removeLinkId(Optional<Uuid> linkId) {
            return this.linkIds.remove(linkId.orElse(Uuid.ZERO_UUID));
        }

        boolean addLinkId(Optional<Uuid> linkId) {
            return this.linkIds.add(linkId.orElse(Uuid.ZERO_UUID));
        }

        boolean isEmpty() {
            return this.linkIds.isEmpty();
        }

        Collection<Uuid> aclBindingLinksIds() {
            ArrayList<Uuid> copy = new ArrayList<Uuid>(this.linkIds);
            if (copy.size() == 1 && ((Uuid)copy.get(0)).equals((Object)Uuid.ZERO_UUID)) {
                return Collections.emptyList();
            }
            return copy;
        }
    }

    private static class MatchingRuleBuilder {
        private static final DefaultRule DENY_RULE = new DefaultRule(AuthorizationResult.DENIED);
        private final DefaultRule noAclRule;
        private StandardAcl denyAcl;
        private StandardAcl allowAcl;
        private boolean hasResourceAcls;

        private MatchingRuleBuilder(DefaultRule noAclRule) {
            this.noAclRule = noAclRule;
        }

        boolean foundDeny() {
            return this.denyAcl != null;
        }

        MatchingRule build() {
            if (this.denyAcl != null) {
                return new MatchingAclRule(this.denyAcl, AuthorizationResult.DENIED);
            }
            if (this.allowAcl != null) {
                return new MatchingAclRule(this.allowAcl, AuthorizationResult.ALLOWED);
            }
            if (!this.hasResourceAcls) {
                return this.noAclRule;
            }
            return DENY_RULE;
        }
    }

    public static class MatchingAclRule
    implements MatchingRule {
        private final StandardAcl acl;
        private final AuthorizationResult result;

        public MatchingAclRule(StandardAcl acl, AuthorizationResult result) {
            this.acl = acl;
            this.result = result;
        }

        public StandardAcl acl() {
            return this.acl;
        }

        @Override
        public AuthorizationResult result() {
            return this.result;
        }

        public String toString() {
            return "MatchingAcl(acl=" + this.acl + ")";
        }
    }

    public static class DefaultRule
    implements MatchingRule {
        private final AuthorizationResult result;

        public DefaultRule(AuthorizationResult result) {
            this.result = result;
        }

        @Override
        public AuthorizationResult result() {
            return this.result;
        }

        public String toString() {
            return this.result == AuthorizationResult.ALLOWED ? "DefaultAllow" : "DefaultDeny";
        }
    }

    public static class SuperUserRule
    implements MatchingRule {
        private static final SuperUserRule INSTANCE = new SuperUserRule();

        @Override
        public AuthorizationResult result() {
            return AuthorizationResult.ALLOWED;
        }

        public String toString() {
            return "SuperUser";
        }
    }

    public static interface MatchingRule {
        public AuthorizationResult result();
    }
}

