/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

@InterfaceStability.Unstable
public class PlacementSpec {
    private final int startPartition;
    private final int numPartitions;
    private final short numReplicas;
    private final String topicName;
    private final KafkaPrincipal principal;
    private final Set<Integer> excludedBrokerIds;

    public PlacementSpec(int startPartition, int numPartitions, short numReplicas, String topicName, KafkaPrincipal principal, Set<Integer> excludedBrokerIds) {
        this.startPartition = startPartition;
        this.numPartitions = numPartitions;
        this.numReplicas = numReplicas;
        this.topicName = topicName;
        this.principal = principal;
        this.excludedBrokerIds = excludedBrokerIds;
    }

    public int startPartition() {
        return this.startPartition;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public short numReplicas() {
        return this.numReplicas;
    }

    public String topicName() {
        return this.topicName;
    }

    public KafkaPrincipal principal() {
        return this.principal;
    }

    public Set<Integer> excludedBrokerIds() {
        return this.excludedBrokerIds;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(PlacementSpec.class)) {
            return false;
        }
        PlacementSpec other = (PlacementSpec)o;
        return this.startPartition == other.startPartition && this.numPartitions == other.numPartitions && this.numReplicas == other.numReplicas && this.topicName.equals(other.topicName) && this.principal.equals((Object)other.principal) && this.excludedBrokerIds.equals(other.excludedBrokerIds);
    }

    public int hashCode() {
        return Objects.hash(this.startPartition, this.numPartitions, this.numReplicas, this.topicName, this.principal, this.excludedBrokerIds);
    }

    public String toString() {
        return "PlacementSpec(startPartition=" + this.startPartition + ", numPartitions=" + this.numPartitions + ", numReplicas=" + this.numReplicas + ", topicName=" + this.topicName + ", principal=" + this.principal + ", excludedBrokerIds=" + this.excludedBrokerIds + ")";
    }
}

