/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class PartitionChangeRecordJsonConverter {
    public static PartitionChangeRecord read(JsonNode _node, short _version) {
        PartitionChangeRecord _object = new PartitionChangeRecord();
        JsonNode _partitionIdNode = _node.get("partitionId");
        if (_partitionIdNode == null) {
            throw new RuntimeException("PartitionChangeRecord: unable to locate field 'partitionId', which is mandatory in version " + _version);
        }
        _object.partitionId = MessageUtil.jsonNodeToInt((JsonNode)_partitionIdNode, (String)"PartitionChangeRecord");
        JsonNode _topicIdNode = _node.get("topicId");
        if (_topicIdNode == null) {
            throw new RuntimeException("PartitionChangeRecord: unable to locate field 'topicId', which is mandatory in version " + _version);
        }
        if (!_topicIdNode.isTextual()) {
            throw new RuntimeException("PartitionChangeRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.topicId = Uuid.fromString((String)_topicIdNode.asText());
        JsonNode _isrNode = _node.get("isr");
        if (_isrNode == null) {
            _object.isr = null;
        } else if (_isrNode.isNull()) {
            _object.isr = null;
        } else {
            if (!_isrNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_isrNode.size());
            _object.isr = _collection;
            for (JsonNode _element : _isrNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _leaderNode = _node.get("leader");
        _object.leader = _leaderNode == null ? -2 : MessageUtil.jsonNodeToInt((JsonNode)_leaderNode, (String)"PartitionChangeRecord");
        JsonNode _replicasNode = _node.get("replicas");
        if (_replicasNode == null) {
            _object.replicas = null;
        } else if (_replicasNode.isNull()) {
            _object.replicas = null;
        } else {
            if (!_replicasNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_replicasNode.size());
            _object.replicas = _collection;
            for (Object _element : _replicasNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _removingReplicasNode = _node.get("removingReplicas");
        if (_removingReplicasNode == null) {
            _object.removingReplicas = null;
        } else if (_removingReplicasNode.isNull()) {
            _object.removingReplicas = null;
        } else {
            if (!_removingReplicasNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_removingReplicasNode.size());
            _object.removingReplicas = _collection;
            for (Object _element : _removingReplicasNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _addingReplicasNode = _node.get("addingReplicas");
        if (_addingReplicasNode == null) {
            _object.addingReplicas = null;
        } else if (_addingReplicasNode.isNull()) {
            _object.addingReplicas = null;
        } else {
            if (!_addingReplicasNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_addingReplicasNode.size());
            _object.addingReplicas = _collection;
            for (JsonNode _element : _addingReplicasNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _leaderRecoveryStateNode = _node.get("leaderRecoveryState");
        _object.leaderRecoveryState = _leaderRecoveryStateNode == null ? (byte)-1 : MessageUtil.jsonNodeToByte((JsonNode)_leaderRecoveryStateNode, (String)"PartitionChangeRecord");
        JsonNode _linkedLeaderEpochNode = _node.get("linkedLeaderEpoch");
        _object.linkedLeaderEpoch = _linkedLeaderEpochNode == null ? -1 : MessageUtil.jsonNodeToInt((JsonNode)_linkedLeaderEpochNode, (String)"PartitionChangeRecord");
        JsonNode _linkStateNode = _node.get("linkState");
        _object.linkState = _linkStateNode == null ? (byte)-1 : MessageUtil.jsonNodeToByte((JsonNode)_linkStateNode, (String)"PartitionChangeRecord");
        JsonNode _observersNode = _node.get("observers");
        if (_observersNode == null) {
            _object.observers = null;
        } else if (_observersNode.isNull()) {
            _object.observers = null;
        } else {
            if (!_observersNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_observersNode.size());
            _object.observers = _collection;
            for (Object _element : _observersNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _deprecatedDoNotUseTag1003Node = _node.get("deprecatedDoNotUseTag1003");
        if (_deprecatedDoNotUseTag1003Node == null) {
            _object.deprecatedDoNotUseTag1003 = null;
        } else if (_deprecatedDoNotUseTag1003Node.isNull()) {
            _object.deprecatedDoNotUseTag1003 = null;
        } else {
            if (!_deprecatedDoNotUseTag1003Node.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_deprecatedDoNotUseTag1003Node.size());
            _object.deprecatedDoNotUseTag1003 = _collection;
            for (Object _element : _deprecatedDoNotUseTag1003Node) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _deprecatedDoNotUseTag1004Node = _node.get("deprecatedDoNotUseTag1004");
        if (_deprecatedDoNotUseTag1004Node == null) {
            _object.deprecatedDoNotUseTag1004 = null;
        } else if (_deprecatedDoNotUseTag1004Node.isNull()) {
            _object.deprecatedDoNotUseTag1004 = null;
        } else {
            if (!_deprecatedDoNotUseTag1004Node.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_deprecatedDoNotUseTag1004Node.size());
            _object.deprecatedDoNotUseTag1004 = _collection;
            for (Object _element : _deprecatedDoNotUseTag1004Node) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _removingObserversNode = _node.get("removingObservers");
        if (_removingObserversNode == null) {
            _object.removingObservers = null;
        } else if (_removingObserversNode.isNull()) {
            _object.removingObservers = null;
        } else {
            if (!_removingObserversNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_removingObserversNode.size());
            _object.removingObservers = _collection;
            for (Object _element : _removingObserversNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _addingObserversNode = _node.get("addingObservers");
        if (_addingObserversNode == null) {
            _object.addingObservers = null;
        } else if (_addingObserversNode.isNull()) {
            _object.addingObservers = null;
        } else {
            if (!_addingObserversNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_addingObserversNode.size());
            _object.addingObservers = _collection;
            for (Object _element : _addingObserversNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _directoriesNode = _node.get("directories");
        if (_directoriesNode == null) {
            _object.directories = null;
        } else if (_directoriesNode.isNull()) {
            _object.directories = null;
        } else {
            if (!_directoriesNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Uuid> _collection = new ArrayList<Uuid>(_directoriesNode.size());
            _object.directories = _collection;
            for (Object _element : _directoriesNode) {
                if (!_element.isTextual()) {
                    throw new RuntimeException("PartitionChangeRecord element expected a JSON string type, but got " + _node.getNodeType());
                }
                _collection.add(Uuid.fromString((String)_element.asText()));
            }
        }
        JsonNode _eligibleLeaderReplicasNode = _node.get("eligibleLeaderReplicas");
        if (_eligibleLeaderReplicasNode == null) {
            _object.eligibleLeaderReplicas = null;
        } else if (_eligibleLeaderReplicasNode.isNull()) {
            _object.eligibleLeaderReplicas = null;
        } else {
            if (!_eligibleLeaderReplicasNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_eligibleLeaderReplicasNode.size());
            _object.eligibleLeaderReplicas = _collection;
            for (JsonNode _element : _eligibleLeaderReplicasNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _lastKnownElrNode = _node.get("lastKnownElr");
        if (_lastKnownElrNode == null) {
            _object.lastKnownElr = null;
        } else if (_lastKnownElrNode.isNull()) {
            _object.lastKnownElr = null;
        } else {
            if (!_lastKnownElrNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_lastKnownElrNode.size());
            _object.lastKnownElr = _collection;
            for (JsonNode _element : _lastKnownElrNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        return _object;
    }

    public static JsonNode write(PartitionChangeRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("partitionId", (JsonNode)new IntNode(_object.partitionId));
        _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
        if (_object.isr != null) {
            ArrayNode _isrArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.isr) {
                _isrArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("isr", (JsonNode)_isrArray);
        }
        if (_object.leader != -2) {
            _node.set("leader", (JsonNode)new IntNode(_object.leader));
        }
        if (_object.replicas != null) {
            ArrayNode _replicasArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.replicas) {
                _replicasArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("replicas", (JsonNode)_replicasArray);
        }
        if (_object.removingReplicas != null) {
            ArrayNode _removingReplicasArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.removingReplicas) {
                _removingReplicasArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("removingReplicas", (JsonNode)_removingReplicasArray);
        }
        if (_object.addingReplicas != null) {
            ArrayNode _addingReplicasArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.addingReplicas) {
                _addingReplicasArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("addingReplicas", (JsonNode)_addingReplicasArray);
        }
        if (_object.leaderRecoveryState != -1) {
            _node.set("leaderRecoveryState", (JsonNode)new ShortNode((short)_object.leaderRecoveryState));
        }
        if (_object.linkedLeaderEpoch != -1) {
            _node.set("linkedLeaderEpoch", (JsonNode)new IntNode(_object.linkedLeaderEpoch));
        }
        if (_object.linkState != -1) {
            _node.set("linkState", (JsonNode)new ShortNode((short)_object.linkState));
        }
        if (_object.observers != null) {
            ArrayNode _observersArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.observers) {
                _observersArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("observers", (JsonNode)_observersArray);
        }
        if (_object.deprecatedDoNotUseTag1003 != null) {
            ArrayNode _deprecatedDoNotUseTag1003Array = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.deprecatedDoNotUseTag1003) {
                _deprecatedDoNotUseTag1003Array.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("deprecatedDoNotUseTag1003", (JsonNode)_deprecatedDoNotUseTag1003Array);
        }
        if (_object.deprecatedDoNotUseTag1004 != null) {
            ArrayNode _deprecatedDoNotUseTag1004Array = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.deprecatedDoNotUseTag1004) {
                _deprecatedDoNotUseTag1004Array.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("deprecatedDoNotUseTag1004", (JsonNode)_deprecatedDoNotUseTag1004Array);
        }
        if (_object.removingObservers != null) {
            ArrayNode _removingObserversArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.removingObservers) {
                _removingObserversArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("removingObservers", (JsonNode)_removingObserversArray);
        }
        if (_object.addingObservers != null) {
            ArrayNode _addingObserversArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.addingObservers) {
                _addingObserversArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("addingObservers", (JsonNode)_addingObserversArray);
        }
        if (_version >= 1) {
            if (_object.directories != null) {
                ArrayNode _directoriesArray = new ArrayNode(JsonNodeFactory.instance);
                for (Uuid uuid : _object.directories) {
                    _directoriesArray.add((JsonNode)new TextNode(uuid.toString()));
                }
                _node.set("directories", (JsonNode)_directoriesArray);
            }
        } else if (_object.directories != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default directories at version " + _version);
        }
        if (_version >= 2) {
            if (_object.eligibleLeaderReplicas != null) {
                ArrayNode _eligibleLeaderReplicasArray = new ArrayNode(JsonNodeFactory.instance);
                for (Integer n : _object.eligibleLeaderReplicas) {
                    _eligibleLeaderReplicasArray.add((JsonNode)new IntNode(n.intValue()));
                }
                _node.set("eligibleLeaderReplicas", (JsonNode)_eligibleLeaderReplicasArray);
            }
        } else if (_object.eligibleLeaderReplicas != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default eligibleLeaderReplicas at version " + _version);
        }
        if (_version >= 2) {
            if (_object.lastKnownElr != null) {
                ArrayNode _lastKnownElrArray = new ArrayNode(JsonNodeFactory.instance);
                for (Integer n : _object.lastKnownElr) {
                    _lastKnownElrArray.add((JsonNode)new IntNode(n.intValue()));
                }
                _node.set("lastKnownElr", (JsonNode)_lastKnownElrArray);
            }
        } else if (_object.lastKnownElr != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default lastKnownElr at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(PartitionChangeRecord _object, short _version) {
        return PartitionChangeRecordJsonConverter.write(_object, _version, true);
    }
}

