/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ReplicationControlManager;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashSet;

public class ImbalancedPartitions {
    private final Time time;
    private final SnapshotRegistry snapshotRegistry;
    private final int jvmWarmupMs;
    private final Map<Integer, BrokerImbalancedPartitionsState> brokerIdToBrokerState;
    private final Map<TopicIdPartition, BrokerImbalancedPartitionsState> topicIdPartitionToBrokerState;

    public ImbalancedPartitions(int jvmWarmupMs, SnapshotRegistry snapshotRegistry, Time time) {
        this.jvmWarmupMs = jvmWarmupMs;
        this.snapshotRegistry = snapshotRegistry;
        this.time = time;
        this.topicIdPartitionToBrokerState = new HashMap<TopicIdPartition, BrokerImbalancedPartitionsState>();
        this.brokerIdToBrokerState = new HashMap<Integer, BrokerImbalancedPartitionsState>();
    }

    public ImbalancedPartitionsIterator iterator() {
        return new ImbalancedPartitionsIterator();
    }

    public void add(TopicIdPartition topicIdPartition, ReplicationControlManager.TopicControlInfo topicInfo) {
        this.remove(topicIdPartition);
        int broker = ((PartitionRegistration)topicInfo.partitions().get((Object)Integer.valueOf((int)topicIdPartition.partitionId()))).replicas[0];
        BrokerImbalancedPartitionsState brokerState = this.brokerIdToBrokerState.get(broker);
        if (brokerState == null) {
            brokerState = new BrokerImbalancedPartitionsState(broker);
            this.brokerIdToBrokerState.put(broker, brokerState);
        }
        brokerState.add(topicIdPartition, topicInfo.name());
        this.topicIdPartitionToBrokerState.put(topicIdPartition, brokerState);
    }

    public void remove(TopicIdPartition topicIdPartition) {
        BrokerImbalancedPartitionsState oldBrokerState = this.topicIdPartitionToBrokerState.get(topicIdPartition);
        if (oldBrokerState != null) {
            oldBrokerState.remove(topicIdPartition);
            this.topicIdPartitionToBrokerState.remove(topicIdPartition);
            if (oldBrokerState.isEmpty()) {
                this.brokerIdToBrokerState.remove(oldBrokerState.brokerId);
            }
        }
    }

    public boolean isEmpty() {
        ImbalancedPartitionsIterator iterator = this.iterator();
        return !iterator.hasNextForInternalOrExternalPartitions();
    }

    public Set<TopicIdPartition> allImbalancedPartitions() {
        return this.topicIdPartitionToBrokerState.keySet();
    }

    public class ImbalancedPartitionsIterator
    implements Iterator<TopicIdPartition> {
        private List<Integer> brokerIds;
        private int currentBrokerIndex;
        private BrokerImbalancedPartitionsState.BrokerImbalancedPartitionIterator currentBrokerIterator;
        private boolean hasNextForExternalPartitions = false;

        ImbalancedPartitionsIterator() {
            if (ImbalancedPartitions.this.brokerIdToBrokerState.isEmpty()) {
                return;
            }
            this.brokerIds = new ArrayList(ImbalancedPartitions.this.brokerIdToBrokerState.keySet());
            this.currentBrokerIndex = 0;
            this.currentBrokerIterator = ((BrokerImbalancedPartitionsState)ImbalancedPartitions.this.brokerIdToBrokerState.get(this.brokerIds.get(this.currentBrokerIndex))).iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.brokerIds == null || this.brokerIds.isEmpty()) {
                return false;
            }
            boolean hasNext = this.currentBrokerIterator.hasNext();
            if (!hasNext && this.currentBrokerIterator.hasNextForExternalPartitions()) {
                this.hasNextForExternalPartitions = true;
            }
            while (!hasNext && this.currentBrokerIndex < this.brokerIds.size() - 1) {
                ++this.currentBrokerIndex;
                this.currentBrokerIterator = ((BrokerImbalancedPartitionsState)ImbalancedPartitions.this.brokerIdToBrokerState.get(this.brokerIds.get(this.currentBrokerIndex))).iterator();
                hasNext = this.currentBrokerIterator.hasNext();
            }
            return hasNext;
        }

        @Override
        public TopicIdPartition next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("no element in iterator");
            }
            return this.currentBrokerIterator.next();
        }

        public boolean hasNextForInternalOrExternalPartitions() {
            return this.hasNext() || this.hasNextForExternalPartitions;
        }
    }

    class BrokerImbalancedPartitionsState {
        private final int brokerId;
        private long lastInternalPartitionBalancedTimeMs;
        private final TimelineHashSet<TopicIdPartition> imbalancedInternalPartitions;
        private final TimelineHashSet<TopicIdPartition> imbalancedExternalPartitions;
        private final TimelineHashSet<TopicIdPartition> imbalancedCoordinatorPartitions;

        public BrokerImbalancedPartitionsState(int brokerId) {
            this.brokerId = brokerId;
            this.imbalancedInternalPartitions = new TimelineHashSet(ImbalancedPartitions.this.snapshotRegistry, 0);
            this.imbalancedExternalPartitions = new TimelineHashSet(ImbalancedPartitions.this.snapshotRegistry, 0);
            this.imbalancedCoordinatorPartitions = new TimelineHashSet(ImbalancedPartitions.this.snapshotRegistry, 0);
        }

        public void remove(TopicIdPartition topicIdPartition) {
            this.imbalancedInternalPartitions.remove((Object)topicIdPartition);
            this.imbalancedExternalPartitions.remove((Object)topicIdPartition);
            this.imbalancedCoordinatorPartitions.remove((Object)topicIdPartition);
        }

        private void add(TopicIdPartition topicIdPartition, String topicName) {
            if (Topic.isPreferredLeaderElectionWarmup((String)topicName)) {
                this.imbalancedInternalPartitions.add((Object)topicIdPartition);
            } else if (Topic.isCoordinatorTopics((String)topicName)) {
                this.imbalancedCoordinatorPartitions.add((Object)topicIdPartition);
            } else {
                this.imbalancedExternalPartitions.add((Object)topicIdPartition);
            }
        }

        public boolean isEmpty() {
            return this.imbalancedInternalPartitions.size() + this.imbalancedExternalPartitions.size() + this.imbalancedCoordinatorPartitions.size() == 0;
        }

        public BrokerImbalancedPartitionIterator iterator() {
            return new BrokerImbalancedPartitionIterator();
        }

        class BrokerImbalancedPartitionIterator
        implements Iterator<TopicIdPartition> {
            private final Iterator<TopicIdPartition> internalPartitionIterator;
            private final Iterator<TopicIdPartition> externalPartitionIterator;
            private final Iterator<TopicIdPartition> coordinatorPartitionIterator;
            private final long now;
            private boolean hasMovedCoordinatorPartition;

            BrokerImbalancedPartitionIterator() {
                this.internalPartitionIterator = BrokerImbalancedPartitionsState.this.imbalancedInternalPartitions.iterator();
                this.externalPartitionIterator = BrokerImbalancedPartitionsState.this.imbalancedExternalPartitions.iterator();
                this.coordinatorPartitionIterator = BrokerImbalancedPartitionsState.this.imbalancedCoordinatorPartitions.iterator();
                this.now = ImbalancedPartitions.this.time.milliseconds();
                this.hasMovedCoordinatorPartition = false;
            }

            @Override
            public boolean hasNext() {
                if (this.internalPartitionIterator.hasNext()) {
                    return true;
                }
                if (this.now - BrokerImbalancedPartitionsState.this.lastInternalPartitionBalancedTimeMs > (long)ImbalancedPartitions.this.jvmWarmupMs) {
                    return this.externalPartitionIterator.hasNext() || this.coordinatorPartitionIterator.hasNext();
                }
                return false;
            }

            @Override
            public TopicIdPartition next() {
                if (this.internalPartitionIterator.hasNext()) {
                    BrokerImbalancedPartitionsState.this.lastInternalPartitionBalancedTimeMs = ImbalancedPartitions.this.time.milliseconds();
                    return this.internalPartitionIterator.next();
                }
                if (this.now - BrokerImbalancedPartitionsState.this.lastInternalPartitionBalancedTimeMs > (long)ImbalancedPartitions.this.jvmWarmupMs) {
                    if (!this.hasMovedCoordinatorPartition && this.coordinatorPartitionIterator.hasNext()) {
                        this.hasMovedCoordinatorPartition = true;
                        return this.coordinatorPartitionIterator.next();
                    }
                    if (this.externalPartitionIterator.hasNext()) {
                        return this.externalPartitionIterator.next();
                    }
                    return this.coordinatorPartitionIterator.next();
                }
                throw new NoSuchElementException();
            }

            public boolean hasNextForExternalPartitions() {
                return this.externalPartitionIterator.hasNext() || this.coordinatorPartitionIterator.hasNext();
            }
        }
    }
}

