/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.metadata.ControllerRegistration;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.MetadataVersion;

public final class QuorumFeatures {
    public static final VersionRange DISABLED = VersionRange.of(0, 0);
    private final int nodeId;
    private final Map<String, VersionRange> localSupportedFeatures;
    private final List<Integer> quorumNodeIds;

    public static Optional<String> reasonNotSupported(short newVersion, String what, VersionRange range) {
        if (!range.contains(newVersion)) {
            if (range.max() == 0) {
                return Optional.of(what + " does not support this feature.");
            }
            return Optional.of(what + " only supports versions " + range);
        }
        return Optional.empty();
    }

    public static Map<String, VersionRange> defaultFeatureMap(boolean enableUnstable) {
        HashMap<String, VersionRange> features = new HashMap<String, VersionRange>(2);
        features.put("confluent.metadata.version", VersionRange.of(1, (int)(enableUnstable ? MetadataVersion.latestTesting().confluentFeatureLevel() : MetadataVersion.latestProduction().confluentFeatureLevel())));
        features.put("metadata.version", VersionRange.of(MetadataVersion.MINIMUM_KRAFT_VERSION.apacheFeatureLevel(), enableUnstable ? MetadataVersion.latestTesting().apacheFeatureLevel() : MetadataVersion.latestProduction().apacheFeatureLevel()));
        return features;
    }

    public QuorumFeatures(int nodeId, Map<String, VersionRange> localSupportedFeatures, List<Integer> quorumNodeIds) {
        this.nodeId = nodeId;
        this.localSupportedFeatures = Collections.unmodifiableMap(localSupportedFeatures);
        this.quorumNodeIds = Collections.unmodifiableList(quorumNodeIds);
    }

    public int nodeId() {
        return this.nodeId;
    }

    public Map<String, VersionRange> localSupportedFeatures() {
        return this.localSupportedFeatures;
    }

    public List<Integer> quorumNodeIds() {
        return this.quorumNodeIds;
    }

    public VersionRange localSupportedFeature(String name) {
        return this.localSupportedFeatures.getOrDefault(name, DISABLED);
    }

    public boolean isControllerId(int nodeId) {
        return this.quorumNodeIds.contains(nodeId);
    }

    public Optional<String> reasonNotLocallySupported(String featureName, short newVersion) {
        return QuorumFeatures.reasonNotSupported(newVersion, "Local controller " + this.nodeId, this.localSupportedFeature(featureName));
    }

    public Optional<String> reasonAllControllersZkMigrationNotReady(MetadataVersion metadataVersion, Map<Integer, ControllerRegistration> controllers) {
        if (!metadataVersion.isMigrationSupported()) {
            return Optional.of("Metadata version too low at " + metadataVersion);
        }
        if (!metadataVersion.isControllerRegistrationSupported()) {
            return Optional.empty();
        }
        for (int quorumNodeId : this.quorumNodeIds) {
            ControllerRegistration registration = controllers.get(quorumNodeId);
            if (registration == null) {
                return Optional.of("No registration found for controller " + quorumNodeId);
            }
            if (registration.zkMigrationReady()) continue;
            return Optional.of("Controller " + quorumNodeId + " has not enabled zookeeper.metadata.migration.enable");
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.localSupportedFeatures, this.quorumNodeIds);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(QuorumFeatures.class)) {
            return false;
        }
        QuorumFeatures other = (QuorumFeatures)o;
        return this.nodeId == other.nodeId && this.localSupportedFeatures.equals(other.localSupportedFeatures) && this.quorumNodeIds.equals(other.quorumNodeIds);
    }

    public String toString() {
        ArrayList features = new ArrayList();
        this.localSupportedFeatures.entrySet().forEach(f -> features.add((String)f.getKey() + ": " + f.getValue()));
        features.sort(String::compareTo);
        ArrayList nodeIds = new ArrayList();
        this.quorumNodeIds.forEach(id -> nodeIds.add("" + id));
        nodeIds.sort(String::compareTo);
        return "QuorumFeatures(nodeId=" + this.nodeId + ", localSupportedFeatures={" + features + "}, quorumNodeIds=[" + nodeIds + "])";
    }
}

