/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.DegradedBrokerHealthState;

class ControllerMetricsChanges {
    private int fencedBrokersChange = 0;
    private int activeBrokersChange = 0;
    private int migratingZkBrokersChange = 0;
    private int degradedBrokersChange = 0;
    private int degradedStorageBrokersChange = 0;
    private int degradedNetworkBrokersChange = 0;

    ControllerMetricsChanges() {
    }

    static int delta(boolean prev, boolean next) {
        if (prev) {
            return next ? 0 : -1;
        }
        return next ? 1 : 0;
    }

    public int fencedBrokersChange() {
        return this.fencedBrokersChange;
    }

    public int activeBrokersChange() {
        return this.activeBrokersChange;
    }

    public int migratingZkBrokersChange() {
        return this.migratingZkBrokersChange;
    }

    public int degradedBrokersChange() {
        return this.degradedBrokersChange;
    }

    public int degradedStorageBrokersChange() {
        return this.degradedStorageBrokersChange;
    }

    public int degradedNetworkBrokersChange() {
        return this.degradedNetworkBrokersChange;
    }

    void handleBrokerChange(BrokerRegistration prev, BrokerRegistration next) {
        boolean wasFenced = false;
        boolean wasActive = false;
        boolean wasZk = false;
        boolean wasDegraded = false;
        boolean wasDegradedStorage = false;
        boolean wasDegradedNetwork = false;
        if (prev != null) {
            wasFenced = prev.fenced();
            wasActive = !prev.fenced();
            wasZk = prev.isMigratingZkBroker();
            boolean bl = wasDegraded = !prev.degradedComponents().isEmpty();
            if (wasDegraded) {
                wasDegradedStorage = DegradedBrokerHealthState.containsDesiredDegradedComponent(prev.degradedComponents(), BrokerComponent.STORAGE);
                wasDegradedNetwork = DegradedBrokerHealthState.containsDesiredDegradedComponent(prev.degradedComponents(), BrokerComponent.NETWORK);
            }
        }
        boolean isFenced = false;
        boolean isActive = false;
        boolean isZk = false;
        boolean isDegraded = false;
        boolean isDegradedNetwork = false;
        boolean isDegradedStorage = false;
        if (next != null) {
            isFenced = next.fenced();
            isActive = !next.fenced();
            isZk = next.isMigratingZkBroker();
            boolean bl = isDegraded = !next.degradedComponents().isEmpty();
            if (isDegraded) {
                isDegradedStorage = DegradedBrokerHealthState.containsDesiredDegradedComponent(next.degradedComponents(), BrokerComponent.STORAGE);
                isDegradedNetwork = DegradedBrokerHealthState.containsDesiredDegradedComponent(next.degradedComponents(), BrokerComponent.NETWORK);
            }
        }
        this.fencedBrokersChange += ControllerMetricsChanges.delta(wasFenced, isFenced);
        this.activeBrokersChange += ControllerMetricsChanges.delta(wasActive, isActive);
        this.migratingZkBrokersChange += ControllerMetricsChanges.delta(wasZk, isZk);
        this.degradedBrokersChange += ControllerMetricsChanges.delta(wasDegraded, isDegraded);
        this.degradedStorageBrokersChange += ControllerMetricsChanges.delta(wasDegradedStorage, isDegradedStorage);
        this.degradedNetworkBrokersChange += ControllerMetricsChanges.delta(wasDegradedNetwork, isDegradedNetwork);
    }

    void apply(ControllerMetadataMetrics metrics) {
        if (this.fencedBrokersChange != 0) {
            metrics.addToFencedBrokerCount(this.fencedBrokersChange);
        }
        if (this.activeBrokersChange != 0) {
            metrics.addToActiveBrokerCount(this.activeBrokersChange);
        }
        if (this.migratingZkBrokersChange != 0) {
            metrics.addToMigratingZkBrokerCount(this.migratingZkBrokersChange);
        }
        if (this.degradedBrokersChange != 0) {
            metrics.addToBrokersWithDegradedHealthCount(this.degradedBrokersChange);
        }
        if (this.degradedStorageBrokersChange != 0) {
            metrics.addToBrokersWithDegradedStorageCount(this.degradedStorageBrokersChange);
        }
        if (this.degradedNetworkBrokersChange != 0) {
            metrics.addToBrokersWithDegradedNetworkCount(this.degradedNetworkBrokersChange);
        }
    }
}

