/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.node.MetadataLeafNode;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.TopicType;

public final class TopicImageNode
implements MetadataNode {
    private final TopicImage image;

    public TopicImageNode(TopicImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> childNames = new ArrayList<String>();
        childNames.add("name");
        childNames.add("id");
        if (this.image.topicType() != TopicType.STANDARD.id()) {
            childNames.add("type");
        }
        for (Integer partitionId : this.image.partitions().keySet()) {
            childNames.add(partitionId.toString());
        }
        return childNames;
    }

    @Override
    public MetadataNode child(String name) {
        Integer partitionId;
        if (name.equals("name")) {
            return new MetadataLeafNode(this.image.name());
        }
        if (name.equals("id")) {
            return new MetadataLeafNode(this.image.id().toString());
        }
        if (name.equals("type")) {
            Optional topicType = TopicType.forId((byte)this.image.topicType());
            return new MetadataLeafNode(String.valueOf(this.image.topicType()) + topicType.map(type -> " (" + type.logConfigValue() + ")").orElse(" (UNKNOWN)"));
        }
        try {
            partitionId = Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return null;
        }
        PartitionRegistration registration = this.image.partitions().get(partitionId);
        if (registration == null) {
            return null;
        }
        return new MetadataLeafNode(registration.toString());
    }
}

