/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.lang.reflect.Constructor;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.metadata.InstallMetadataEncryptorRecord;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorConfigEntry;
import org.apache.kafka.metadata.MetadataEncryptorSecrets;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;

public class MetadataEncryptorFactory {
    public static final MetadataEncryptorFactory NO_ENCRYPTION_FACTORY = new MetadataEncryptorFactory();
    public static final String ACTIVE = "confluent.metadata.active.encryptor";
    public static final String CLASSES = "confluent.metadata.encryptor.classes";
    public static final String SECRETS = "confluent.metadata.encryptor.secrets";
    public static final OffsetDateTime UNIX_EPOCH = OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    public static final long NO_OP_ENCRYPTOR_CREATE_TIME_MILLIS_SINCE_EPOCH = -62125920000000L;
    private final Map<Uuid, MetadataEncryptorConfig> configs;
    private final Set<Uuid> legacyEncryptorIds;
    private final Uuid activeIdFromLegacyConfig;

    private static Uuid parseUuid(String value) {
        try {
            return Uuid.fromString((String)value);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Unable to parse confluent.metadata.active.encryptor", (Throwable)e);
        }
    }

    private static Map<Uuid, String> parseKeyMap(String config, String value) {
        try {
            return MetadataEncryptorFactory.parseCompoundConfigValue(value);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Unable to parse " + config, (Throwable)e);
        }
    }

    private static MetadataEncryptorSecrets parseFile(String pathToFile) {
        if (pathToFile.equals("")) {
            return null;
        }
        try {
            File secretFile = new File(pathToFile);
            return (MetadataEncryptorSecrets)MetadataEncryptorFactory.getNewObjectMapper().readValue(secretFile, MetadataEncryptorSecrets.class);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Metadata encryption secrets could not be loaded from " + pathToFile, (Throwable)e);
        }
    }

    private static byte[] decodeSecret(String secretString) {
        try {
            byte[] secret = Base64.getUrlDecoder().decode(secretString);
            return secret;
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Unable to base64 decode secretString " + secretString, (Throwable)e);
        }
    }

    public MetadataEncryptorFactory() {
        this(Collections.emptyMap());
    }

    public MetadataEncryptorFactory(Map<String, Object> configs) {
        this(MetadataEncryptorFactory.parseUuid(configs.getOrDefault(ACTIVE, Uuid.ZERO_UUID).toString()), MetadataEncryptorFactory.parseKeyMap(CLASSES, configs.getOrDefault(CLASSES, "").toString()), MetadataEncryptorFactory.parseKeyMap(SECRETS, configs.getOrDefault(SECRETS, "").toString()), MetadataEncryptorFactory.parseFile(configs.getOrDefault("confluent.metadata.encryptor.secret.file", "").toString()));
    }

    public static MetadataEncryptorFactory fromProperties(Properties configs) {
        return new MetadataEncryptorFactory(MetadataEncryptorFactory.parseUuid(configs.getOrDefault((Object)ACTIVE, Uuid.ZERO_UUID).toString()), MetadataEncryptorFactory.parseKeyMap(CLASSES, configs.getOrDefault((Object)CLASSES, "").toString()), MetadataEncryptorFactory.parseKeyMap(SECRETS, configs.getOrDefault((Object)SECRETS, "").toString()), MetadataEncryptorFactory.parseFile(configs.getOrDefault((Object)"confluent.metadata.encryptor.secret.file", "").toString()));
    }

    static ObjectMapper getNewObjectMapper() {
        return new ObjectMapper();
    }

    private MetadataEncryptorFactory(Uuid activeIdFromLegacyConfig, Map<Uuid, String> uuidsToClasses, Map<Uuid, String> uuidsToSecrets, MetadataEncryptorSecrets secretsFromFile) {
        this.activeIdFromLegacyConfig = activeIdFromLegacyConfig;
        HashMap<Uuid, MetadataEncryptorConfig> newConfigs = new HashMap<Uuid, MetadataEncryptorConfig>();
        for (Map.Entry<Uuid, String> entry : uuidsToClasses.entrySet()) {
            Uuid uuid = entry.getKey();
            String className = entry.getValue();
            String secretString = uuidsToSecrets.get(uuid);
            if (secretString == null) {
                throw new InvalidConfigurationException("No secret configured for " + uuid);
            }
            byte[] secret = MetadataEncryptorFactory.decodeSecret(secretString);
            newConfigs.put(uuid, new MetadataEncryptorConfig(UNIX_EPOCH, className, secret));
        }
        this.legacyEncryptorIds = Collections.unmodifiableSet(uuidsToClasses.keySet());
        if (secretsFromFile != null && secretsFromFile.entries().size() != 0) {
            for (Map.Entry<Object, Object> entry : secretsFromFile.entries().entrySet()) {
                MetadataEncryptorConfigEntry configEntry = (MetadataEncryptorConfigEntry)entry.getValue();
                newConfigs.put(MetadataEncryptorFactory.parseUuid((String)entry.getKey()), new MetadataEncryptorConfig(configEntry.getCreated().toInstant().atOffset(ZoneOffset.UTC), configEntry.getClassName(), MetadataEncryptorFactory.decodeSecret(configEntry.getBytes())));
            }
        }
        this.configs = Collections.unmodifiableMap(newConfigs);
    }

    private static Map<Uuid, String> parseCompoundConfigValue(String value) {
        String[] inners = value.split(",");
        HashMap<Uuid, String> results = new HashMap<Uuid, String>();
        for (String inner : inners) {
            String effectiveInner = inner.trim();
            if (effectiveInner.isEmpty()) continue;
            int equalsIndex = effectiveInner.indexOf(61);
            if (equalsIndex < 0) {
                throw new RuntimeException("Invalid format: no equals sign found in entry.");
            }
            String uuidString = effectiveInner.substring(0, equalsIndex);
            Uuid uuid = Uuid.fromString((String)uuidString);
            results.put(uuid, effectiveInner.substring(equalsIndex + 1));
        }
        return results;
    }

    public MetadataEncryptor createFromConfig(InstallMetadataEncryptorRecord record) {
        return this.createFromConfig(record.keyId());
    }

    public boolean hasKeyConfiguration(Uuid keyId) {
        return this.configs.containsKey(keyId);
    }

    public MetadataEncryptor createFromConfig(Uuid id) {
        MetadataEncryptor encryptor;
        Constructor<?> constructor;
        Class<?> clazz;
        if (id == null) {
            throw new IllegalStateException("encryptor Id can't be null");
        }
        if (id.equals((Object)Uuid.ZERO_UUID)) {
            return NoOpMetadataEncryptor.INSTANCE;
        }
        MetadataEncryptorConfig config = this.configs.get(id);
        if (config == null) {
            throw new InvalidConfigurationException("No configuration found for metadata encryptor " + id);
        }
        try {
            clazz = Class.forName(config.className);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load class " + config.className + " for metadata encryptor " + id, e);
        }
        try {
            constructor = clazz.getConstructor(Uuid.class, byte[].class);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load constructor for " + config.className + " for metadata encryptor " + id, e);
        }
        try {
            encryptor = (MetadataEncryptor)constructor.newInstance(id, config.secret);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new RuntimeException("Problem invoking constructor for " + config.className + " for metadata encryptor " + id, e);
        }
        return encryptor;
    }

    public MetadataEncryptor createRandom(String className) {
        MetadataEncryptor encryptor;
        Constructor<?> constructor;
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load class " + className + " for new random metadata encryptor.", e);
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load constructor for " + className + " for new random metadata encryptor.", e);
        }
        try {
            encryptor = (MetadataEncryptor)constructor.newInstance(new Object[0]);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new RuntimeException("Problem invoking constructor for " + className + " for new random metadata encryptor.", e);
        }
        return encryptor;
    }

    public boolean isAwareOfAtLeastOneEncryptor() {
        return !this.activeIdFromLegacyConfig.equals((Object)Uuid.ZERO_UUID) || this.configs.size() != 0;
    }

    public Uuid activeIdFromLegacyConfig() {
        return this.activeIdFromLegacyConfig;
    }

    public Set<Uuid> legacyEncryptorIds() {
        return this.legacyEncryptorIds;
    }

    public Set<Uuid> getAllKnownEncryptorIds() {
        return Collections.unmodifiableSet(this.configs.keySet());
    }

    public long getCreateTimeMillisSinceEpoch(Uuid encryptorId) {
        if (encryptorId.equals((Object)Uuid.ZERO_UUID)) {
            return -62125920000000L;
        }
        MetadataEncryptorConfig encryptorConfig = this.configs.get(encryptorId);
        if (encryptorConfig == null) {
            throw new IllegalArgumentException("Unknown encryptor ID " + encryptorId);
        }
        long retval = encryptorConfig.created.toInstant().toEpochMilli();
        return retval;
    }

    public Set<Uuid> getNewerKnownEncryptorIds(Set<Uuid> encryptorIds, Uuid activeEncryptorId) {
        if (activeEncryptorId.equals((Object)Uuid.ZERO_UUID)) {
            return Collections.unmodifiableSet(encryptorIds.stream().filter(this::hasKeyConfiguration).collect(Collectors.toSet()));
        }
        MetadataEncryptorConfig activeEncryptorConfig = this.configs.get(activeEncryptorId);
        if (activeEncryptorConfig == null) {
            throw new IllegalStateException("Unknown supposedly-active encryptor ID " + activeEncryptorId + " (should never happen)");
        }
        OffsetDateTime activeEncryptorCreateDate = activeEncryptorConfig.created;
        if (activeEncryptorCreateDate == null) {
            throw new IllegalStateException("Unknown creation date for encryptor " + activeEncryptorId + " (should never happen)");
        }
        return Collections.unmodifiableSet(encryptorIds.stream().filter(e -> this.hasKeyConfiguration((Uuid)e) && activeEncryptorCreateDate.isBefore(this.configs.get((Object)e).created)).collect(Collectors.toSet()));
    }

    public OffsetDateTime getCreateDateForEncryptor(Uuid encryptorId) {
        MetadataEncryptorConfig metadataEncryptorConfig = this.configs.get(encryptorId);
        if (metadataEncryptorConfig == null) {
            return null;
        }
        return metadataEncryptorConfig.created;
    }

    static class MetadataEncryptorConfig {
        final OffsetDateTime created;
        final String className;
        final byte[] secret;

        MetadataEncryptorConfig(OffsetDateTime created, String className, byte[] secret) {
            this.created = created;
            this.className = className;
            this.secret = secret;
        }
    }
}

